/*
 * Decompiled with CFR 0.152.
 */
package codechicken.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;

public class ClassHierarchyManager {
    public static final HashMap<String, SuperCache> superclasses = new HashMap();
    private static final List<Function<String, byte @Nullable []>> CLASS_BYTE_LOOKUPS = new ArrayList<Function<String, byte[]>>(0);

    public static void addByteLookupFunc(Function<String, byte @Nullable []> func) {
        CLASS_BYTE_LOOKUPS.add(func);
    }

    public static boolean classExtends(String name, String superclass) {
        if (name.equals(superclass)) {
            return true;
        }
        SuperCache cache = ClassHierarchyManager.declareClass(name);
        if (cache == null) {
            return false;
        }
        cache.flatten();
        return cache.parents.contains(superclass);
    }

    private static SuperCache declareClass(String name) {
        SuperCache cache = superclasses.get(name);
        if (cache != null) {
            return cache;
        }
        for (Function<String, byte[]> func : CLASS_BYTE_LOOKUPS) {
            try {
                byte[] bytes = func.apply(name);
                if (bytes == null) continue;
                cache = ClassHierarchyManager.declareASM(bytes);
                break;
            }
            catch (Throwable throwable) {
            }
        }
        if (cache != null) {
            return cache;
        }
        try {
            cache = ClassHierarchyManager.declareReflection(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return cache;
    }

    private static SuperCache declareReflection(String name) throws ClassNotFoundException {
        Class<?> aclass = Class.forName(name);
        SuperCache cache = ClassHierarchyManager.getOrCreateCache(name);
        if (aclass.isInterface()) {
            cache.superclass = "java.lang.Object";
        } else {
            if (name.equals("java.lang.Object")) {
                return cache;
            }
            cache.superclass = aclass.getSuperclass().getName();
        }
        cache.add(cache.superclass);
        for (Class<?> iclass : aclass.getInterfaces()) {
            cache.add(iclass.getName());
        }
        return cache;
    }

    private static SuperCache declareASM(@Nonnull byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        String name = reader.getClassName();
        SuperCache cache = ClassHierarchyManager.getOrCreateCache(name);
        cache.superclass = reader.getSuperName().replace('/', '.');
        cache.add(cache.superclass);
        for (String iclass : reader.getInterfaces()) {
            cache.add(iclass.replace('/', '.'));
        }
        return cache;
    }

    public static void declare(@Nonnull String name, @Nonnull byte[] bytes) {
        if (!superclasses.containsKey(name)) {
            ClassHierarchyManager.declareASM(bytes);
        }
    }

    @Nonnull
    public static SuperCache getOrCreateCache(@Nonnull String name) {
        return superclasses.computeIfAbsent(name, k -> new SuperCache());
    }

    public static String getSuperClass(@Nonnull String name) {
        SuperCache cache = ClassHierarchyManager.declareClass(name);
        if (cache == null) {
            return "java.lang.Object";
        }
        cache.flatten();
        return cache.superclass;
    }

    public static class SuperCache {
        String superclass;
        public Set<String> parents = new HashSet<String>();
        private boolean flattened;

        public void add(String parent) {
            this.parents.add(parent);
        }

        public void flatten() {
            if (this.flattened) {
                return;
            }
            for (String s : new ArrayList<String>(this.parents)) {
                SuperCache c = ClassHierarchyManager.declareClass(s);
                if (c == null) continue;
                c.flatten();
                this.parents.addAll(c.parents);
            }
            this.flattened = true;
        }
    }
}

