/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.tlc.config;

import com.google.common.collect.Lists;
import com.teamremastered.tlc.TheLostCastle;
import com.teamremastered.tlc.config.TLCConfigGenericEntry;
import java.util.ArrayList;

public class TLCConfigListEntry
extends TLCConfigGenericEntry<String> {
    public TLCConfigListEntry(String id, String comment, ArrayList<String> default_value) {
        super(id, comment, TLCConfigListEntry.getStringFromList(default_value));
    }

    public TLCConfigListEntry(String id, String comment, String default_value) {
        super(id, comment, default_value);
    }

    public ArrayList<String> getList() {
        String str = (String)this.getRaw();
        if (str.length() < 2 || str.charAt(0) != '[' || str.charAt(str.length() - 1) != ']') {
            TheLostCastle.LOGGER.error(String.format("Invalid value for list: %s", str));
            str = (String)this.DEFAULT_VALUE;
        }
        return Lists.newArrayList((Object[])str.substring(1, str.length() - 1).split(",\\s*"));
    }

    @Override
    public void set(ArrayList<String> value) {
        this.set(TLCConfigListEntry.getStringFromList(value));
    }

    private static String getStringFromList(ArrayList<String> lst) {
        return "[" + String.join((CharSequence)", ", lst) + "]";
    }
}

