/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.menus.base;

import earth.terrarium.adastra.common.compat.cadmus.CadmusIntegration;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.handlers.LaunchingDimensionHandler;
import earth.terrarium.adastra.common.handlers.SpaceStationHandler;
import earth.terrarium.adastra.common.handlers.base.SpaceStation;
import earth.terrarium.adastra.common.menus.PlanetsMenu;
import earth.terrarium.adastra.common.planets.AdAstraData;
import earth.terrarium.botarium.common.menu.ExtraDataMenuProvider;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class PlanetsMenuProvider
implements ExtraDataMenuProvider {
    public Component m_5446_() {
        return Component.m_237119_();
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new PlanetsMenu(containerId, inventory, Set.of(), Map.of(), (Object2BooleanMap<ResourceKey<Level>>)Object2BooleanMaps.emptyMap(), Set.of());
    }

    public void writeExtraData(ServerPlayer player, FriendlyByteBuf buffer) {
        buffer.m_130070_(AdAstraConfig.disabledPlanets);
        buffer.m_130130_(AdAstraData.planets().size());
        AdAstraData.planets().keySet().forEach(dimension -> {
            buffer.m_236858_(dimension);
            Map<UUID, Set<SpaceStation>> spaceStations = SpaceStationHandler.getAllSpaceStations(player.f_8924_.m_129880_(dimension));
            buffer.m_130130_(spaceStations.size());
            spaceStations.forEach((id, stations) -> {
                buffer.m_130130_(stations.size());
                stations.forEach(station -> {
                    buffer.m_130083_(station.name());
                    buffer.m_178341_(station.position());
                });
                buffer.m_130077_(id);
            });
        });
        if (CadmusIntegration.cadmusLoaded()) {
            buffer.m_130130_(AdAstraData.planets().size());
            AdAstraData.planets().keySet().forEach(dimension -> {
                buffer.m_236858_(dimension);
                buffer.writeBoolean(CadmusIntegration.isClaimed(player.f_8924_.m_129880_(dimension), player.m_146902_()));
            });
        }
        ArrayList locations = new ArrayList();
        AdAstraData.planets().forEach((dimension, planet) -> LaunchingDimensionHandler.getSpawningLocation((Player)player, player.m_284548_(), planet).ifPresent(locations::add));
        buffer.m_130130_(locations.size());
        locations.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_236814_(arg_0));
    }

    public static Set<ResourceLocation> createDisabledPlanetsFromBuf(FriendlyByteBuf buf) {
        String[] planets;
        HashSet<ResourceLocation> disabledPlanets = new HashSet<ResourceLocation>();
        for (String planet : planets = buf.m_130277_().split(",")) {
            disabledPlanets.add(new ResourceLocation(planet));
        }
        return Collections.unmodifiableSet(disabledPlanets);
    }

    public static Map<ResourceKey<Level>, Map<UUID, Set<SpaceStation>>> createSpaceStationsFromBuf(FriendlyByteBuf buf) {
        HashMap spaceStationsMap = new HashMap();
        int planetsSize = buf.m_130242_();
        for (int i = 0; i < planetsSize; ++i) {
            ResourceKey planetKey = buf.m_236801_(Registries.f_256858_);
            int spaceStationsSize = buf.m_130242_();
            HashMap spaceStationGroupMap = new HashMap();
            for (int j = 0; j < spaceStationsSize; ++j) {
                int stationGroupSize = buf.m_130242_();
                HashSet<SpaceStation> spaceStations = new HashSet<SpaceStation>();
                for (int k = 0; k < stationGroupSize; ++k) {
                    Component stationName = buf.m_130238_();
                    ChunkPos stationPos = buf.m_178383_();
                    spaceStations.add(new SpaceStation(stationPos, stationName));
                }
                UUID id = buf.m_130259_();
                spaceStationGroupMap.put(id, spaceStations);
            }
            spaceStationsMap.put(planetKey, spaceStationGroupMap);
        }
        return Collections.unmodifiableMap(spaceStationsMap);
    }

    public static Object2BooleanMap<ResourceKey<Level>> createClaimedChunksFromBuf(FriendlyByteBuf buf) {
        if (CadmusIntegration.cadmusLoaded()) {
            int dimensionCount = buf.m_130242_();
            Object2BooleanOpenHashMap claimedChunks = new Object2BooleanOpenHashMap();
            for (int i = 0; i < dimensionCount; ++i) {
                ResourceKey dimension = buf.m_236801_(Registries.f_256858_);
                claimedChunks.put((Object)dimension, buf.readBoolean());
            }
            return Object2BooleanMaps.unmodifiable((Object2BooleanMap)claimedChunks);
        }
        return Object2BooleanMaps.emptyMap();
    }

    public static Set<GlobalPos> createSpawnLocationsFromBuf(FriendlyByteBuf buf) {
        HashSet<GlobalPos> locations = new HashSet<GlobalPos>();
        int locationCount = buf.m_130242_();
        for (int i = 0; i < locationCount; ++i) {
            locations.add(buf.m_236872_());
        }
        return Collections.unmodifiableSet(locations);
    }
}

