/*
 * Decompiled with CFR 0.152.
 */
package com.struxnet.sgjadditions.common.blocks;

import com.struxnet.sgjadditions.common.block_entities.AtlantisDHDEntity;
import com.struxnet.sgjadditions.common.init.BlockEntityInit;
import com.struxnet.sgjadditions.common.init.BlockInit;
import com.struxnet.sgjadditions.common.menu.AtlantisDHDMenu;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.blocks.dhd.AbstractDHDBlock;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.crystals.CommunicationCrystalItem;
import net.povstalec.sgjourney.common.items.crystals.EnergyCrystalItem;
import net.povstalec.sgjourney.common.items.crystals.TransferCrystalItem;
import net.povstalec.sgjourney.common.misc.InventoryHelper;
import net.povstalec.sgjourney.common.misc.InventoryUtil;

public class AtlantisDHDBlock
extends AbstractDHDBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public AtlantisDHDBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        super.m_7926_(state);
        state.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AtlantisDHDEntity(pos, state);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        if (!level.m_5776_()) {
            final BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof AbstractDHDEntity) {
                AbstractDHDEntity dhd = (AbstractDHDEntity)blockEntity;
                if (player.m_6144_()) {
                    this.openCrystalMenu(player, blockEntity);
                } else {
                    MenuProvider containerProvider = new MenuProvider(){

                        public Component m_5446_() {
                            return Component.m_237115_((String)"screen.sgjourney.dhd");
                        }

                        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                            return new AtlantisDHDMenu(windowId, playerInventory, blockEntity);
                        }
                    };
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)blockEntity.m_58899_());
                }
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public Block getDHD() {
        return (Block)BlockInit.Atlantis_DHD.get();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return AtlantisDHDBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BlockEntityInit.Atlantis_DHD.get()), AbstractDHDEntity::tick);
    }

    public static ItemStack pegasusCrystalSetup() {
        ItemStack stack = new ItemStack((ItemLike)BlockInit.Atlantis_DHD.get());
        CompoundTag blockEntityTag = new CompoundTag();
        CompoundTag inventory = new CompoundTag();
        blockEntityTag.m_128359_("id", "sgjourney:Atlantis_dhd");
        blockEntityTag.m_128356_("Energy", 0L);
        inventory.m_128405_("Size", 9);
        inventory.m_128365_("Items", (Tag)AtlantisDHDBlock.setupAtlantisInventory());
        blockEntityTag.m_128365_("Inventory", (Tag)inventory);
        stack.m_41700_("BlockEntityTag", (Tag)blockEntityTag);
        return stack;
    }

    private static ListTag setupAtlantisInventory() {
        ListTag nbtTagList = new ListTag();
        nbtTagList.add((Object)InventoryHelper.addItem((int)0, (String)InventoryUtil.itemName((Item)((Item)ItemInit.ADVANCED_CONTROL_CRYSTAL.get())), (int)1, null));
        nbtTagList.add((Object)InventoryHelper.addItem((int)1, (String)InventoryUtil.itemName((Item)((Item)ItemInit.ADVANCED_ENERGY_CRYSTAL.get())), (int)1, (CompoundTag)EnergyCrystalItem.tagSetup((int)0)));
        nbtTagList.add((Object)InventoryHelper.addItem((int)2, (String)InventoryUtil.itemName((Item)((Item)ItemInit.ADVANCED_COMMUNICATION_CRYSTAL.get())), (int)1, (CompoundTag)CommunicationCrystalItem.tagSetup((int)0)));
        nbtTagList.add((Object)InventoryHelper.addItem((int)3, (String)InventoryUtil.itemName((Item)((Item)ItemInit.ADVANCED_ENERGY_CRYSTAL.get())), (int)1, (CompoundTag)EnergyCrystalItem.tagSetup((int)0)));
        nbtTagList.add((Object)InventoryHelper.addItem((int)6, (String)InventoryUtil.itemName((Item)((Item)ItemInit.ADVANCED_COMMUNICATION_CRYSTAL.get())), (int)1, (CompoundTag)CommunicationCrystalItem.tagSetup((int)0)));
        nbtTagList.add((Object)InventoryHelper.addItem((int)7, (String)InventoryUtil.itemName((Item)((Item)ItemInit.ADVANCED_TRANSFER_CRYSTAL.get())), (int)1, (CompoundTag)TransferCrystalItem.tagSetup((int)5000)));
        return nbtTagList;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag list1;
        CompoundTag blockEntityTag;
        ListTag tagList;
        if (stack.m_41782_() && (tagList = (blockEntityTag = BlockItem.m_186336_((ItemStack)stack)).m_128469_("Inventory").m_128437_("Items", 10)).size() > 0 && (list1 = tagList.m_128728_(0)).m_128425_("id", 8) && list1.m_128461_("id").equals(InventoryUtil.itemName((Item)((Item)ItemInit.ADVANCED_CONTROL_CRYSTAL.get()))) && list1.m_128425_("Count", 1) && list1.m_128445_("Count") > 0) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.has_control_crystal").m_130940_(ChatFormatting.AQUA));
        }
        super.m_5871_(stack, getter, tooltipComponents, isAdvanced);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            default -> AtlantisDHDBlock.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)16.0, (double)20.0, (double)16.0);
            case Direction.NORTH -> AtlantisDHDBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)32.0, (double)20.0, (double)16.0);
            case Direction.EAST -> AtlantisDHDBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)20.0, (double)32.0);
            case Direction.WEST -> AtlantisDHDBlock.m_49796_((double)0.0, (double)0.0, (double)-16.0, (double)16.0, (double)20.0, (double)16.0);
        };
    }
}

