/*
 * Decompiled with CFR 0.152.
 */
package com.struxnet.sgjadditions.common.block_entities;

import com.struxnet.sgjadditions.common.init.BlockEntityInit;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.crystals.AbstractCrystalItem;
import net.povstalec.sgjourney.common.items.crystals.CommunicationCrystalItem;
import net.povstalec.sgjourney.common.items.crystals.EnergyCrystalItem;
import net.povstalec.sgjourney.common.items.crystals.TransferCrystalItem;
import net.povstalec.sgjourney.common.misc.ArrayHelper;
import org.jetbrains.annotations.NotNull;

public class AtlantisDHDEntity
extends AbstractDHDEntity {
    protected int[] memoryCrystals = new int[0];
    protected int[] controlCrystals = new int[0];
    protected int[] energyCrystals = new int[0];
    protected int[] transferCrystals = new int[0];
    protected int[] communicationCrystals = new int[0];
    protected final ItemStackHandler itemHandler = this.createHandler();
    protected final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);

    public AtlantisDHDEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.Atlantis_DHD.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("Inventory"));
        AtlantisDHDEntity.addTransferCrystals(this.itemHandler);
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(nbt);
    }

    public void onLoad() {
        this.recalculateCrystals();
    }

    public void invalidateCaps() {
        this.handler.invalidate();
        super.invalidateCaps();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(capability, side);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                AtlantisDHDEntity.this.m_6596_();
                AtlantisDHDEntity.this.recalculateCrystals();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return AtlantisDHDEntity.this.isValidCrystal(stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    protected boolean isValidCrystal(ItemStack stack) {
        AbstractCrystalItem crystal;
        Item item = stack.m_41720_();
        return item instanceof AbstractCrystalItem && (crystal = (AbstractCrystalItem)item).isAdvanced();
    }

    public void recalculateCrystals() {
        ItemStack stack;
        int i;
        this.enableAdvancedProtocols = false;
        this.memoryCrystals = new int[0];
        this.controlCrystals = new int[0];
        this.energyCrystals = new int[0];
        this.transferCrystals = new int[0];
        this.desiredEnergyLevel = 0;
        this.maxEnergyTransfer = 0;
        this.communicationCrystals = new int[0];
        for (i = 0; i < 9; ++i) {
            Item item = this.itemHandler.getStackInSlot(i).m_41720_();
            if (item == ItemInit.ADVANCED_CONTROL_CRYSTAL.get()) {
                this.controlCrystals = ArrayHelper.growIntArray((int[])this.controlCrystals, (int)i);
                continue;
            }
            if (item == ItemInit.ADVANCED_MEMORY_CRYSTAL.get()) {
                this.memoryCrystals = ArrayHelper.growIntArray((int[])this.memoryCrystals, (int)i);
                continue;
            }
            if (item == ItemInit.ADVANCED_ENERGY_CRYSTAL.get()) {
                this.energyCrystals = ArrayHelper.growIntArray((int[])this.energyCrystals, (int)i);
                continue;
            }
            if (item == ItemInit.ADVANCED_TRANSFER_CRYSTAL.get()) {
                this.transferCrystals = ArrayHelper.growIntArray((int[])this.transferCrystals, (int)i);
                continue;
            }
            if (item != ItemInit.ADVANCED_COMMUNICATION_CRYSTAL.get()) continue;
            this.communicationCrystals = ArrayHelper.growIntArray((int[])this.communicationCrystals, (int)i);
        }
        if (this.controlCrystals.length > 0) {
            this.enableAdvancedProtocols = true;
        }
        for (i = 0; i < this.energyCrystals.length; ++i) {
            stack = this.itemHandler.getStackInSlot(this.energyCrystals[i]);
            if (stack.m_41619_()) continue;
            this.desiredEnergyLevel += ((EnergyCrystalItem)ItemInit.ENERGY_CRYSTAL.get()).getCapacity();
        }
        for (i = 0; i < this.transferCrystals.length; ++i) {
            stack = this.itemHandler.getStackInSlot(this.transferCrystals[i]);
            if (stack.m_41619_()) continue;
            this.maxEnergyTransfer += TransferCrystalItem.getMaxTransfer((ItemStack)stack);
        }
    }

    public int getMaxDistance() {
        return this.communicationCrystals.length * ((CommunicationCrystalItem)ItemInit.ADVANCED_COMMUNICATION_CRYSTAL.get()).getMaxDistance() + 16;
    }

    public static void addTransferCrystals(ItemStackHandler itemHandler) {
        int slots = itemHandler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!stack.m_150930_((Item)ItemInit.ADVANCED_ENERGY_CRYSTAL.get()) || !stack.m_41782_() || !stack.m_41783_().m_128461_("CrystalMode").equals("ENERGY_TRANSFER")) continue;
            itemHandler.setStackInSlot(i, new ItemStack((ItemLike)ItemInit.TRANSFER_CRYSTAL.get()));
            StargateJourney.LOGGER.info("Replaced Transfer Crystal");
        }
    }
}

