/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.mixin;

import com.dugkse.moderntrainparts.content.containers.ContainerBlock;
import com.dugkse.moderntrainparts.content.containers.ContainerDoor;
import com.dugkse.moderntrainparts.content.containers.ContainerEnd;
import com.dugkse.moderntrainparts.content.containers.ContainerWall;
import com.dugkse.moderntrainparts.enums.Container_Position;
import com.simibubi.create.content.contraptions.BlockMovementChecks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockMovementChecks.class})
public class BlockMovementsMixin {
    @Inject(at={@At(value="HEAD")}, method={"isMovementAllowedFallback(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z"}, cancellable=true)
    private static void isMovementAllowedFallback(BlockState state, Level world, BlockPos pos, CallbackInfoReturnable<Boolean> callback) {
        Block block = state.m_60734_();
        if (block instanceof ContainerBlock) {
            callback.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isBlockAttachedTowards(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"}, cancellable=true)
    private static void isBlockAttachedTowardsFallback(BlockState state, Level world, BlockPos pos, Direction direction, CallbackInfoReturnable<Boolean> callback) {
        Block block = state.m_60734_();
        if (block instanceof ContainerBlock) {
            BlockPos touchingpos = pos.m_121945_(direction);
            BlockState touching_state = world.m_8055_(touchingpos);
            Block touching_block = touching_state.m_60734_();
            if (!(touching_block instanceof ContainerBlock)) {
                return;
            }
            Container_Position touch_wall_pos = (Container_Position)((Object)touching_state.m_61143_(ContainerBlock.POSITION));
            Container_Position wall_pos = (Container_Position)((Object)state.m_61143_(ContainerBlock.POSITION));
            Direction touching_facing = (Direction)touching_state.m_61143_((Property)ContainerBlock.f_54117_);
            Direction wall_facing = (Direction)state.m_61143_((Property)ContainerBlock.f_54117_);
            if (block instanceof ContainerWall && touching_block instanceof ContainerWall) {
                callback.setReturnValue((Object)true);
            } else if (block instanceof ContainerWall) {
                if (wall_facing.m_122434_() == touching_facing.m_122434_() && wall_pos == Container_Position.CENTER && touch_wall_pos == Container_Position.CENTER && touchingpos.m_121945_(touching_facing.m_122424_()).equals((Object)pos)) {
                    BlockMovementsMixin.walls_touching(callback, touch_wall_pos, wall_pos);
                }
            } else if (block instanceof ContainerDoor && touching_block instanceof ContainerDoor || block instanceof ContainerEnd && touching_block instanceof ContainerEnd) {
                if (wall_facing == touching_facing) {
                    if (touching_facing.m_122434_() == Direction.Axis.X) {
                        if (pos.m_123341_() == touchingpos.m_123341_()) {
                            BlockMovementsMixin.walls_touching(callback, touch_wall_pos, wall_pos);
                        }
                    } else if (pos.m_123343_() == touchingpos.m_123343_()) {
                        BlockMovementsMixin.walls_touching(callback, touch_wall_pos, wall_pos);
                    }
                }
            } else if (touching_block instanceof ContainerWall && wall_facing.m_122434_() == touching_facing.m_122434_() && wall_pos == Container_Position.CENTER && touch_wall_pos == Container_Position.CENTER && pos.m_121945_(wall_facing.m_122424_()).equals((Object)touchingpos)) {
                BlockMovementsMixin.walls_touching(callback, touch_wall_pos, wall_pos);
            }
        }
    }

    @Unique
    private static void walls_touching(CallbackInfoReturnable<Boolean> callback, Container_Position touch_wall_pos, Container_Position wall_pos) {
        if (touch_wall_pos == Container_Position.CENTER || wall_pos == Container_Position.CENTER) {
            callback.setReturnValue((Object)true);
        } else if (touch_wall_pos == Container_Position.TOP_CENTER && (wall_pos == Container_Position.TOP_LEFT || wall_pos == Container_Position.TOP_RIGHT)) {
            callback.setReturnValue((Object)true);
        } else if (touch_wall_pos == Container_Position.BOTTOM_CENTER && (wall_pos == Container_Position.BOTTOM_LEFT || wall_pos == Container_Position.BOTTOM_RIGHT)) {
            callback.setReturnValue((Object)true);
        } else if (wall_pos == Container_Position.TOP_CENTER && (touch_wall_pos == Container_Position.TOP_LEFT || touch_wall_pos == Container_Position.TOP_RIGHT)) {
            callback.setReturnValue((Object)true);
        } else if (wall_pos == Container_Position.BOTTOM_CENTER && (touch_wall_pos == Container_Position.BOTTOM_LEFT || touch_wall_pos == Container_Position.BOTTOM_RIGHT)) {
            callback.setReturnValue((Object)true);
        }
    }
}

