/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.content.containers;

import com.dugkse.moderntrainparts.enums.ContainerColors;
import com.dugkse.moderntrainparts.enums.Container_Position;
import com.dugkse.moderntrainparts.init.MTPBlockinit;
import com.dugkse.moderntrainparts.init.MTPIteminit;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class ContainerBlock
extends HorizontalDirectionalBlock
implements IWrenchable {
    public static final EnumProperty<Container_Position> POSITION = EnumProperty.m_61587_((String)"position", Container_Position.class);
    public static final IntegerProperty COLOR = IntegerProperty.m_61631_((String)"color", (int)0, (int)15);

    public ContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)COLOR, (Comparable)Integer.valueOf(1)));
    }

    public BlockState getNextBlockDefaultState() {
        return MTPBlockinit.CONTAINER_WALL.getDefaultState();
    }

    public BlockState getPrevBlockDefaultState() {
        return MTPBlockinit.CONTAINER_WALL.getDefaultState();
    }

    public void changeBlockState(UseOnContext context, BlockPos position, Direction facing, Integer color, Boolean prev) {
        if (!prev.booleanValue()) {
            context.m_43725_().m_46597_(position.m_7495_(), (BlockState)((BlockState)((BlockState)this.getNextBlockDefaultState().m_61124_((Property)f_54117_, (Comparable)facing)).m_61124_((Property)COLOR, (Comparable)color)).m_61124_(POSITION, (Comparable)((Object)Container_Position.NONE)));
        } else {
            context.m_43725_().m_46597_(position.m_7495_(), (BlockState)((BlockState)((BlockState)this.getPrevBlockDefaultState().m_61124_((Property)f_54117_, (Comparable)facing)).m_61124_((Property)COLOR, (Comparable)color)).m_61124_(POSITION, (Comparable)((Object)Container_Position.NONE)));
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        try {
            Direction facing = (Direction)state.m_61143_((Property)f_54117_);
            Direction.Axis axis = facing.m_122434_();
            BlockPos center = this.findCenter(context.m_43725_(), axis, context.m_8083_());
            Integer color = (Integer)state.m_61143_((Property)COLOR);
            if (axis == context.m_8125_().m_122424_().m_122434_()) {
                this.changeBlockState(context, center, context.m_8125_().m_122424_(), color, false);
            } else {
                this.changeBlockState(context, center, facing, color, false);
            }
            return InteractionResult.SUCCESS;
        }
        catch (Exception err) {
            System.out.println("NOT FOUND CENTER");
            return InteractionResult.PASS;
        }
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        try {
            Direction facing = (Direction)state.m_61143_((Property)f_54117_);
            Direction.Axis axis = facing.m_122434_();
            BlockPos center = this.findCenter(context.m_43725_(), axis, context.m_8083_());
            Integer color = (Integer)state.m_61143_((Property)COLOR);
            if (axis == context.m_8125_().m_122424_().m_122434_()) {
                this.changeBlockState(context, center, context.m_8125_().m_122424_(), color, true);
            } else {
                this.changeBlockState(context, center, facing, color, true);
            }
            return InteractionResult.SUCCESS;
        }
        catch (Exception err) {
            System.out.println("NOT FOUND CENTER");
            return InteractionResult.PASS;
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, POSITION, COLOR});
        super.m_7926_(builder);
    }

    private boolean canPlaceAroundPos(Level lvl, BlockPos center, Direction.Axis direction) {
        if (this.isAir(lvl, center) && this.isAir(lvl, center.m_7494_()) && this.isAir(lvl, center.m_7495_())) {
            BlockPos below_center = center.m_7495_();
            BlockPos above_center = center.m_7494_();
            if (direction.equals((Object)Direction.Axis.Z)) {
                for (Entity entity : lvl.m_45933_(null, new AABB((double)((float)below_center.m_123341_() - 1.9f), (double)((float)below_center.m_123342_() - 0.9f), (double)((float)below_center.m_123343_() - 0.9f), (double)((float)above_center.m_123341_() + 1.9f), (double)((float)above_center.m_123342_() + 0.9f), (double)((float)above_center.m_123343_() + 0.9f)))) {
                    if (entity instanceof SuperGlueEntity) continue;
                    return false;
                }
                return this.isAir(lvl, center.m_122029_()) && this.isAir(lvl, center.m_122024_()) && this.isAir(lvl, above_center.m_122029_()) && this.isAir(lvl, above_center.m_122024_()) && this.isAir(lvl, below_center.m_122029_()) && this.isAir(lvl, below_center.m_122024_());
            }
            for (Entity entity : lvl.m_45933_((Entity)null, new AABB((double)((float)below_center.m_123341_() - 0.9f), (double)((float)below_center.m_123342_() - 0.9f), (double)((float)below_center.m_123343_() - 1.9f), (double)((float)above_center.m_123341_() + 0.9f), (double)((float)above_center.m_123342_() + 0.9f), (double)((float)above_center.m_123343_() + 1.9f)))) {
                if (entity instanceof SuperGlueEntity) continue;
                return false;
            }
            return this.isAir(lvl, center.m_122019_()) && this.isAir(lvl, center.m_122012_()) && this.isAir(lvl, above_center.m_122019_()) && this.isAir(lvl, above_center.m_122012_()) && this.isAir(lvl, below_center.m_122019_()) && this.isAir(lvl, below_center.m_122012_());
        }
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(Level lvl, BlockPos pos, Direction direction) {
        Direction.Axis directionAxis = direction.m_122434_();
        BlockState curBlockState = lvl.m_8055_(pos);
        if (curBlockState.m_60734_() instanceof ContainerBlock && curBlockState.m_61143_(POSITION) != Container_Position.NONE) {
            return curBlockState;
        }
        Boolean canPlace = false;
        BlockState returnValue = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_(POSITION, (Comparable)((Object)Container_Position.NONE))).m_61124_((Property)COLOR, (Comparable)ContainerColors.ORANGE.get());
        if (this.canPlaceAroundPos(lvl, pos, directionAxis) || this.canPlaceAroundPos(lvl, pos.m_7495_(), directionAxis) || this.canPlaceAroundPos(lvl, pos.m_7494_(), directionAxis)) {
            return returnValue;
        }
        BlockState placedOnBlockState = lvl.m_8055_(pos.m_121945_(direction));
        Block placedOnBlock = placedOnBlockState.m_60734_();
        if (!(placedOnBlock instanceof ContainerBlock)) {
            return null;
        }
        Direction placedOnDirection = (Direction)placedOnBlockState.m_61143_((Property)f_54117_);
        if (placedOnDirection.m_122434_() != directionAxis) {
            return null;
        }
        if (directionAxis.equals((Object)Direction.Axis.Z)) {
            switch ((Container_Position)((Object)placedOnBlockState.m_61143_(POSITION))) {
                case TOP_LEFT: {
                    if (!this.canPlaceAroundPos(lvl, pos.m_122024_().m_7495_(), directionAxis)) break;
                    return returnValue;
                }
                case CENTER_LEFT: {
                    if (!this.canPlaceAroundPos(lvl, pos.m_122024_(), directionAxis)) break;
                    return returnValue;
                }
                case BOTTOM_LEFT: {
                    if (!this.canPlaceAroundPos(lvl, pos.m_122024_().m_7494_(), directionAxis)) break;
                    return returnValue;
                }
                case TOP_RIGHT: {
                    if (!this.canPlaceAroundPos(lvl, pos.m_122029_().m_7495_(), directionAxis)) break;
                    return returnValue;
                }
                case CENTER_RIGHT: {
                    if (!this.canPlaceAroundPos(lvl, pos.m_122029_(), directionAxis)) break;
                    return returnValue;
                }
                case BOTTOM_RIGHT: {
                    if (!this.canPlaceAroundPos(lvl, pos.m_122029_().m_7494_(), directionAxis)) break;
                    return returnValue;
                }
            }
        } else {
            switch ((Container_Position)((Object)placedOnBlockState.m_61143_(POSITION))) {
                case TOP_LEFT: {
                    if (!this.canPlaceAroundPos(lvl, pos.m_122012_().m_7495_(), directionAxis)) break;
                    return returnValue;
                }
                case CENTER_LEFT: {
                    if (!this.canPlaceAroundPos(lvl, pos.m_122012_(), directionAxis)) break;
                    return returnValue;
                }
                case BOTTOM_LEFT: {
                    if (!this.canPlaceAroundPos(lvl, pos.m_122012_().m_7494_(), directionAxis)) break;
                    return returnValue;
                }
                case TOP_RIGHT: {
                    if (!this.canPlaceAroundPos(lvl, pos.m_122019_().m_7495_(), directionAxis)) break;
                    return returnValue;
                }
                case CENTER_RIGHT: {
                    if (!this.canPlaceAroundPos(lvl, pos.m_122019_(), directionAxis)) break;
                    return returnValue;
                }
                case BOTTOM_RIGHT: {
                    if (!this.canPlaceAroundPos(lvl, pos.m_122019_().m_7494_(), directionAxis)) break;
                    return returnValue;
                }
            }
        }
        return null;
    }

    public BlockPos getPosForPlacement(Level lvl, BlockPos pos, Direction direction) {
        Direction.Axis directionAxis = direction.m_122434_();
        BlockState placedOnBlockState = lvl.m_8055_(pos.m_121945_(direction));
        Block placedOnBlock = placedOnBlockState.m_60734_();
        if (placedOnBlock instanceof ContainerBlock) {
            Direction placedOnDirection = (Direction)placedOnBlockState.m_61143_((Property)f_54117_);
            switch ((Container_Position)((Object)placedOnBlockState.m_61143_(POSITION))) {
                case TOP_CENTER: {
                    if (!this.canPlaceAroundPos(lvl, pos.m_7495_(), directionAxis)) break;
                    return pos.m_7495_();
                }
                case CENTER: {
                    if (!this.canPlaceAroundPos(lvl, pos, directionAxis)) break;
                    return pos;
                }
                case BOTTOM_CENTER: {
                    if (!this.canPlaceAroundPos(lvl, pos.m_7494_(), directionAxis)) break;
                    return pos.m_7494_();
                }
            }
            if (placedOnDirection.m_122434_() == directionAxis) {
                if (directionAxis.equals((Object)Direction.Axis.Z)) {
                    switch ((Container_Position)((Object)placedOnBlockState.m_61143_(POSITION))) {
                        case TOP_LEFT: {
                            if (!this.canPlaceAroundPos(lvl, pos.m_122024_().m_7495_(), directionAxis)) break;
                            return pos.m_122024_().m_7495_();
                        }
                        case CENTER_LEFT: {
                            if (!this.canPlaceAroundPos(lvl, pos.m_122024_(), directionAxis)) break;
                            return pos.m_122024_();
                        }
                        case BOTTOM_LEFT: {
                            if (!this.canPlaceAroundPos(lvl, pos.m_122024_().m_7494_(), directionAxis)) break;
                            return pos.m_122024_().m_7494_();
                        }
                        case TOP_RIGHT: {
                            if (!this.canPlaceAroundPos(lvl, pos.m_122029_().m_7495_(), directionAxis)) break;
                            return pos.m_122029_().m_7495_();
                        }
                        case CENTER_RIGHT: {
                            if (!this.canPlaceAroundPos(lvl, pos.m_122029_(), directionAxis)) break;
                            return pos.m_122029_();
                        }
                        case BOTTOM_RIGHT: {
                            if (!this.canPlaceAroundPos(lvl, pos.m_122029_().m_7494_(), directionAxis)) break;
                            return pos.m_122029_().m_7494_();
                        }
                    }
                } else {
                    switch ((Container_Position)((Object)placedOnBlockState.m_61143_(POSITION))) {
                        case TOP_LEFT: {
                            if (!this.canPlaceAroundPos(lvl, pos.m_122012_().m_7495_(), directionAxis)) break;
                            return pos.m_122012_().m_7495_();
                        }
                        case CENTER_LEFT: {
                            if (!this.canPlaceAroundPos(lvl, pos.m_122012_(), directionAxis)) break;
                            return pos.m_122012_();
                        }
                        case BOTTOM_LEFT: {
                            if (!this.canPlaceAroundPos(lvl, pos.m_122012_().m_7494_(), directionAxis)) break;
                            return pos.m_122012_().m_7494_();
                        }
                        case TOP_RIGHT: {
                            if (!this.canPlaceAroundPos(lvl, pos.m_122019_().m_7495_(), directionAxis)) break;
                            return pos.m_122019_().m_7495_();
                        }
                        case CENTER_RIGHT: {
                            if (!this.canPlaceAroundPos(lvl, pos.m_122019_(), directionAxis)) break;
                            return pos.m_122019_();
                        }
                        case BOTTOM_RIGHT: {
                            if (!this.canPlaceAroundPos(lvl, pos.m_122019_().m_7494_(), directionAxis)) break;
                            return pos.m_122019_().m_7494_();
                        }
                    }
                }
            }
        }
        if (this.canPlaceAroundPos(lvl, pos.m_7495_(), directionAxis)) {
            return pos.m_7495_();
        }
        if (this.canPlaceAroundPos(lvl, pos.m_7494_(), directionAxis)) {
            return pos.m_7494_();
        }
        return pos;
    }

    public BlockPos getPosForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        return this.getPosForPlacement(context.m_43725_(), pos, context.m_8125_());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        return this.getStateForPlacement(context.m_43725_(), pos, context.m_8125_());
    }

    private BlockPos placeCenter(Level lvl, BlockPos centerPos, Direction direction) {
        BlockState placedOnBlockState = lvl.m_8055_(centerPos.m_121945_(direction.m_122424_()));
        Block placedOnBlock = placedOnBlockState.m_60734_();
        BlockState belowBlockState = lvl.m_8055_(centerPos.m_7495_());
        Block belowBlock = belowBlockState.m_60734_();
        if (this.canPlaceAroundPos(lvl, centerPos, direction.m_122424_().m_122434_())) {
            return centerPos;
        }
        if (this.canPlaceAroundPos(lvl, centerPos.m_7495_(), direction.m_122424_().m_122434_())) {
            return centerPos.m_7495_();
        }
        return centerPos.m_7494_();
    }

    public void placeSides(Level lvl, BlockState state, BlockPos pos, Direction facing) {
        if (facing.m_122434_() == Direction.Axis.Z) {
            BlockPos posE = pos.m_122029_();
            BlockPos posW = pos.m_122024_();
            lvl.m_46597_(posE, (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.CENTER_LEFT)));
            lvl.m_46597_(posW, (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.CENTER_RIGHT)));
            lvl.m_46597_(posE.m_7494_(), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.TOP_LEFT)));
            lvl.m_46597_(posW.m_7494_(), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.TOP_RIGHT)));
            lvl.m_46597_(posE.m_7495_(), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.BOTTOM_LEFT)));
            lvl.m_46597_(posW.m_7495_(), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.BOTTOM_RIGHT)));
        } else if (facing.m_122434_() == Direction.Axis.X) {
            BlockPos posS = pos.m_122019_();
            BlockPos posN = pos.m_122012_();
            lvl.m_46597_(posS, (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.CENTER_LEFT)));
            lvl.m_46597_(posN, (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.CENTER_RIGHT)));
            lvl.m_46597_(posS.m_7494_(), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.TOP_LEFT)));
            lvl.m_46597_(posN.m_7494_(), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.TOP_RIGHT)));
            lvl.m_46597_(posS.m_7495_(), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.BOTTOM_LEFT)));
            lvl.m_46597_(posN.m_7495_(), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.BOTTOM_RIGHT)));
        }
    }

    public void m_6807_(BlockState state1, Level level, BlockPos pos, BlockState state, boolean bool) {
        Direction direction = (Direction)state1.m_61143_((Property)f_54117_);
        if (state1.m_61143_(POSITION) == Container_Position.NONE) {
            BlockPos centerPos = this.placeCenter(level, pos, direction);
            this.placeCenterRow(level, centerPos, state1);
            this.placeSides(level, state1, centerPos, direction);
        }
        super.m_6807_(state1, level, pos, state, bool);
    }

    public void placeCenterRow(Level lvl, BlockPos pos, BlockState state) {
        lvl.m_46597_(pos, (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.CENTER)));
        lvl.m_46597_(pos.m_7494_(), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.TOP_CENTER)));
        lvl.m_46597_(pos.m_7495_(), (BlockState)state.m_61124_(POSITION, (Comparable)((Object)Container_Position.BOTTOM_CENTER)));
    }

    public boolean isCenterContainer(Level lvl, BlockPos pos) {
        return this.isContainer(lvl, pos) && lvl.m_8055_(pos).m_61143_(POSITION) == Container_Position.CENTER;
    }

    public BlockPos findCenter(Level lvl, Direction.Axis directionAxis, BlockPos pos) throws Exception {
        if (this.isCenterContainer(lvl, pos)) {
            return pos;
        }
        if (this.isCenterContainer(lvl, pos.m_7494_())) {
            return pos.m_7494_();
        }
        if (this.isCenterContainer(lvl, pos.m_7495_())) {
            return pos.m_7495_();
        }
        if (directionAxis == Direction.Axis.X) {
            if (this.isCenterContainer(lvl, pos.m_122012_())) {
                return pos.m_122012_();
            }
            if (this.isCenterContainer(lvl, pos.m_122019_())) {
                return pos.m_122019_();
            }
            if (this.isCenterContainer(lvl, pos.m_7495_().m_122012_())) {
                return pos.m_7495_().m_122012_();
            }
            if (this.isCenterContainer(lvl, pos.m_7495_().m_122019_())) {
                return pos.m_7495_().m_122019_();
            }
            if (this.isCenterContainer(lvl, pos.m_7494_().m_122012_())) {
                return pos.m_7494_().m_122012_();
            }
            if (this.isCenterContainer(lvl, pos.m_7494_().m_122019_())) {
                return pos.m_7494_().m_122019_();
            }
        } else {
            if (this.isCenterContainer(lvl, pos.m_122024_())) {
                return pos.m_122024_();
            }
            if (this.isCenterContainer(lvl, pos.m_122029_())) {
                return pos.m_122029_();
            }
            if (this.isCenterContainer(lvl, pos.m_7494_().m_122024_())) {
                return pos.m_7494_().m_122024_();
            }
            if (this.isCenterContainer(lvl, pos.m_7494_().m_122029_())) {
                return pos.m_7494_().m_122029_();
            }
            if (this.isCenterContainer(lvl, pos.m_7495_().m_122024_())) {
                return pos.m_7495_().m_122024_();
            }
            if (this.isCenterContainer(lvl, pos.m_7495_().m_122029_())) {
                return pos.m_7495_().m_122029_();
            }
        }
        throw new Exception("Center not found! position checked from " + pos + " with direction " + directionAxis);
    }

    public boolean findAndRemoveCenter(Level lvl, Direction.Axis directionAxis, BlockPos pos, Player plr) {
        try {
            BlockPos center = this.findCenter(lvl, directionAxis, pos);
            if (!plr.m_7500_()) {
                Containers.m_18992_((Level)lvl, (double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_(), (ItemStack)new ItemStack((ItemLike)MTPIteminit.getContainerFromColor((Integer)lvl.m_8055_(pos).m_61143_((Property)COLOR))));
            }
            this.removeBlockWithParticles(lvl, plr, center);
            this.removeSides(lvl, directionAxis, center, plr);
            return true;
        }
        catch (Exception err) {
            System.out.println(err);
            return false;
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        this.findAndRemoveCenter(level, ((Direction)state.m_61143_((Property)f_54117_)).m_122434_(), pos, player);
        super.m_5707_(level, pos, state, player);
    }

    public void removeBlockWithParticles(Level lvl, Player plr, BlockPos pos) {
        BlockState state = lvl.m_8055_(pos);
        Integer color = (Integer)state.m_61143_((Property)COLOR);
        this.m_142387_(lvl, plr, pos, lvl.m_8055_(pos));
        lvl.m_46961_(pos, true);
    }

    public void removeSides(Level level, Direction.Axis axis, BlockPos pos, Player plr) {
        BlockPos posR;
        BlockPos posL;
        if (axis == Direction.Axis.X) {
            posL = pos.m_122012_();
            posR = pos.m_122019_();
        } else {
            posL = pos.m_122029_();
            posR = pos.m_122024_();
        }
        this.removeBlockWithParticles(level, plr, pos.m_7494_());
        this.removeBlockWithParticles(level, plr, pos.m_7495_());
        this.removeBlockWithParticles(level, plr, posL);
        this.removeBlockWithParticles(level, plr, posR);
        this.removeBlockWithParticles(level, plr, posL.m_7495_());
        this.removeBlockWithParticles(level, plr, posR.m_7495_());
        this.removeBlockWithParticles(level, plr, posL.m_7494_());
        this.removeBlockWithParticles(level, plr, posR.m_7494_());
    }

    public boolean isContainer(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60734_() instanceof ContainerBlock;
    }

    public boolean isAir(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_247087_();
    }

    public boolean isAir(BlockPlaceContext context, BlockPos pos) {
        Level lvl = context.m_43725_();
        return lvl.m_8055_(pos).m_247087_();
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        super.m_6256_(state, level, pos, player);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public static boolean isContainer(BlockState state) {
        return MTPBlockinit.CONTAINER_WALL.has(state);
    }

    public static Direction.Axis getContainerBlockAxis(BlockState state) {
        if (!ContainerBlock.isContainer(state)) {
            return null;
        }
        return ((Direction)state.m_61143_((Property)f_54117_)).m_122434_();
    }

    public void m_6786_(LevelAccessor p_49860_, BlockPos p_49861_, BlockState p_49862_) {
        super.m_6786_(p_49860_, p_49861_, p_49862_);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)MTPIteminit.getContainerFromColor((Integer)state.m_61143_((Property)COLOR)));
    }
}

