/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.items;

import com.github.talrey.createdeco.blocks.CatwalkBlock;
import com.github.talrey.createdeco.blocks.CatwalkStairBlock;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class CatwalkStairBlockItem
extends BlockItem {
    private final int placementHelperID = PlacementHelpers.register((IPlacementHelper)new CatwalkHelper());

    public CatwalkStairBlockItem(CatwalkStairBlock block, Item.Properties props) {
        super((Block)block, props);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos pos = ctx.m_8083_();
        Direction face = ctx.m_43719_();
        Level world = ctx.m_43725_();
        Player player = ctx.m_43723_();
        BlockState state = world.m_8055_(pos);
        IPlacementHelper helper = PlacementHelpers.get((int)this.placementHelperID);
        BlockHitResult ray = new BlockHitResult(ctx.m_43720_(), face, pos, true);
        if (helper.matchesState(state) && player != null && !player.m_6144_()) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)this, player, ctx.m_43724_(), ray);
        }
        return super.m_6225_(ctx);
    }

    @MethodsReturnNonnullByDefault
    public static class CatwalkHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return CatwalkStairBlock::isCatwalkStair;
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> CatwalkStairBlock.isCatwalkStair(state.m_60734_());
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List dirs = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)Direction.Axis.Y);
            for (Direction dir : dirs) {
                BlockPos newPos;
                Direction facing;
                if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                    if (dir.m_122424_() != facing) {
                        continue;
                    }
                } else {
                    facing = dir.m_122424_();
                }
                if (!CatwalkBlock.canPlaceCatwalk(world, newPos = pos.m_121945_(dir).m_7918_(0, 1, 0))) continue;
                return PlacementOffset.success((Vec3i)newPos, offsetState -> {
                    if (offsetState.m_61138_((Property)BlockStateProperties.f_61374_)) {
                        offsetState = (BlockState)offsetState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
                    }
                    return offsetState;
                });
            }
            return PlacementOffset.fail();
        }
    }
}

