/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.recipe;

import com.enderio.EnderIO;
import com.enderio.api.grindingball.IGrindingBallData;
import com.enderio.core.common.recipes.OutputStack;
import com.enderio.core.common.util.JsonUtil;
import com.enderio.core.common.util.TagUtil;
import com.enderio.machines.common.blockentity.SagMillBlockEntity;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.recipe.MachineRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SagMillingRecipe
implements MachineRecipe<Container> {
    private static final Random RANDOM = new Random();
    private final ResourceLocation id;
    private final Ingredient input;
    private final List<OutputItem> outputs;
    private final int energy;
    private final BonusType bonusType;

    public SagMillingRecipe(ResourceLocation id, Ingredient input, List<OutputItem> outputs, int energy, BonusType bonusType) {
        this.id = id;
        this.input = input;
        this.outputs = outputs;
        this.energy = energy;
        this.bonusType = bonusType;
    }

    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public int getBaseEnergyCost() {
        return this.energy;
    }

    @Override
    public int getEnergyCost(Container container) {
        return this.getEnergyCost(container.getGrindingBall());
    }

    @Override
    public int getEnergyCost(IGrindingBallData grindingBallData) {
        return (int)((float)this.energy * grindingBallData.getPowerUse());
    }

    public BonusType getBonusType() {
        return this.bonusType;
    }

    @Override
    public List<OutputStack> craft(Container container, RegistryAccess registryAccess) {
        float chanceMult;
        ArrayList<OutputStack> outputs = new ArrayList<OutputStack>();
        float f = chanceMult = this.getBonusType().doChance() ? container.getGrindingBall().getBonusMultiplier() : 1.0f;
        for (float outputCount = this.getBonusType().canMultiply() ? container.getGrindingBall().getOutputMultiplier() : 1.0f; outputCount > 0.0f; outputCount -= 1.0f) {
            if (!(RANDOM.nextFloat() < outputCount)) continue;
            for (OutputItem output : this.outputs) {
                if (!output.isPresent() || !(RANDOM.nextFloat() < output.chance() * chanceMult)) continue;
                ItemStack outputStack = output.getItemStack();
                for (OutputStack stack : outputs) {
                    if (outputStack.m_41613_() <= 0) break;
                    ItemStack itemStack = stack.getItem();
                    if (!itemStack.m_150930_(outputStack.m_41720_())) continue;
                    int growth = Math.min(outputStack.m_41613_(), itemStack.m_41741_());
                    itemStack.m_41769_(growth);
                    outputStack.m_41774_(growth);
                }
                if (outputStack.m_41613_() < 0) continue;
                outputs.add(OutputStack.of(outputStack));
            }
        }
        return outputs;
    }

    @Override
    public List<OutputStack> getResultStacks(RegistryAccess registryAccess) {
        ArrayList<OutputStack> guaranteedOutputs = new ArrayList<OutputStack>();
        for (OutputItem item : this.outputs) {
            if (!(item.chance >= 1.0f) || !item.isPresent()) continue;
            guaranteedOutputs.add(OutputStack.of(item.getItemStack()));
        }
        return guaranteedOutputs;
    }

    public List<OutputItem> getOutputs() {
        return this.outputs;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input});
    }

    public boolean matches(Container container, Level level) {
        return this.input.test(SagMillBlockEntity.INPUT.getItemStack((net.minecraft.world.Container)container));
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MachineRecipes.SAG_MILLING.serializer().get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)MachineRecipes.SAG_MILLING.type().get();
    }

    public static enum BonusType {
        NONE(false, false),
        MULTIPLY_OUTPUT(true, true),
        CHANCE_ONLY(false, true);

        private final boolean multiply;
        private final boolean chance;

        private BonusType(boolean multiply, boolean chance) {
            this.multiply = multiply;
            this.chance = chance;
        }

        public boolean canMultiply() {
            return this.multiply;
        }

        public boolean doChance() {
            return this.chance;
        }

        public boolean useGrindingBall() {
            return this.multiply || this.chance;
        }
    }

    public static class Container
    extends RecipeWrapper {
        private final Supplier<IGrindingBallData> grindingBallData;

        public Container(IItemHandlerModifiable inv, Supplier<IGrindingBallData> data) {
            super(inv);
            this.grindingBallData = data;
        }

        public final IGrindingBallData getGrindingBall() {
            return this.grindingBallData.get();
        }
    }

    public record OutputItem(Either<ItemStack, SizedTagOutput> output, float chance, boolean isOptional) {
        public static OutputItem of(@Nullable Item item, int count, float chance, boolean optional) {
            return OutputItem.of(item == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)item, count), chance, optional);
        }

        public static OutputItem of(ItemStack item, float chance, boolean optional) {
            return new OutputItem((Either<ItemStack, SizedTagOutput>)Either.left((Object)item), chance, optional);
        }

        public static OutputItem of(TagKey<Item> tag, int count, float chance, boolean optional) {
            return new OutputItem((Either<ItemStack, SizedTagOutput>)Either.right((Object)new SizedTagOutput(tag, count)), chance, optional);
        }

        public boolean isPresent() {
            return !this.getItemStack().m_41619_();
        }

        public ItemStack getItemStack() {
            return (ItemStack)this.output.map(ItemStack::m_41777_, SizedTagOutput::getItemStack);
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.add("item", (JsonElement)this.output.map(JsonUtil::serializeItemStackWithoutNBT, SizedTagOutput::toJson));
            json.addProperty("chance", (Number)Float.valueOf(this.chance));
            json.addProperty("optional", Boolean.valueOf(this.isOptional));
            return json;
        }

        public static OutputItem fromJson(JsonObject json, ResourceLocation recipeId) {
            int legacyCount;
            float chance = json.has("chance") ? json.get("chance").getAsFloat() : 1.0f;
            boolean optional = json.has("optional") && json.get("optional").getAsBoolean();
            int n = legacyCount = json.has("count") ? json.get("count").getAsInt() : 1;
            if (json.has("tag")) {
                ResourceLocation id = new ResourceLocation(json.get("tag").getAsString());
                TagKey tag = ItemTags.create((ResourceLocation)id);
                if (!optional && TagUtil.getOptionalItem((TagKey<Item>)tag).isEmpty()) {
                    EnderIO.LOGGER.error("Sag milling recipe {} is missing a required output tag {}", (Object)recipeId, (Object)id);
                    throw new RuntimeException("Sag milling recipe is missing a required output tag.");
                }
                return OutputItem.of((TagKey<Item>)tag, legacyCount, chance, optional);
            }
            JsonElement itemJson = json.get("item");
            if (itemJson.isJsonObject()) {
                JsonObject newItemJson = itemJson.getAsJsonObject();
                if (newItemJson.has("tag")) {
                    ResourceLocation id = new ResourceLocation(newItemJson.get("tag").getAsString());
                    TagKey tag = ItemTags.create((ResourceLocation)id);
                    int count = newItemJson.has("count") ? newItemJson.get("count").getAsInt() : 1;
                    return OutputItem.of((TagKey<Item>)tag, count, chance, optional);
                }
                ItemStack item = CraftingHelper.getItemStack((JsonObject)newItemJson.getAsJsonObject(), (boolean)true, (boolean)true);
                return OutputItem.of(item, chance, optional);
            }
            ResourceLocation id = new ResourceLocation(json.get("item").getAsString());
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (item == null && !optional) {
                EnderIO.LOGGER.error("Sag milling recipe {} is missing a required output item {}", (Object)recipeId, (Object)id);
                throw new RuntimeException("Sag milling recipe is missing a required output item.");
            }
            return OutputItem.of(item, legacyCount, chance, optional);
        }

        public record SizedTagOutput(TagKey<Item> itemTag, int count) {
            public ItemStack getItemStack() {
                return TagUtil.getOptionalItem(this.itemTag).map(ItemStack::new).orElse(ItemStack.f_41583_);
            }

            public JsonObject toJson() {
                JsonObject json = new JsonObject();
                json.addProperty("tag", this.itemTag.f_203868_().toString());
                json.addProperty("count", (Number)this.count);
                return json;
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<SagMillingRecipe> {
        public SagMillingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            Ingredient input = Ingredient.m_43917_((JsonElement)serializedRecipe.get("input"));
            int energy = serializedRecipe.get("energy").getAsInt();
            BonusType bonusType = BonusType.MULTIPLY_OUTPUT;
            if (serializedRecipe.has("bonus")) {
                bonusType = BonusType.valueOf(serializedRecipe.get("bonus").getAsString().toUpperCase());
            }
            JsonArray jsonOutputs = serializedRecipe.getAsJsonArray("outputs");
            ArrayList<OutputItem> outputs = new ArrayList<OutputItem>();
            for (int i = 0; i < jsonOutputs.size(); ++i) {
                JsonObject obj = jsonOutputs.get(i).getAsJsonObject();
                outputs.add(OutputItem.fromJson(obj, recipeId));
            }
            return new SagMillingRecipe(recipeId, input, outputs, energy, bonusType);
        }

        @Nullable
        public SagMillingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            try {
                Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                int energy = buffer.readInt();
                BonusType bonusType = (BonusType)buffer.m_130066_(BonusType.class);
                ArrayList<OutputItem> outputs = new ArrayList<OutputItem>();
                int outputCount = buffer.readInt();
                for (int i = 0; i < outputCount; ++i) {
                    boolean isItem = buffer.readBoolean();
                    if (isItem) {
                        ItemStack output = buffer.m_130267_();
                        float chance = buffer.readFloat();
                        boolean optional = buffer.readBoolean();
                        outputs.add(OutputItem.of(output, chance, optional));
                        continue;
                    }
                    ResourceLocation id = buffer.m_130281_();
                    TagKey tag = ItemTags.create((ResourceLocation)id);
                    int count = buffer.readInt();
                    float chance = buffer.readFloat();
                    boolean optional = buffer.readBoolean();
                    outputs.add(OutputItem.of((TagKey<Item>)tag, count, chance, optional));
                }
                return new SagMillingRecipe(recipeId, input, outputs, energy, bonusType);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error reading sag milling recipe to packet.", (Throwable)ex);
                throw ex;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, SagMillingRecipe recipe) {
            try {
                recipe.input.m_43923_(buffer);
                buffer.writeInt(recipe.energy);
                buffer.m_130068_((Enum)recipe.bonusType);
                buffer.writeInt(recipe.outputs.size());
                for (OutputItem item : recipe.outputs) {
                    buffer.writeBoolean(item.output.left().isPresent());
                    if (item.output.left().isPresent()) {
                        buffer.m_130055_((ItemStack)item.output.left().get());
                    } else {
                        buffer.m_130085_(((OutputItem.SizedTagOutput)item.output.right().get()).itemTag().f_203868_());
                        buffer.writeInt(((OutputItem.SizedTagOutput)item.output.right().get()).count());
                    }
                    buffer.writeFloat(item.chance);
                    buffer.writeBoolean(item.isOptional);
                }
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error writing allow smelting recipe to packet.", (Throwable)ex);
                throw ex;
            }
        }
    }
}

