/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.menu;

import com.enderio.api.capability.StoredEntityData;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.init.EIOMenus;
import com.enderio.base.common.menu.EntityFilterSlot;
import com.enderio.base.common.network.FilterUpdatePacket;
import com.enderio.core.common.capability.EntityFilterCapability;
import com.enderio.core.common.network.CoreNetwork;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class EntityFilterMenu
extends AbstractContainerMenu {
    private final ItemStack stack;
    private final EntityFilterCapability capability;

    public EntityFilterMenu(@Nullable MenuType<?> pMenuType, int pContainerId, Inventory inventory, ItemStack stack) {
        super(pMenuType, pContainerId);
        this.stack = stack;
        LazyOptional resourceFilter = stack.getCapability(EIOCapabilities.FILTER);
        this.capability = (EntityFilterCapability)resourceFilter.map(filter -> {
            if (filter instanceof EntityFilterCapability) {
                EntityFilterCapability cap = (EntityFilterCapability)filter;
                return cap;
            }
            throw new IllegalArgumentException();
        }).orElseThrow(IllegalArgumentException::new);
        List<StoredEntityData> items = this.capability.getEntries();
        for (int i = 0; i < items.size(); ++i) {
            int pSlot = i;
            this.m_38897_(new EntityFilterSlot(data -> this.capability.setEntry(pSlot, (StoredEntityData)data), i, 14 + i % 5 * 18, 35 + 20 * (i / 5)));
        }
        this.addInventorySlots(14, 119, inventory);
    }

    public EntityFilterMenu(int pContainerId, Inventory inventory, ItemStack stack) {
        this((MenuType)EIOMenus.ENTITY_FILTER.get(), pContainerId, inventory, stack);
    }

    public static EntityFilterMenu factory(@Nullable MenuType<EntityFilterMenu> pMenuType, int pContainerId, Inventory inventory, FriendlyByteBuf buf) {
        return new EntityFilterMenu((MenuType)EIOMenus.ENTITY_FILTER.get(), pContainerId, inventory, inventory.f_35978_.m_21205_());
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player pPlayer) {
        return pPlayer.m_21205_().equals(this.stack);
    }

    public void addInventorySlots(int xPos, int yPos, Inventory inventory) {
        for (int x = 0; x < 9; ++x) {
            Slot ref = new Slot((Container)inventory, x, xPos + x * 18, yPos + 58);
            this.m_38897_(ref);
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                Slot ref = new Slot((Container)inventory, x + y * 9 + 9, xPos + x * 18, yPos + y * 18);
                this.m_38897_(ref);
            }
        }
    }

    public EntityFilterCapability getFilter() {
        return this.capability;
    }

    public void setNbt(Boolean nbt) {
        CoreNetwork.sendToServer(new FilterUpdatePacket(nbt, this.capability.isInvert()));
        this.capability.setNbt(nbt);
    }

    public void setInverted(Boolean inverted) {
        CoreNetwork.sendToServer(new FilterUpdatePacket(this.capability.isNbt(), inverted));
        this.capability.setInverted(inverted);
    }

    public void m_150399_(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        if (pSlotId < this.capability.getEntries().size() && pSlotId >= 0 && this.capability.getEntries().get(pSlotId).getEntityType().isPresent()) {
            this.capability.setEntry(pSlotId, StoredEntityData.empty());
        }
        super.m_150399_(pSlotId, pButton, pClickType, pPlayer);
    }
}

