/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterfortresses.world;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterfortresses.BetterFortressesCommon;
import com.yungnickyoung.minecraft.betterfortresses.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.betterfortresses.world.ItemFrameChances;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ItemFrameProcessor
extends StructureProcessor {
    public static final ItemFrameProcessor INSTANCE = new ItemFrameProcessor();
    public static final Codec<StructureProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureEntityInfo processEntity(LevelReader levelReader, BlockPos structurePiecePos, StructureTemplate.StructureEntityInfo localEntityInfo, StructureTemplate.StructureEntityInfo globalEntityInfo, StructurePlaceSettings structurePlaceSettings, StructureTemplate template) {
        if (globalEntityInfo.f_74685_.m_128461_("id").equals("minecraft:item_frame")) {
            String item;
            RandomSource random = structurePlaceSettings.m_230326_(globalEntityInfo.f_74684_);
            try {
                item = globalEntityInfo.f_74685_.m_128469_("Item").m_128423_("id").toString();
            }
            catch (Exception e) {
                BetterFortressesCommon.LOGGER.info("Unable to randomize item frame at {}", (Object)globalEntityInfo.f_74684_);
                return globalEntityInfo;
            }
            CompoundTag newNBT = globalEntityInfo.f_74685_.m_6426_();
            switch (item) {
                case "\"minecraft:stone_sword\"": {
                    String randomItemString = ForgeRegistries.ITEMS.getKey((Object)ItemFrameChances.get().getWeaponItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    newNBT.m_128469_("Item").m_128359_("id", randomItemString);
                    break;
                }
                case "\"minecraft:iron_ingot\"": {
                    String randomItemString = ForgeRegistries.ITEMS.getKey((Object)ItemFrameChances.get().getLootItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    newNBT.m_128469_("Item").m_128359_("id", randomItemString);
                    break;
                }
                case "\"minecraft:cobweb\"": {
                    String randomItemString = ForgeRegistries.ITEMS.getKey((Object)ItemFrameChances.get().getStudyItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    if (randomItemString.equals("minecraft:enchanted_book")) {
                        float f = random.m_188501_();
                        String enchantment = f < 0.2f ? "minecraft:fire_aspect" : (f < 0.4f ? "minecraft:fire_protection" : (f < 0.6f ? "minecraft:flame" : (f < 0.8f ? "minecraft:smite" : "minecraft:binding_curse")));
                        int lvl = enchantment.equals("minecraft:flame") || enchantment.equals("minecraft:binding_curse") ? 1 : (random.m_188501_() < 0.75f ? 1 : 2);
                        CompoundTag tag = new CompoundTag();
                        ListTag storedEnchantments = (ListTag)Util.m_137469_((Object)new ListTag(), listTag -> listTag.add((Object)((Tag)Util.m_137469_((Object)new CompoundTag(), compoundTag -> {
                            compoundTag.m_128376_("lvl", (short)lvl);
                            compoundTag.m_128359_("id", enchantment);
                        }))));
                        tag.m_128365_("StoredEnchantments", (Tag)storedEnchantments);
                        newNBT.m_128469_("Item").m_128365_("tag", (Tag)tag);
                    }
                    newNBT.m_128469_("Item").m_128359_("id", randomItemString);
                    break;
                }
                case "\"minecraft:apple\"": {
                    String randomItemString = ForgeRegistries.ITEMS.getKey((Object)ItemFrameChances.get().getMessHallItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    newNBT.m_128469_("Item").m_128359_("id", randomItemString);
                    break;
                }
                case "\"minecraft:nether_wart\"": {
                    String randomItemString = ForgeRegistries.ITEMS.getKey((Object)ItemFrameChances.get().getAlchemyItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    newNBT.m_128469_("Item").m_128359_("id", randomItemString);
                    break;
                }
                case "\"minecraft:glowstone_dust\"": {
                    if (random.m_188499_()) {
                        newNBT.m_128469_("Item").m_128359_("id", "minecraft:blaze_powder");
                        break;
                    }
                    return null;
                }
            }
            newNBT.m_128405_("TileX", globalEntityInfo.f_74684_.m_123341_());
            newNBT.m_128405_("TileY", globalEntityInfo.f_74684_.m_123342_());
            newNBT.m_128405_("TileZ", globalEntityInfo.f_74684_.m_123343_());
            int minRotation = item.equals("\"minecraft:chiseled_nether_bricks\"") ? 1 : 0;
            int randomRotation = Mth.m_216287_((RandomSource)random, (int)minRotation, (int)7);
            newNBT.m_128344_("ItemRotation", (byte)randomRotation);
            globalEntityInfo = new StructureTemplate.StructureEntityInfo(globalEntityInfo.f_74683_, globalEntityInfo.f_74684_, newNBT);
        }
        return globalEntityInfo;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorTypeModule.ITEM_FRAME_PROCESSOR;
    }
}

