/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.wildernature.client.model.entity.FlamingoModel;
import net.satisfy.wildernature.entity.FlamingoEntity;
import net.satisfy.wildernature.util.WilderNatureIdentifier;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FlamingoRenderer
extends MobRenderer<FlamingoEntity, FlamingoModel<FlamingoEntity>> {
    private static final ResourceLocation WHITE_TEXTURE = new WilderNatureIdentifier("textures/entity/flamingo_white.png");
    private static final ResourceLocation PINK_TEXTURE = new WilderNatureIdentifier("textures/entity/flamingo_pink.png");
    private static final ResourceLocation RED_TEXTURE = new WilderNatureIdentifier("textures/entity/flamingo_red.png");

    public FlamingoRenderer(EntityRendererProvider.Context context) {
        super(context, new FlamingoModel(context.m_174023_(FlamingoModel.LAYER_LOCATION)), 0.7f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(FlamingoEntity entity) {
        int textureIndex = entity.m_19879_() % 3;
        return switch (textureIndex) {
            case 0 -> WHITE_TEXTURE;
            case 1 -> RED_TEXTURE;
            default -> PINK_TEXTURE;
        };
    }

    public void render(FlamingoEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        if (pEntity.m_6162_()) {
            pMatrixStack.m_85841_(0.4f, 0.4f, 0.4f);
        }
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }
}

