/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.fabrication.gui.TabControllerNode;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchScreen;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractGuiNode;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;

public abstract class TabButtonNode
extends AbstractGuiNode {
    private TabState renderState;
    private final TabSide side;
    protected final TabControllerNode.IToolbarTab tab;

    public TabButtonNode(TabControllerNode.IToolbarTab tab, TabSide side) {
        this(tab, side, TabState.ALL_CLOSED);
    }

    public TabButtonNode(TabControllerNode.IToolbarTab tab, TabSide side, TabState renderState) {
        this.tab = tab;
        this.side = side;
        this.renderState = renderState;
        this.setSize(side.w, side.h);
    }

    public TabState getRenderState() {
        return this.renderState;
    }

    public void setTabState(TabState renderState) {
        if (renderState != this.renderState) {
            TabState prevState = this.renderState;
            this.renderState = renderState;
            this.onTabStateChanged(prevState, renderState);
        }
    }

    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int u = this.side.u;
        int v = this.side.v;
        int w = this.side.w;
        int h = this.side.h;
        int ex = x + this.side.extOffsetX;
        int ey = y + this.side.extOffsetY;
        int eu = this.side.extU;
        int ev = this.side.extV;
        int ew = this.side.extW;
        int eh = this.side.extH;
        if (this.renderState == TabState.ALL_CLOSED || this.renderState == TabState.CLOSED) {
            u += this.side.inactiveOffsetU;
            v += this.side.inactiveOffsetV;
            eu += this.side.inactiveOffsetU;
            ev += this.side.inactiveOffsetV;
        }
        graphics.m_280163_(ICWorkbenchScreen.BACKGROUND, x, y, (float)u, (float)v, w, h, 512, 512);
        if (this.renderState == TabState.CLOSED || this.renderState == TabState.OPEN) {
            graphics.m_280163_(ICWorkbenchScreen.BACKGROUND, ex, ey, (float)eu, (float)ev, ew, eh, 512, 512);
        }
        this.renderIcon(graphics, mouse, partialFrame);
    }

    public void drawFront(GuiGraphics graphics, Point mouse, float partialFrame) {
        if (!this.isFirstHit(mouse)) {
            return;
        }
        LinkedList<Component> tooltip = new LinkedList<Component>();
        this.buildTooltip(tooltip);
        this.renderTooltip(graphics, mouse, tooltip);
    }

    public boolean mouseClicked(Point p, int glfwMouseButton, boolean consumed) {
        if (!consumed && this.isFirstHit(p)) {
            this.getRoot().getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            this.onClicked();
            return true;
        }
        return false;
    }

    public void onClicked() {
        TabControllerNode tabControllerNode = (TabControllerNode)this.getParent();
        tabControllerNode.openTab(this.tab);
    }

    public void onTabStateChanged(TabState prevState, TabState newState) {
        switch (newState) {
            case OPEN: {
                this.tab.onTabOpened();
                break;
            }
            case CLOSED: 
            case ALL_CLOSED: {
                this.tab.onTabClosed();
                break;
            }
            case MINIMIZED: {
                this.tab.onTabMinimized();
            }
        }
    }

    public abstract void renderIcon(GuiGraphics var1, Point var2, float var3);

    public abstract void buildTooltip(List<Component> var1);

    public static enum TabState {
        ALL_CLOSED,
        CLOSED,
        MINIMIZED,
        OPEN;

    }

    public static enum TabSide {
        LEFT(482, 179, 20, 20, 503, 179, 6, 20, 16, 0, 0, 21),
        BOTTOM(466, 234, 20, 20, 466, 227, 20, 6, 0, -2, 21, 0);

        public final int u;
        public final int v;
        public final int w;
        public final int h;
        public final int extU;
        public final int extV;
        public final int extW;
        public final int extH;
        public final int extOffsetX;
        public final int extOffsetY;
        public final int inactiveOffsetU;
        public final int inactiveOffsetV;

        private TabSide(int u, int v, int w, int h, int extU, int extV, int extW, int extH, int extOffsetX, int extOffsetY, int inactiveOffsetU, int inactiveOffsetV) {
            this.u = u;
            this.v = v;
            this.w = w;
            this.h = h;
            this.extU = extU;
            this.extV = extV;
            this.extW = extW;
            this.extH = extH;
            this.extOffsetX = extOffsetX;
            this.extOffsetY = extOffsetY;
            this.inactiveOffsetU = inactiveOffsetU;
            this.inactiveOffsetV = inactiveOffsetV;
        }
    }
}

