/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mrtjp.projectred.fabrication.gui.TabButtonNode;
import mrtjp.projectred.fabrication.gui.TabControllerNode;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchScreen;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractGuiNode;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SimpleUVTab
implements TabControllerNode.IToolbarTab {
    private final AbstractGuiNode tabBodyNode;
    private final Component tabName;
    private final TabButtonNode.TabSide tabSide;
    private final int u;
    private final int v;
    private final ResourceLocation texture;

    public SimpleUVTab(AbstractGuiNode tabBodyNode, String unlocalTabName, TabButtonNode.TabSide side, int u, int v, ResourceLocation texture) {
        this.tabBodyNode = tabBodyNode;
        this.tabName = Component.m_237115_((String)unlocalTabName);
        this.tabSide = side;
        this.u = u;
        this.v = v;
        this.texture = texture;
    }

    public SimpleUVTab(AbstractGuiNode tabBodyNode, String tabName, TabButtonNode.TabSide side, int u, int v) {
        this(tabBodyNode, tabName, side, u, v, ICWorkbenchScreen.BACKGROUND);
    }

    public AbstractGuiNode getTabBodyNode() {
        return this.tabBodyNode;
    }

    protected StatusDot getStatusDot() {
        return StatusDot.NONE;
    }

    protected void buildTooltip(List<Component> tooltip) {
        tooltip.add(this.tabName);
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    @Override
    public void onTabClosed() {
        this.tabBodyNode.setHidden(true);
    }

    @Override
    public void onTabOpened() {
        this.tabBodyNode.setHidden(false);
    }

    @Override
    public void onTabMinimized() {
        this.tabBodyNode.setHidden(true);
    }

    @Override
    public TabButtonNode createButtonNode() {
        return new TabButtonNode(this, this.tabSide){

            @Override
            public void renderIcon(GuiGraphics graphics, Point mouse, float partialFrame) {
                graphics.m_280163_(SimpleUVTab.this.texture, this.getFrame().x() + 3, this.getFrame().y() + 3, (float)SimpleUVTab.this.u, (float)SimpleUVTab.this.v, 14, 14, 512, 512);
                StatusDot statusDot = SimpleUVTab.this.getStatusDot();
                if (statusDot != StatusDot.NONE) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICWorkbenchScreen.BACKGROUND);
                    graphics.m_280411_(SimpleUVTab.this.texture, this.getFrame().x() + 3 + 7, this.getFrame().y() + 3, 7, 7, (float)statusDot.u, (float)statusDot.v, 14, 14, 512, 512);
                }
            }

            @Override
            public void buildTooltip(List<Component> tooltip) {
                SimpleUVTab.this.buildTooltip(tooltip);
            }
        };
    }

    public static enum StatusDot {
        NONE(0, 0),
        GREEN(435, 1),
        YELLOW(450, 1),
        RED(465, 1);

        public final int u;
        public final int v;

        private StatusDot(int u, int v) {
            this.u = u;
            this.v = v;
        }
    }
}

