/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.log;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.editor.EditorDataUtils;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.engine.log.CompileProblem;
import mrtjp.projectred.fabrication.engine.log.CompileProblemSeverity;
import mrtjp.projectred.fabrication.engine.log.CompileProblemType;
import mrtjp.projectred.fabrication.gui.ICRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public class MultipleDriversError
extends CompileProblem {
    public TileCoord coord = TileCoord.origin;
    public final List<Integer> registerList = new ArrayList<Integer>();

    public MultipleDriversError() {
        super(CompileProblemType.MULTIPLE_DRIVERS, CompileProblemSeverity.ERROR);
    }

    public MultipleDriversError(TileCoord coord, List<Integer> registerList) {
        super(CompileProblemType.MULTIPLE_DRIVERS, CompileProblemSeverity.ERROR);
        this.coord = coord;
        this.registerList.addAll(registerList);
    }

    @Override
    public void save(CompoundTag tag) {
        tag.m_128365_("coord", (Tag)EditorDataUtils.tileCoordToNBT(this.coord));
        tag.m_128385_("registers", this.registerList.stream().mapToInt(i -> i).toArray());
    }

    @Override
    public void load(CompoundTag tag) {
        this.coord = EditorDataUtils.tileCoordFromNBT(tag.m_128469_("coord"));
        this.registerList.clear();
        for (int i : tag.m_128465_("registers")) {
            this.registerList.add(i);
        }
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        out.writeByte(this.coord.x).writeByte(this.coord.y).writeByte(this.coord.z);
        out.writeShort(this.registerList.size());
        for (int i : this.registerList) {
            out.writeVarInt(i);
        }
    }

    @Override
    public void readDesc(MCDataInput in) {
        this.coord = new TileCoord(in.readByte(), in.readByte(), in.readByte());
        this.registerList.clear();
        int size = in.readUShort();
        for (int i = 0; i < size; ++i) {
            this.registerList.add(in.readVarInt());
        }
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"projectred_fabrication.problems.multiple_drivers.title");
    }

    @Override
    public void buildToolTip(List<Component> tooltip, TileCoord hoverPosition) {
        if (this.coord.equals(hoverPosition)) {
            this.buildToolTip(tooltip);
        }
    }

    @Override
    public void buildToolTip(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"projectred_fabrication.problems.multiple_drivers.desc").m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
        StringBuilder s = new StringBuilder();
        for (int r : this.registerList) {
            s.append("R").append(r).append(", ");
        }
        s.delete(s.length() - 2, s.length());
        tooltip.add((Component)Component.m_237113_((String)"   ").m_130948_(ICWorkbenchEditor.UNIFORM_GRAY).m_7220_((Component)Component.m_237113_((String)s.toString()).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY)));
    }

    @Override
    public void renderOverlay(Vector3 mousePosition, CCRenderState ccrs, MultiBufferSource getter, PoseStack matrixStack) {
        ccrs.baseColour = this.severity == CompileProblemSeverity.ERROR ? EnumColour.RED.rgba(200) : EnumColour.YELLOW.rgba(200);
        Vector3 vec = new Vector3((double)this.coord.x, (double)this.coord.y, (double)this.coord.z).add(0.5);
        ICRenderTypes.renderSelection(ccrs, vec, vec, 0.1875, 0.125);
    }
}

