/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Vector3;
import java.util.List;
import mrtjp.projectred.core.BundledSignalsLib;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.editor.tools.SimpleInteractionZone;
import mrtjp.projectred.fabrication.engine.ICInterfaceType;
import mrtjp.projectred.fabrication.engine.ICSimulationContainer;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.SingleBitIOGateTile;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class AnalogIOGateTile
extends SingleBitIOGateTile {
    protected static final int ANALOG_SIGNAL_PACKET = 6;
    private static final Cuboid6[] INPUT_TOGGLE_ZONE_BOUNDS = new Cuboid6[4];
    private static final Cuboid6[] DIR_ZONE_BOUNDS = new Cuboid6[4];
    private static final Cuboid6[] ANALOG_LEVEL_BOUNDS = new Cuboid6[4];
    protected byte analogSignal = 0;

    public AnalogIOGateTile() {
        super(ICGateTileType.ANALOG_IO);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128344_("analog_signal", this.analogSignal);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.analogSignal = tag.m_128445_("analog_signal");
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
        out.writeByte((int)this.analogSignal);
    }

    @Override
    public void readDesc(MCDataInput in) {
        super.readDesc(in);
        this.analogSignal = in.readByte();
    }

    @Override
    public void read(MCDataInput in, int key) {
        switch (key) {
            case 6: {
                this.analogSignal = in.readByte();
                break;
            }
            default: {
                super.read(in, key);
            }
        }
    }

    protected void sendAnalogSignalUpdate() {
        this.getWriteStream(6).writeByte((int)this.analogSignal);
    }

    @Override
    public ICInterfaceType getInterfaceType() {
        return ICInterfaceType.ANALOG;
    }

    @Override
    protected short toggleWorldInputMask(short currentMask) {
        return (short)(1 << this.ioBit);
    }

    @Override
    public void onSimRegistersChanged(int rMask, ICSimulationContainer container) {
        super.onSimRegistersChanged(rMask, container);
        short ioMask = this.isInputIOMode() ? container.getInput(this.getIOSide()) : container.getOutput(this.getIOSide());
        byte newASig = (byte)BundledSignalsLib.mostSignificantBit((short)ioMask);
        if (newASig != this.analogSignal) {
            this.analogSignal = newASig;
            this.sendAnalogSignalUpdate();
        }
    }

    @Override
    public void buildInteractionZoneList(List<InteractionZone> zones) {
        super.buildInteractionZoneList(zones);
        zones.add(new SimpleInteractionZone.Builder().bounds(() -> INPUT_TOGGLE_ZONE_BOUNDS[this.getRotation()]).leftClickAction(this::toggleWorldInput).tooltip(toolTip -> toolTip.add(Component.m_237115_((String)(this.isInputIOMode() ? "projectred_fabrication.interact.io_analog_input" : "projectred_fabrication.interact.io_analog_output")).m_7220_((Component)Component.m_237113_((String)(": " + this.analogSignal))).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY))).build());
        zones.add(new SimpleInteractionZone.Builder().bounds(() -> DIR_ZONE_BOUNDS[this.getRotation()]).leftClickAction(this::toggleDirection).tooltip(toolTip -> toolTip.add(Component.m_237115_((String)"projectred_fabrication.interact.io_direction").m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)(this.isInputIOMode() ? "projectred_fabrication.interact.io_direction.input" : "projectred_fabrication.interact.io_direction.output"))).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY))).build());
        zones.add(new SimpleInteractionZone.Builder().bounds(() -> ANALOG_LEVEL_BOUNDS[this.getRotation()]).leftClickAction(() -> this.shiftIOBit(true)).rightClickAction(() -> this.shiftIOBit(false)).tooltip(toolTip -> toolTip.add(Component.m_237115_((String)"projectred_fabrication.interact.io_analog_level").m_7220_((Component)Component.m_237113_((String)(": " + this.ioBit))).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY))).text(() -> Component.m_237113_((String)String.valueOf(this.ioBit))).build());
    }

    public int rsIO() {
        return this.analogSignal & 0xFF;
    }

    static {
        for (int r = 0; r < 4; ++r) {
            TransformationList t = new Scale(0.0625).with(Rotation.quarterRotations[r].at(Vector3.CENTER));
            AnalogIOGateTile.INPUT_TOGGLE_ZONE_BOUNDS[r] = new Cuboid6(1.0, 2.0, 0.0, 15.0, 3.0, 3.0).apply((Transformation)t);
            AnalogIOGateTile.DIR_ZONE_BOUNDS[r] = new Cuboid6(6.0, 2.0, 8.0, 10.0, 4.0, 12.0).apply((Transformation)t);
            AnalogIOGateTile.ANALOG_LEVEL_BOUNDS[r] = new Cuboid6(2.0, 2.0, 8.0, 6.0, 4.5, 12.0).apply((Transformation)t);
        }
    }
}

