/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine;

import java.util.HashMap;
import java.util.Map;
import mrtjp.fengine.api.FabricationEngine;
import mrtjp.fengine.api.ICAssembler;
import mrtjp.fengine.api.ICFlatMap;
import mrtjp.fengine.api.ICStepThroughAssembler;
import mrtjp.fengine.simulate.ByteRegister;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.fengine.simulate.StaticByteRegister;
import mrtjp.projectred.fabrication.engine.gates.ANDGateTile;
import mrtjp.projectred.fabrication.engine.gates.BufferGateTile;
import mrtjp.projectred.fabrication.engine.gates.CounterGateTile;
import mrtjp.projectred.fabrication.engine.gates.MultiplexerGateTile;
import mrtjp.projectred.fabrication.engine.gates.NANDGateTile;
import mrtjp.projectred.fabrication.engine.gates.NORGateTile;
import mrtjp.projectred.fabrication.engine.gates.NOTGateTile;
import mrtjp.projectred.fabrication.engine.gates.ORGateTile;
import mrtjp.projectred.fabrication.engine.gates.PulseGateTile;
import mrtjp.projectred.fabrication.engine.gates.RandomizerGateTile;
import mrtjp.projectred.fabrication.engine.gates.RepeaterGateTile;
import mrtjp.projectred.fabrication.engine.gates.SRLatchGateTile;
import mrtjp.projectred.fabrication.engine.gates.SequencerGateTile;
import mrtjp.projectred.fabrication.engine.gates.StateCellGateTile;
import mrtjp.projectred.fabrication.engine.gates.SynchronizerGateTile;
import mrtjp.projectred.fabrication.engine.gates.TimerGateTile;
import mrtjp.projectred.fabrication.engine.gates.ToggleLatchGateTile;
import mrtjp.projectred.fabrication.engine.gates.TransparentLatchGateTile;
import mrtjp.projectred.fabrication.engine.gates.XNORGateTile;
import mrtjp.projectred.fabrication.engine.gates.XORGateTile;

public class PRFabricationEngine
extends FabricationEngine {
    public static final int REG_IN_BASE = 0;
    public static final int REG_OUT_BASE = 64;
    public static final int REG_TIME_7 = 128;
    public static final int REG_TIME_6 = 129;
    public static final int REG_TIME_5 = 130;
    public static final int REG_TIME_4 = 131;
    public static final int REG_TIME_3 = 132;
    public static final int REG_TIME_2 = 133;
    public static final int REG_TIME_1 = 134;
    public static final int REG_TIME_0 = 135;
    public static final int REG_ZERO = 136;
    public static final int REG_ONE = 137;
    public static final int[] REG_TIME = new int[]{128, 129, 130, 131, 132, 133, 134, 135};
    public static final PRFabricationEngine instance = new PRFabricationEngine();
    public static final ICFlatMap EMPTY_FLAT_MAP = instance.newAssembler().result();
    public static final String EMPTY_FLAT_MAP_SERIALIZED = instance.serializeFlatMap(EMPTY_FLAT_MAP);
    public static final String EMPTY_SIMULATION_SERIALIZED = instance.serializeSimulation(new ICSimulation(EMPTY_FLAT_MAP));
    public static final int COMPILE_FORMAT = 1;

    public static int inputRegisterId(int r, int i) {
        return 0 + r * 16 + i;
    }

    public static int outputRegisterId(int r, int i) {
        return 64 + r * 16 + i;
    }

    @Override
    public ICAssembler newAssembler() {
        ICAssembler assembler = super.newAssembler();
        this.addStaticRegisters(assembler);
        return assembler;
    }

    @Override
    public ICStepThroughAssembler newStepThroughAssembler() {
        ICStepThroughAssembler assembler = super.newStepThroughAssembler();
        this.addStaticRegisters(assembler);
        return assembler;
    }

    private void addStaticRegisters(ICAssembler assembler) {
        int i;
        for (i = 0; i < 16; ++i) {
            for (int r = 0; r < 4; ++r) {
                assembler.addRegister(PRFabricationEngine.inputRegisterId(r, i), new ByteRegister());
                assembler.addRegister(PRFabricationEngine.outputRegisterId(r, i), new ByteRegister());
            }
        }
        for (i = 0; i < 8; ++i) {
            assembler.addRegister(REG_TIME[i], new ByteRegister());
        }
        assembler.addRegister(136, new StaticByteRegister(0));
        assembler.addRegister(137, new StaticByteRegister(1));
    }

    @Override
    public Map<Class<? extends ICGate>, String> getGateSerializationMap() {
        HashMap<Class<? extends ICGate>, String> map = new HashMap<Class<? extends ICGate>, String>();
        map.put(ORGateTile.ORGate.class, "pr_or");
        map.put(NORGateTile.NORGate.class, "pr_nor");
        map.put(NOTGateTile.NOTGate.class, "pr_not");
        map.put(ANDGateTile.ANDGate.class, "pr_and");
        map.put(NANDGateTile.NANDGate.class, "pr_nand");
        map.put(XORGateTile.XORGate.class, "pr_xor");
        map.put(XNORGateTile.XNORGate.class, "pr_xnor");
        map.put(BufferGateTile.BufferGate.class, "pr_buff");
        map.put(MultiplexerGateTile.MultiplexerGate.class, "pr_mlpx");
        map.put(PulseGateTile.PulseGate.class, "pr_pulse");
        map.put(RepeaterGateTile.RepeaterGate.class, "pr_repeater");
        map.put(RandomizerGateTile.RandomizerGate.class, "pr_rand");
        map.put(SRLatchGateTile.SRLatchGate.class, "pr_srlatch");
        map.put(ToggleLatchGateTile.ToggleLatchGate.class, "pr_tglatch");
        map.put(TransparentLatchGateTile.TransparentLatchGate.class, "pr_trlatch");
        map.put(TimerGateTile.TimerGate.class, "pr_timer");
        map.put(SequencerGateTile.SequencerGate.class, "pr_seq");
        map.put(CounterGateTile.CounterGate.class, "pr_counter");
        map.put(StateCellGateTile.StateCellGate.class, "pr_statecell");
        map.put(SynchronizerGateTile.SynchronizerGate.class, "pr_sync");
        return map;
    }
}

