/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.fengine.tiles;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.api.IPathFinder;
import mrtjp.fengine.assemble.PathFinderResult;
import mrtjp.fengine.tiles.FETile;

public abstract class FEPortlessNestedMapTile
implements FETile {
    private final int[] inputRegisters = new int[6];
    private final int[] outputRegisters = new int[6];

    public FEPortlessNestedMapTile() {
        Arrays.fill(this.inputRegisters, -1);
        Arrays.fill(this.outputRegisters, -1);
    }

    abstract int getOutDirMask();

    abstract int getInDirMask();

    abstract Map<Integer, Integer> getInputSignalMap();

    abstract Map<Integer, Integer> getOutputSignalMap();

    abstract void addMapToAssembler(ICAssemblyTile.Collector var1, Map<Integer, Integer> var2);

    @Override
    public Optional<Integer> getInputRegister(int inDir, int inPort) {
        int regId = this.inputRegisters[inDir];
        return (this.getInDirMask() & 1 << inDir) != 0 && regId > -1 ? Optional.of(regId) : Optional.empty();
    }

    @Override
    public Optional<Integer> getOutputRegister(int outDir, int outPort) {
        int regId = this.outputRegisters[outDir];
        return (this.getOutDirMask() & 1 << outDir) != 0 && regId > -1 ? Optional.of(regId) : Optional.empty();
    }

    @Override
    public void allocate(ICAssemblyTile.Allocator allocator) {
        for (int dir = 0; dir < 6; ++dir) {
            this.outputRegisters[dir] = (this.getOutDirMask() & 1 << dir) != 0 ? allocator.allocRegisterID() : -1;
            this.inputRegisters[dir] = -1;
        }
    }

    @Override
    public void locate(IPathFinder pathFinder) {
        for (int dir = 0; dir < 6; ++dir) {
            if ((this.getInDirMask() & 1 << dir) == 0) continue;
            int finalDir = dir;
            PathFinderResult pfr = pathFinder.doPathFinding((d, p) -> d == finalDir);
            if (pfr.outputRegisters.size() > 1) {
                System.out.println("ERR: Unexpected multiple drivers: " + pfr.outputRegisters);
            }
            if (pfr.outputRegisters.isEmpty()) continue;
            this.inputRegisters[dir] = pfr.outputRegisters.get(0);
        }
    }

    @Override
    public void consumeRemaps(ICAssemblyTile.RemapProvider remapProvider) {
        for (int dir = 0; dir < 6; ++dir) {
            this.outputRegisters[dir] = remapProvider.getRemappedRegisterID(this.outputRegisters[dir]);
            this.inputRegisters[dir] = remapProvider.getRemappedRegisterID(this.inputRegisters[dir]);
        }
    }

    @Override
    public void collect(ICAssemblyTile.Collector collector) {
        HashMap<Integer, Integer> remaps = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> e : this.getInputSignalMap().entrySet()) {
            int inDir = e.getKey();
            int outsideInputReg = this.inputRegisters[inDir];
            int insideInputReg = e.getValue();
            remaps.put(insideInputReg, outsideInputReg);
        }
        for (Map.Entry<Integer, Integer> e : this.getOutputSignalMap().entrySet()) {
            int outDir = e.getKey();
            int outsideOutputReg = this.outputRegisters[outDir];
            int insideOutputReg = e.getValue();
            remaps.put(insideOutputReg, outsideOutputReg);
        }
        this.addMapToAssembler(collector, remaps);
    }
}

