/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.fengine.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import mrtjp.fengine.api.ICAssembler;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.api.ICFlatMap;
import mrtjp.fengine.assemble.PathFinder;
import mrtjp.fengine.assemble.PathFinderManifest;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICRegister;
import mrtjp.fengine.tiles.FETileMap;

public class ICAssemblerImpl
implements ICAssembler,
ICAssemblyTile.Allocator,
ICAssemblyTile.RemapRegistry,
ICAssemblyTile.RemapProvider,
ICAssemblyTile.Collector {
    private final Map<Integer, ICRegister> registers = new HashMap<Integer, ICRegister>();
    private final Map<Integer, ICGate> gates = new HashMap<Integer, ICGate>();
    private final Map<Integer, ArrayList<Integer>> regDependents = new HashMap<Integer, ArrayList<Integer>>();
    private final Map<Integer, ArrayList<Integer>> regDependencies = new HashMap<Integer, ArrayList<Integer>>();
    private final Map<Integer, ArrayList<Integer>> gateDependents = new HashMap<Integer, ArrayList<Integer>>();
    private final Map<Integer, ArrayList<Integer>> gateDependencies = new HashMap<Integer, ArrayList<Integer>>();
    private final List<FETileMap> exploredTileMaps = new ArrayList<FETileMap>();
    private final List<ICFlatMap> exploredFlatMaps = new ArrayList<ICFlatMap>();
    private final Queue<TileMapRemapPair> openTileMaps = new LinkedList<TileMapRemapPair>();
    private final Queue<FlatMapRemapPair> openFlatMaps = new LinkedList<FlatMapRemapPair>();
    private final PathFinderManifest pathFinderManifest = new PathFinderManifest();
    private final Map<Integer, Integer> registerIDRemaps = new HashMap<Integer, Integer>();
    private int nextRegID = 0;
    private int nextGateID = 0;

    @Override
    public int allocRegisterID() {
        return this.nextRegID++;
    }

    @Override
    public int allocGateID() {
        return this.nextGateID++;
    }

    @Override
    public int allocRegisterID(int id) {
        if (id >= this.nextRegID) {
            this.nextRegID = id + 1;
        }
        return id;
    }

    @Override
    public int allocGateID(int id) {
        if (id >= this.nextGateID) {
            this.nextGateID = id + 1;
        }
        return id;
    }

    @Override
    public int getRemappedRegisterID(int id) {
        return this.registerIDRemaps.getOrDefault(id, id);
    }

    @Override
    public void addRemap(int oldID, int newID) {
        this.registerIDRemaps.put(oldID, this.getRemappedRegisterID(newID));
    }

    @Override
    public void addRegister(int id, ICRegister r) {
        if (this.registers.containsKey(id)) {
            System.out.println("Warning: Dropping register " + id + " due to duplicate ID");
            return;
        }
        this.allocRegisterID(id);
        this.registers.put(id, r);
    }

    @Override
    public void addGate(int id, ICGate gate, List<Integer> drivingRegs, List<Integer> drivenRegs) {
        if (this.gates.containsKey(id)) {
            throw new IllegalArgumentException("Gate ID " + id + " already exists");
        }
        this.allocGateID(id);
        this.gates.put(id, gate);
        for (int regID : drivingRegs) {
            this.regDependents.putIfAbsent(regID, new ArrayList());
            this.regDependents.get(regID).add(id);
        }
        for (int regID : drivenRegs) {
            this.regDependencies.putIfAbsent(regID, new ArrayList());
            this.regDependencies.get(regID).add(id);
        }
        this.gateDependents.putIfAbsent(id, new ArrayList());
        this.gateDependents.get(id).addAll(drivenRegs);
        this.gateDependencies.putIfAbsent(id, new ArrayList());
        this.gateDependencies.get(id).addAll(drivingRegs);
    }

    @Override
    public void addTileMap(FETileMap map, Map<Integer, Integer> remaps) {
        this.openTileMaps.add(new TileMapRemapPair(map, remaps));
    }

    @Override
    public void addFlatMap(ICFlatMap flatMap, Map<Integer, Integer> remaps) {
        this.openFlatMaps.add(new FlatMapRemapPair(flatMap, remaps));
    }

    private void mergeTileMap(FETileMap map, Map<Integer, Integer> remaps) {
        System.out.println("Assembly merge tile map setup");
        this.pathFinderManifest.clear();
        this.registerIDRemaps.clear();
        this.registerIDRemaps.putAll(remaps);
        System.out.println("Assembly Phase 1: Allocations");
        Collection<FETileMap.TileMapEntry> entries = map.getEntries();
        for (FETileMap.TileMapEntry entry : entries) {
            entry.getTile().allocate(this);
        }
        System.out.println("Assembly Phase 2: Pathfinding and remap declarations");
        for (FETileMap.TileMapEntry entry : entries) {
            System.out.println("Pathfinding at " + entry.getCoord());
            PathFinder pathFinder = new PathFinder(map, entry.getCoord(), this.pathFinderManifest);
            entry.getTile().locate(pathFinder);
        }
        for (FETileMap.TileMapEntry entry : entries) {
            entry.getTile().searchManifest(this.pathFinderManifest.getManifest(entry.getCoord()));
        }
        System.out.println("Assembly Phase 4: Register remaps");
        for (FETileMap.TileMapEntry entry : entries) {
            entry.getTile().registerRemaps(this);
        }
        System.out.println("Assembly Phase 5: Consume remaps");
        for (FETileMap.TileMapEntry entry : entries) {
            entry.getTile().consumeRemaps(this);
        }
        System.out.println("Assembly Phase 6: Register and Gate collection");
        for (FETileMap.TileMapEntry entry : entries) {
            entry.getTile().collect(this);
        }
        System.out.println("Assembly merge tile map cleanup");
        this.pathFinderManifest.clear();
        this.registerIDRemaps.clear();
    }

    private void mergeFlatMap(ICFlatMap map, Map<Integer, Integer> remaps) {
        int newId;
        int oldId;
        HashMap<Integer, Integer> gateTransforms = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> regTransforms = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, ICRegister> entry : map.getRegisters().entrySet()) {
            oldId = entry.getKey();
            newId = remaps.getOrDefault(oldId, this.allocRegisterID());
            regTransforms.put(oldId, newId);
        }
        for (Map.Entry<Integer, Object> entry : map.getGates().entrySet()) {
            oldId = entry.getKey();
            newId = this.allocGateID();
            gateTransforms.put(oldId, newId);
        }
        for (Map.Entry<Integer, Object> entry : map.getRegisters().entrySet()) {
            oldId = entry.getKey();
            newId = (Integer)regTransforms.get(oldId);
            if (this.registers.containsKey(newId)) continue;
            this.addRegister(newId, (ICRegister)entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : map.getGates().entrySet()) {
            oldId = entry.getKey();
            newId = (Integer)gateTransforms.get(oldId);
            List<Integer> newDriving = map.getGateDependencies().get(oldId).stream().map(regTransforms::get).collect(Collectors.toList());
            List<Integer> newDriven = map.getGateDependents().get(oldId).stream().map(regTransforms::get).collect(Collectors.toList());
            this.addGate(newId, (ICGate)entry.getValue(), newDriving, newDriven);
        }
    }

    @Override
    public ICFlatMap result() {
        Object pair;
        while (!this.openTileMaps.isEmpty()) {
            pair = this.openTileMaps.poll();
            this.mergeTileMap(((TileMapRemapPair)pair).map, ((TileMapRemapPair)pair).remaps);
            this.exploredTileMaps.add(((TileMapRemapPair)pair).map);
        }
        while (!this.openFlatMaps.isEmpty()) {
            pair = this.openFlatMaps.poll();
            this.mergeFlatMap(((FlatMapRemapPair)pair).map, ((FlatMapRemapPair)pair).remaps);
            this.exploredFlatMaps.add(((FlatMapRemapPair)pair).map);
        }
        return new ICFlatMap(this.registers, this.gates, this.regDependents, this.regDependencies, this.gateDependents, this.gateDependencies);
    }

    private int getMapIndex() {
        return this.exploredFlatMaps.size() + this.exploredTileMaps.size();
    }

    private static class FlatMapRemapPair {
        ICFlatMap map;
        Map<Integer, Integer> remaps;

        public FlatMapRemapPair(ICFlatMap map, Map<Integer, Integer> remaps) {
            this.map = map;
            this.remaps = remaps;
        }
    }

    private static class TileMapRemapPair {
        FETileMap map;
        Map<Integer, Integer> remaps;

        public TileMapRemapPair(FETileMap map, Map<Integer, Integer> remaps) {
            this.map = map;
            this.remaps = remaps;
        }
    }
}

