/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.integrations.productivebees;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.ExpansionBox;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.ExpansionBoxBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.event.BeeReleaseEvent;
import cy.jdkdigital.productivetrees.Config;
import cy.jdkdigital.productivetrees.common.block.ProductiveFruitBlock;
import cy.jdkdigital.productivetrees.common.block.entity.PollinatedLeavesBlockEntity;
import cy.jdkdigital.productivetrees.recipe.TreePollinationRecipe;
import cy.jdkdigital.productivetrees.registry.ModTags;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.registry.WoodObject;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class CompatHandler {
    private static List<RegistryObject<Block>> HIVES = new ArrayList<RegistryObject<Block>>();
    private static List<RegistryObject<Block>> BOXES = new ArrayList<RegistryObject<Block>>();

    public static void createHive(String name, WoodObject woodObject, ToIntFunction<BlockState> lightLevel) {
        String hiveName = "advanced_" + name + "_beehive";
        String boxName = "expansion_box_" + name;
        TreeRegistrator.registerBlock(hiveName, () -> new AdvancedBeehive(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50718_).m_60953_(lightLevel), TreeRegistrator.registerBlockEntity(hiveName, () -> TreeRegistrator.createBlockEntityType((pos, state) -> new AdvancedBeehiveBlockEntity((AdvancedBeehive)ForgeRegistries.BLOCKS.getValue(woodObject.getId().m_247266_(p -> "advanced_" + p + "_beehive")), pos, state), (Block)ForgeRegistries.BLOCKS.getValue(woodObject.getId().m_247266_(p -> "advanced_" + p + "_beehive"))))), true);
        TreeRegistrator.registerBlock(boxName, () -> new ExpansionBox(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50718_).m_60953_(lightLevel), TreeRegistrator.registerBlockEntity(boxName, () -> TreeRegistrator.createBlockEntityType((pos, state) -> new ExpansionBoxBlockEntity((ExpansionBox)ForgeRegistries.BLOCKS.getValue(woodObject.getId().m_247266_(p -> "expansion_box_" + p)), pos, state), (Block)ForgeRegistries.BLOCKS.getValue(woodObject.getId().m_247266_(p -> "expansion_box_" + p))))), true);
    }

    public static void beeRelease(BeeReleaseEvent event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (event.getBeeState().equals((Object)BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED) && (level = event.getBlockEntity()) instanceof AdvancedBeehiveBlockEntity) {
                AdvancedBeehiveBlockEntity advancedBeehiveBlockEntity = (AdvancedBeehiveBlockEntity)level;
                if (event.getBee().m_27855_() != null) {
                    BlockPos pos = event.getBee().m_27855_();
                    int distance = 4 + 2 * advancedBeehiveBlockEntity.getUpgradeCount((Item)ModItems.UPGRADE_RANGE.get());
                    List<BlockPos> leaves = BlockPos.m_121990_((BlockPos)pos.m_7918_(-distance, -distance, -distance), (BlockPos)pos.m_7918_(distance, distance, distance)).map(BlockPos::m_7949_).collect(Collectors.toList());
                    ArrayList uniqueLeaves = new ArrayList();
                    HashMap leafMap = new HashMap();
                    leaves.forEach(blockPos -> {
                        BlockState state = level2.m_8055_(blockPos);
                        if (state.m_204336_(ModTags.POLLINATABLE) && !state.m_60713_((Block)TreeRegistrator.POLLINATED_LEAVES.get()) && !(state.m_60734_() instanceof ProductiveFruitBlock)) {
                            leafMap.put(state, blockPos);
                            if (!uniqueLeaves.contains(state)) {
                                uniqueLeaves.add(state);
                            }
                        }
                    });
                    if (uniqueLeaves.size() > 0) {
                        ProductiveBee pBee;
                        Bee bee = event.getBee();
                        boolean isSpecialPollinator = bee instanceof ProductiveBee && (pBee = (ProductiveBee)bee).getBeeName().equals("allergy");
                        int sieveUpgrades = advancedBeehiveBlockEntity.getUpgradeCount((Item)TreeRegistrator.UPGRADE_POLLEN_SIEVE.get());
                        if (sieveUpgrades > 0 && level2.f_46441_.m_188503_(100) < (Integer)Config.SERVER.pollenChanceFromSieve.get() * (isSpecialPollinator ? 5 : 1)) {
                            BlockState pollenLeaf = (BlockState)uniqueLeaves.get(level2.f_46441_.m_188503_(uniqueLeaves.size()));
                            advancedBeehiveBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
                                ItemStack pollenStack = TreeUtil.getPollen(pollenLeaf.m_60734_());
                                ((InventoryHandlerHelper.BlockEntityItemStackHandler)inv).addOutput(pollenStack);
                            });
                        }
                        HashMap matchedRecipes = new HashMap();
                        List allRecipes = level2.m_7465_().m_44013_((RecipeType)TreeRegistrator.TREE_POLLINATION_TYPE.get());
                        allRecipes.forEach(treePollinationRecipe -> uniqueLeaves.forEach(stateA -> uniqueLeaves.forEach(stateB -> {
                            if (!matchedRecipes.containsKey(treePollinationRecipe) && treePollinationRecipe.matches((BlockState)stateA, (BlockState)stateB)) {
                                matchedRecipes.put(treePollinationRecipe, Pair.of((Object)stateA, (Object)stateB));
                            }
                        })));
                        if (matchedRecipes.size() > 0) {
                            TreePollinationRecipe pickedRecipe = (TreePollinationRecipe)matchedRecipes.keySet().toArray()[level2.f_46441_.m_188503_(matchedRecipes.size())];
                            Pair states = (Pair)matchedRecipes.get(pickedRecipe);
                            BlockPos posA = level2.f_46441_.m_188499_() ? (BlockPos)leafMap.get(states.getFirst()) : (BlockPos)leafMap.get(states.getSecond());
                            if (level2.f_46441_.m_188503_(100) <= pickedRecipe.chance * (isSpecialPollinator ? 5 : 1) && level2.m_8055_(posA).m_204336_(BlockTags.f_13035_)) {
                                level2.m_7731_(posA, ((Block)TreeRegistrator.POLLINATED_LEAVES.get()).m_49966_(), 3);
                                BlockEntity blockEntity = level2.m_7702_(posA);
                                if (blockEntity instanceof PollinatedLeavesBlockEntity) {
                                    PollinatedLeavesBlockEntity pollinatedLeavesBlockEntity = (PollinatedLeavesBlockEntity)blockEntity;
                                    pollinatedLeavesBlockEntity.setLeafA(((BlockState)states.getFirst()).m_60734_());
                                    pollinatedLeavesBlockEntity.setLeafB(((BlockState)states.getSecond()).m_60734_());
                                    pollinatedLeavesBlockEntity.setResult(pickedRecipe.result);
                                    pollinatedLeavesBlockEntity.m_6596_();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static void registerBlockEntities() {
    }
}

