/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.railwayteam.railways.content.palettes.boiler.BoilerBlock;
import com.railwayteam.railways.registry.CRPalettes;
import com.simibubi.create.foundation.utility.Components;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PalettesDemoCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"palettes_demo").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> {
            BlockPos origin = BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos");
            PatternBuilder pattern = PalettesDemoCommand.create();
            pattern.place((Level)((CommandSourceStack)ctx.getSource()).m_81372_(), origin, null);
            for (DyeColor dyeColor : DyeColor.values()) {
                origin = origin.m_7918_(pattern.maxWidth + 2, 0, 0);
                pattern.place((Level)((CommandSourceStack)ctx.getSource()).m_81372_(), origin, dyeColor);
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Components.literal((String)"Placed palettes blocks"), true);
            return 1;
        }));
    }

    private static PatternBuilder create() {
        return new PatternBuilder().next(CRPalettes.Styles.SLASHED).next(CRPalettes.Styles.SLASHED).next(CRPalettes.Styles.FLAT_SLASHED).next(CRPalettes.Styles.SMOKEBOX).transform(RotatedPillarBlock.f_55923_, Direction.Axis.Y).nextRow().next(CRPalettes.Styles.RIVETED).next(CRPalettes.Styles.RIVETED).next(CRPalettes.Styles.FLAT_RIVETED).next(CRPalettes.Styles.SMOKEBOX).transform(RotatedPillarBlock.f_55923_, Direction.Axis.Z).nextRow().next(CRPalettes.Styles.PILLAR).transform(RotatedPillarBlock.f_55923_, Direction.Axis.Y).next(CRPalettes.Styles.PILLAR).transform(RotatedPillarBlock.f_55923_, Direction.Axis.Z).next(CRPalettes.Styles.PLATED).next(CRPalettes.Styles.BRASS_WRAPPED_SLASHED).nextRow().next(CRPalettes.Styles.IRON_WRAPPED_SLASHED).next(CRPalettes.Styles.COPPER_WRAPPED_SLASHED).next(CRPalettes.Styles.COPPER_WRAPPED_SLASHED).next(CRPalettes.Styles.BRASS_WRAPPED_SLASHED).nextRow().nextRow().next(CRPalettes.Styles.BOILER).transform(BoilerBlock.HORIZONTAL_AXIS, Direction.Axis.X).next(CRPalettes.Styles.BRASS_WRAPPED_BOILER).transform(BoilerBlock.HORIZONTAL_AXIS, Direction.Axis.X).next(CRPalettes.Styles.COPPER_WRAPPED_BOILER).transform(BoilerBlock.HORIZONTAL_AXIS, Direction.Axis.X).next(CRPalettes.Styles.IRON_WRAPPED_BOILER).transform(BoilerBlock.HORIZONTAL_AXIS, Direction.Axis.X).nextRow().nextRow().next(CRPalettes.Styles.BOILER).transform(BoilerBlock.HORIZONTAL_AXIS, Direction.Axis.Z).transform(BoilerBlock.STYLE, BoilerBlock.Style.GULLET).skip().skip().next(CRPalettes.Styles.BOILER).transform(BoilerBlock.HORIZONTAL_AXIS, Direction.Axis.Z).transform(BoilerBlock.STYLE, BoilerBlock.Style.SMOKEBOX);
    }

    private static class PatternBuilder {
        @Nullable
        private Entry latest = null;
        final List<Entry> entries = new ArrayList<Entry>();
        int xOffset = 0;
        int yOffset = 0;
        int maxWidth = 0;

        private PatternBuilder() {
        }

        PatternBuilder next(CRPalettes.Styles style) {
            this.latest = new Entry(style, this.xOffset, this.yOffset);
            ++this.xOffset;
            this.maxWidth = Math.max(this.maxWidth, this.xOffset);
            this.entries.add(this.latest);
            return this;
        }

        PatternBuilder skip() {
            ++this.xOffset;
            this.maxWidth = Math.max(this.maxWidth, this.xOffset);
            return this;
        }

        PatternBuilder nextRow() {
            this.xOffset = 0;
            ++this.yOffset;
            return this;
        }

        <T extends Comparable<T>> PatternBuilder transform(Property<T> property, T value) {
            if (this.latest != null) {
                this.latest.transforms.add(Transform.of(property, value));
            }
            return this;
        }

        void place(Level level, BlockPos pos, DyeColor color) {
            for (Entry entry : this.entries) {
                BlockState state = entry.style.get(color).getDefaultState();
                for (Transform<?> transform : entry.transforms) {
                    state = transform.apply(state);
                }
                level.m_46597_(pos.m_7918_(entry.xOffset, entry.yOffset, 0), state);
            }
        }
    }

    private static class Entry {
        final CRPalettes.Styles style;
        final int xOffset;
        final int yOffset;
        final List<Transform<?>> transforms = new ArrayList();

        private Entry(CRPalettes.Styles style, int xOffset, int yOffset) {
            this.style = style;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }
    }

    private record Transform<T extends Comparable<T>>(Property<T> property, T value) {
        public static <T extends Comparable<T>> Transform<T> of(Property<T> property, T value) {
            return new Transform<T>(property, value);
        }

        public BlockState apply(BlockState state) {
            return (BlockState)state.m_61124_(this.property, this.value);
        }
    }
}

