/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.RailwaysClient;
import com.railwayteam.railways.forge.RailwaysImpl;
import com.railwayteam.railways.registry.CRExtraDisplayTags;
import com.railwayteam.railways.registry.CRParticleTypes;
import com.simibubi.create.foundation.ModFilePackResources;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.forgespi.locating.IModFile;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RailwaysClientImpl {
    private static final Set<Consumer<CommandDispatcher<SharedSuggestionProvider>>> clientCommandConsumers = new HashSet<Consumer<CommandDispatcher<SharedSuggestionProvider>>>();
    private static final Map<ModelLayerLocation, Supplier<LayerDefinition>> modelLayers = new HashMap<ModelLayerLocation, Supplier<LayerDefinition>>();
    private static final List<PackInfo> packs = new ArrayList<PackInfo>();

    public static void init() {
        RailwaysClient.init();
        RailwaysImpl.bus.addListener(RailwaysClientImpl::onModelLayerRegistration);
        RailwaysImpl.bus.addListener(RailwaysClientImpl::onBuiltinPackRegistration);
        RailwaysImpl.bus.addListener(RailwaysClientImpl::onClientSetup);
        RailwaysImpl.bus.addListener(event -> CRParticleTypes.registerFactories());
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        CRExtraDisplayTags.register();
    }

    public static void registerClientCommands(Consumer<CommandDispatcher<SharedSuggestionProvider>> consumer) {
        clientCommandConsumers.add(consumer);
    }

    @SubscribeEvent
    public static void onClientCommandRegistration(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher;
        CommandDispatcher casted = dispatcher = event.getDispatcher();
        clientCommandConsumers.forEach(consumer -> consumer.accept(casted));
    }

    public static void registerModelLayer(ModelLayerLocation layer, Supplier<LayerDefinition> definition) {
        modelLayers.put(layer, definition);
    }

    public static void onModelLayerRegistration(EntityRenderersEvent.RegisterLayerDefinitions event) {
        modelLayers.forEach((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
        modelLayers.clear();
    }

    public static void registerBuiltinPack(String id, String name) {
        packs.add(new PackInfo(id, name));
    }

    public static void onBuiltinPackRegistration(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        IModFile modFile = ModList.get().getModFileById("railways").getFile();
        packs.forEach(pack -> event.addRepositorySource(consumer -> consumer.accept(Pack.m_245512_((String)Railways.asResource(pack.id).toString(), (Component)Component.m_237113_((String)pack.name), (boolean)false, a -> new ModFilePackResources(pack.name, modFile, "resourcepacks/" + pack.id), (Pack.Info)new Pack.Info((Component)Component.m_237119_(), 10, FeatureFlagSet.m_246902_()), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10527_))));
        packs.clear();
    }

    private record PackInfo(String id, String name) {
    }
}

