/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons.items;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.IModule;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.radial.mode.NestedRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.config.value.CachedValue;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.radial.IGenericRadialModeItem;
import mekanism.common.lib.radial.data.NestingRadialData;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import meranha.mekaweapons.MekaWeapons;
import meranha.mekaweapons.MekaWeaponsUtils;
import meranha.mekaweapons.WeaponsLang;
import meranha.mekaweapons.items.MekaArrowEntity;
import meranha.mekaweapons.items.ModuleWeaponAttackAmplificationUnit;
import net.minecraft.client.KeyMapping;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class ItemMekaBow
extends BowItem
implements IModuleContainerItem,
IGenericRadialModeItem {
    private final Int2ObjectMap<AttributeCache> attributeCaches = new Int2ObjectArrayMap(ModuleWeaponAttackAmplificationUnit.AttackDamage.values().length - 2);
    private static final ResourceLocation RADIAL_ID = MekaWeapons.rl("meka_bow");

    public ItemMekaBow(@NotNull Item.Properties properties) {
        super(properties.m_41497_(Rarity.EPIC).setNoRepair().m_41487_(1));
    }

    public void m_7373_(@Nonnull @NotNull ItemStack stack, @Nullable Level world, @Nonnull @NotNull List<Component> tooltip, @Nullable @NotNull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed((KeyMapping)MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
            return;
        }
        StorageUtils.addStoredEnergy((ItemStack)stack, tooltip, (boolean)true);
        if (this.hasModule(stack, (IModuleDataProvider)MekaWeapons.AUTOFIRE_UNIT)) {
            tooltip.add((Component)WeaponsLang.AUTOFIRE_MODE.translateColored(EnumColor.YELLOW, new Object[]{BooleanStateDisplay.OnOff.of((boolean)this.isModuleEnabled(stack, (IModuleDataProvider)MekaWeapons.AUTOFIRE_UNIT))}));
        }
        if (this.hasModule(stack, (IModuleDataProvider)MekaWeapons.ARROWENERGY_UNIT)) {
            tooltip.add((Component)WeaponsLang.ARROWENERGY_MODE.translateColored(EnumColor.YELLOW, new Object[]{BooleanStateDisplay.OnOff.of((boolean)this.isModuleEnabled(stack, (IModuleDataProvider)MekaWeapons.ARROWENERGY_UNIT))}));
        }
        tooltip.add((Component)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, new Object[]{EnumColor.INDIGO, MekanismKeyHandler.detailsKey.m_90863_()}));
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            FloatingLong energy;
            IModule attackAmplificationUnit = this.getModule(stack, (IModuleDataProvider)MekaWeapons.ATTACKAMPLIFICATION_UNIT);
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
            FloatingLong floatingLong = energy = energyContainer != null ? energyContainer.getEnergy() : FloatingLong.ZERO;
            int unitDamage = energy.greaterOrEqual((FloatingLong)MekaWeapons.general.mekaBowEnergyUsage.get()) ? (attackAmplificationUnit != null ? ((ModuleWeaponAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getCurrentUnit() : 1) : 0;
            long totalDamage = MekaWeaponsUtils.getTotalDamage(stack);
            return (Multimap)((AttributeCache)this.attributeCaches.compute(unitDamage, (damage, previous) -> {
                AttributeModifier currentDamage = new AttributeModifier(f_41374_, "Weapon modifier", (double)totalDamage, AttributeModifier.Operation.ADDITION);
                if (previous != null && ((Multimap)previous.get()).containsKey((Object)Attributes.f_22281_) && ((Multimap)previous.get()).get((Object)Attributes.f_22281_).equals(currentDamage)) {
                    return previous;
                }
                return new AttributeCache(builder -> builder.put((Object)Attributes.f_22281_, (Object)currentDamage), new CachedValue[0]);
            })).get();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public void m_5929_(@Nonnull @NotNull Level world, @Nonnull @NotNull LivingEntity player, @Nonnull @NotNull ItemStack stack, int timeLeft) {
        if (this.isModuleEnabled(stack, (IModuleDataProvider)MekaWeapons.AUTOFIRE_UNIT) && (float)(this.m_8105_(stack) - timeLeft) == this.getUseTick(stack)) {
            player.m_5810_();
            stack.m_41674_(world, player, 0);
            player.m_6672_(player.m_7655_());
        }
    }

    public void m_5551_(@Nonnull @NotNull ItemStack bow, @Nonnull @NotNull Level world, @Nonnull @NotNull LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)bow, (int)0);
            if (!player.m_7500_() && !this.hasEnoughEnergy(energyContainer)) {
                return;
            }
            ItemStack potentialAmmo = player.m_6298_(bow);
            boolean hasAmmo = !potentialAmmo.m_41619_() || this.isModuleEnabled(bow, (IModuleDataProvider)MekaWeapons.ARROWENERGY_UNIT);
            int charge = ForgeEventFactory.onArrowLoose((ItemStack)bow, (Level)world, (Player)player, (int)(this.m_8105_(bow) - timeLeft), (boolean)hasAmmo);
            if (charge < 0 || !hasAmmo) {
                return;
            }
            float velocity = ItemMekaBow.m_40661_((int)charge);
            if ((double)velocity < 0.1) {
                return;
            }
            if (potentialAmmo.m_41619_()) {
                potentialAmmo = new ItemStack((ItemLike)Items.f_42412_);
            }
            if (!world.f_46443_) {
                ArrowItem arrowitem = (ArrowItem)(potentialAmmo.m_41720_() instanceof ArrowItem ? potentialAmmo.m_41720_() : Items.f_42412_);
                AbstractArrow arrowEntity = this.customArrow(arrowitem.m_6394_(world, potentialAmmo, (LivingEntity)player));
                int unitMultiplier = 0;
                arrowEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, (float)(3 + unitMultiplier) * velocity, 0.0f);
                long totalDamage = MekaWeaponsUtils.getTotalDamage(bow);
                arrowEntity.m_36781_((double)totalDamage);
                if (this.isModuleEnabled(bow, (IModuleDataProvider)MekaWeapons.ARROWENERGY_UNIT) && (potentialAmmo.m_41720_() == Items.f_42737_ || potentialAmmo.m_41720_() == Items.f_42738_)) {
                    arrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                world.m_7967_((Entity)arrowEntity);
            }
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (world.f_46441_.m_188501_() * 0.4f + 1.2f) + velocity * 0.5f);
            if (!this.isModuleEnabled(bow, (IModuleDataProvider)MekaWeapons.ARROWENERGY_UNIT)) {
                potentialAmmo.m_41774_(1);
                if (potentialAmmo.m_41619_()) {
                    player.m_150109_().m_36057_(potentialAmmo);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            long energyNeeded = MekaWeaponsUtils.getEnergyNeeded(bow);
            if (!player.m_7500_()) {
                energyContainer.extract(FloatingLong.create((long)energyNeeded), Action.EXECUTE, AutomationType.MANUAL);
            }
        }
        super.m_5551_(bow, world, entity, timeLeft);
    }

    private boolean hasEnoughEnergy(IEnergyContainer energyContainer) {
        return energyContainer != null && energyContainer.getEnergy().greaterOrEqual((FloatingLong)MekaWeapons.general.mekaBowEnergyUsage.get());
    }

    @NotNull
    public AbstractArrow customArrow(AbstractArrow arrow) {
        ItemStack itemStack;
        Entity entity = arrow.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            itemStack = player.m_21205_();
        } else {
            itemStack = ItemStack.f_41583_;
        }
        ItemStack weapon = itemStack;
        return new MekaArrowEntity(arrow.m_9236_(), arrow.m_20185_(), arrow.m_20186_(), arrow.m_20189_(), new ItemStack((ItemLike)Items.f_42412_), weapon);
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.m_41720_() != newStack.m_41720_();
    }

    public void addItems(@NotNull Consumer<ItemStack> tabOutput) {
        tabOutput.accept(StorageUtils.getFilledEnergyVariant((ItemStack)new ItemStack((ItemLike)this), (FloatingLong)((FloatingLong)MekaWeapons.general.mekaBowBaseEnergyCapacity.get())));
    }

    public boolean m_142522_(@Nonnull @NotNull ItemStack stack) {
        return true;
    }

    public int m_142158_(@Nonnull @NotNull ItemStack stack) {
        return StorageUtils.getEnergyBarWidth((ItemStack)stack);
    }

    public int m_142159_(@Nonnull @NotNull ItemStack stack) {
        return MekaWeaponsUtils.getBarCustomColor(stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        IModule module = this.getModule(stack, (IModuleDataProvider)MekanismModules.ENERGY_UNIT);
        @NotNull FloatingLongSupplier maxEnergy = () -> module == null ? (FloatingLong)MekaWeapons.general.mekaBowBaseEnergyCapacity.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getEnergyCapacity(module);
        return new ItemCapabilityWrapper(stack, new ItemCapabilityWrapper.ItemCapability[]{RateLimitEnergyHandler.create((FloatingLongSupplier)MekaWeapons.general.mekaBowBaseChargeRate, (FloatingLongSupplier)maxEnergy, (Predicate)BasicEnergyContainer.manualOnly, (Predicate)BasicEnergyContainer.alwaysTrue)});
    }

    public boolean shouldCauseBlockBreakReset(@NotNull ItemStack oldStack, @NotNull ItemStack newStack) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public float getUseTick(@NotNull ItemStack stack) {
        float useTick = 20.0f;
        IModule<?> drawSpeedUnit = MekaWeaponsUtils.getEnabledModule(stack, MekaWeapons.DRAWSPEED_UNIT);
        if (drawSpeedUnit != null) {
            useTick -= (float)(5 * drawSpeedUnit.getInstalledCount());
        }
        return useTick;
    }

    public boolean m_8120_(@Nonnull @NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return false;
    }

    public ResourceLocation getRadialIdentifier() {
        return RADIAL_ID;
    }

    public boolean supportsSlotType(ItemStack stack, @NotNull EquipmentSlot slotType) {
        return super.supportsSlotType(stack, slotType) && this.getModules(stack).stream().anyMatch(Module::handlesAnyModeChange);
    }

    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesModeChange()) continue;
            module.changeMode(player, stack, shift, displayChange);
            return;
        }
    }

    protected FloatingLong getMaxEnergy(ItemStack stack) {
        IModule module = this.getModule(stack, (IModuleDataProvider)MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekaWeapons.general.mekaBowBaseEnergyCapacity.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getEnergyCapacity(module);
    }

    protected FloatingLong getChargeRate(ItemStack stack) {
        IModule module = this.getModule(stack, (IModuleDataProvider)MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekaWeapons.general.mekaBowBaseChargeRate.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getChargeRate(module);
    }

    @Nullable
    public RadialData<?> getRadialData(ItemStack stack) {
        ArrayList nestedModes = new ArrayList();
        Consumer<NestedRadialMode> adder = nestedModes::add;
        for (Module module : this.getModules(stack)) {
            if (!module.handlesRadialModeChange()) continue;
            module.addRadialModes(stack, adder);
        }
        if (nestedModes.isEmpty()) {
            return null;
        }
        if (nestedModes.size() == 1) {
            return ((NestedRadialMode)nestedModes.get(0)).nestedData();
        }
        return new NestingRadialData(RADIAL_ID, nestedModes);
    }

    @Nullable
    public <M extends IRadialMode> M getMode(ItemStack stack, RadialData<M> radialData) {
        for (Module module : this.getModules(stack)) {
            IRadialMode mode;
            if (!module.handlesRadialModeChange() || (mode = module.getMode(stack, radialData)) == null) continue;
            return (M)mode;
        }
        return null;
    }

    public <M extends IRadialMode> void setMode(ItemStack stack, Player player, RadialData<M> radialData, M mode) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesRadialModeChange() || !module.setMode(player, stack, radialData, mode)) continue;
            return;
        }
    }

    @Nullable
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return this.getModules(stack).stream().filter(Module::handlesModeChange).findFirst().map(module -> module.getModeScrollComponent(stack)).orElse(null);
    }
}

