/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons;

import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.StorageUtils;
import meranha.mekaweapons.MekaWeapons;
import meranha.mekaweapons.items.ItemMekaBow;
import meranha.mekaweapons.items.ItemMekaTana;
import meranha.mekaweapons.items.ModuleWeaponAttackAmplificationUnit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MekaWeaponsUtils {
    public static int getBaseDamage(@NotNull ItemStack stack) {
        Item weapon = stack.m_41720_();
        Object value = weapon instanceof ItemMekaBow ? MekaWeapons.general.mekaBowBaseDamage : (weapon instanceof ItemMekaTana ? MekaWeapons.general.mekaTanaBaseDamage : null);
        return value != null ? value.get() : 0;
    }

    public static long getBaseEnergyUsage(@NotNull ItemStack stack) {
        Item weapon = stack.m_41720_();
        Object value = weapon instanceof ItemMekaBow ? MekaWeapons.general.mekaBowEnergyUsage : (weapon instanceof ItemMekaTana ? MekaWeapons.general.mekaTanaEnergyUsage : null);
        return value != null ? ((FloatingLong)value.get()).longValue() : 0L;
    }

    public static long getTotalDamage(@NotNull ItemStack weapon) {
        return MekaWeaponsUtils.getTotalDamage(weapon, MekaWeaponsUtils.getEnabledModule(weapon, MekaWeapons.ATTACKAMPLIFICATION_UNIT), MekaWeaponsUtils.getBaseDamage(weapon), MekaWeaponsUtils.getBaseEnergyUsage(weapon));
    }

    public static long getTotalDamage(@NotNull ItemStack weapon, @Nullable IModule<ModuleWeaponAttackAmplificationUnit> attackAmplificationUnit, int baseDamage, long energyUsage) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)weapon, (int)0);
        if (MekaWeaponsUtils.hasNotEnoughEnergy(energyContainer, energyUsage)) {
            return -1L;
        }
        long damage = baseDamage;
        if (attackAmplificationUnit != null) {
            int unitDamage = ((ModuleWeaponAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getCurrentUnit();
            int additionalDamage = (unitDamage - 1) * baseDamage;
            long energyCost = MekaWeaponsUtils.getEnergyNeeded(unitDamage, energyUsage);
            damage = MekaWeaponsUtils.hasNotEnoughEnergy(energyContainer, energyCost) ? (damage += (long)Math.round((float)additionalDamage * energyContainer.getEnergy().divide(FloatingLong.create((long)energyCost)).floatValue())) : (damage += (long)additionalDamage);
        }
        return damage - 1L;
    }

    public static long getEnergyNeeded(@Nullable ItemStack weaponStack) {
        return MekaWeaponsUtils.getEnergyNeeded(weaponStack, MekaWeaponsUtils.getBaseEnergyUsage(weaponStack));
    }

    public static long getEnergyNeeded(@Nullable ItemStack weaponStack, long energyUsage) {
        IModule<ModuleWeaponAttackAmplificationUnit> attackAmplificationUnit = MekaWeaponsUtils.getEnabledModule(weaponStack, MekaWeapons.ATTACKAMPLIFICATION_UNIT);
        return MekaWeaponsUtils.getEnergyNeeded(attackAmplificationUnit != null ? ((ModuleWeaponAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getCurrentUnit() : 1, energyUsage);
    }

    public static long getEnergyNeeded(int unitDamage, long energyUsage) {
        return MathUtils.clampToLong((double)(energyUsage * (long)unitDamage));
    }

    public static int getBarCustomColor(@NotNull ItemStack stack) {
        long energyUsage;
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
        if (MekaWeaponsUtils.hasNotEnoughEnergy(energyContainer, energyUsage = MekaWeaponsUtils.getBaseEnergyUsage(stack))) {
            return MekanismConfig.client.hudDangerColor.get();
        }
        long energyNeeded = MekaWeaponsUtils.getEnergyNeeded(stack, energyUsage);
        if (MekaWeaponsUtils.hasNotEnoughEnergy(energyContainer, energyNeeded)) {
            return MekanismConfig.client.hudWarningColor.get();
        }
        return MekanismConfig.client.energyColor.get();
    }

    public static boolean hasNotEnoughEnergy(@Nullable IEnergyContainer energyContainer, long minEnergy) {
        return energyContainer == null || energyContainer.getEnergy().smallerThan(FloatingLong.create((long)minEnergy));
    }

    @Nullable
    public static <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getEnabledModule(ItemStack stack, IModuleDataProvider<MODULE> typeProvider) {
        return IModuleHelper.INSTANCE.load(stack, typeProvider);
    }

    public static boolean isModuleEnabled(ItemStack stack, IModuleDataProvider<?> type) {
        return IModuleHelper.INSTANCE.isEnabled(stack, type);
    }
}

