/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.serializers.environment;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.serializers.SerializationHelper;
import com.corgam.cagedmobs.serializers.environment.EnvironmentData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.state.BlockState;

public class EnvironmentDataSerializer
implements RecipeSerializer<EnvironmentData> {
    public EnvironmentData fromJson(ResourceLocation recipeId, JsonObject json) {
        Ingredient inputItem = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("input"));
        BlockState renderState = SerializationHelper.deserializeBlockState((JsonElement)json.getAsJsonPrimitive("render"));
        float growModifier = GsonHelper.m_13915_((JsonObject)json, (String)"growModifier");
        HashSet<String> categories = new HashSet<String>();
        for (JsonElement e : json.getAsJsonArray("categories")) {
            categories.add(e.getAsString().toLowerCase());
        }
        if (growModifier <= -1.0f) {
            throw new IllegalArgumentException("Environment " + recipeId.toString() + " has an invalid grow modifier. It must be greater than -1.");
        }
        return new EnvironmentData(recipeId, inputItem, renderState, growModifier, categories);
    }

    public EnvironmentData fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        try {
            Ingredient inputItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            BlockState renderState = SerializationHelper.deserializeBlockState(buffer);
            float growModifier = buffer.readFloat();
            HashSet<String> categories = new HashSet<String>();
            SerializationHelper.deserializeStringCollection(buffer, categories);
            return new EnvironmentData(recipeId, inputItem, renderState, growModifier, categories);
        }
        catch (Exception e) {
            CagedMobs.LOGGER.catching((Throwable)e);
            throw new IllegalStateException("Failed to read environmentData with id: " + recipeId.toString() + " from packet buffer.");
        }
    }

    public void toNetwork(FriendlyByteBuf buffer, EnvironmentData recipe) {
        try {
            recipe.getInputItem().m_43923_(buffer);
            SerializationHelper.serializeBlockState(buffer, recipe.getRenderState());
            buffer.writeFloat(recipe.getGrowModifier());
            SerializationHelper.serializeStringCollection(buffer, recipe.getEnvironments());
        }
        catch (Exception e) {
            CagedMobs.LOGGER.catching((Throwable)e);
            throw new IllegalStateException("Failed to write environmentData with id " + recipe.m_6423_().toString() + " to the packet buffer.");
        }
    }
}

