/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.serializers.entity;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class LootData {
    private final float chance;
    private ItemStack item;
    private ItemStack cookedItem;
    private final int minAmount;
    private final int maxAmount;
    private final boolean lighting;
    private final boolean arrow;
    private final int color;
    private final boolean randomDurability;

    public LootData(ItemStack item, ItemStack cookedItem, float chance, int min, int max, boolean lighting, boolean arrow, int color, boolean randomDurability) {
        this.chance = chance;
        this.item = item;
        this.cookedItem = cookedItem;
        this.minAmount = min;
        this.maxAmount = max;
        this.lighting = lighting;
        this.arrow = arrow;
        this.color = color;
        this.randomDurability = randomDurability;
        if (min < 0 || max < 0) {
            throw new IllegalArgumentException("Amounts must not be negative!");
        }
        if (min > max) {
            throw new IllegalArgumentException("Min amount must not be greater than max amount!");
        }
    }

    public static LootData deserialize(JsonObject json) {
        float chance = GsonHelper.m_13915_((JsonObject)json, (String)"chance");
        Item item = ShapedRecipe.m_151278_((JsonObject)json.getAsJsonObject("output"));
        int min = GsonHelper.m_13927_((JsonObject)json, (String)"minAmount");
        int max = GsonHelper.m_13927_((JsonObject)json, (String)"maxAmount");
        Item cookedItem = Items.f_41852_;
        if (json.has("output_cooked")) {
            cookedItem = ShapedRecipe.m_151278_((JsonObject)json.getAsJsonObject("output_cooked"));
        }
        boolean isLighting = false;
        if (json.has("lightning")) {
            isLighting = GsonHelper.m_13912_((JsonObject)json, (String)"lightning");
        }
        boolean isArrow = false;
        if (json.has("needsArrow")) {
            isArrow = GsonHelper.m_13912_((JsonObject)json, (String)"needsArrow");
        }
        int color = -1;
        if (json.has("color")) {
            color = GsonHelper.m_13927_((JsonObject)json, (String)"color");
        }
        boolean randomDurability = false;
        if (json.has("randomDurability")) {
            randomDurability = GsonHelper.m_13912_((JsonObject)json, (String)"randomDurability");
        }
        return new LootData(new ItemStack((ItemLike)item), new ItemStack((ItemLike)cookedItem), chance, min, max, isLighting, isArrow, color, randomDurability);
    }

    public static void serializeBuffer(FriendlyByteBuf buffer, LootData lootData) {
        buffer.writeFloat(lootData.getChance());
        buffer.writeItemStack(lootData.getItem(), true);
        buffer.writeInt(lootData.getMinAmount());
        buffer.writeInt(lootData.getMaxAmount());
        buffer.writeBoolean(lootData.isLighting());
        buffer.writeBoolean(lootData.isArrow());
        buffer.writeItemStack(lootData.getCookedItem(), true);
        buffer.writeInt(lootData.getColor());
        buffer.writeBoolean(lootData.randomDurability);
    }

    public static LootData deserializeBuffer(FriendlyByteBuf buffer) {
        float chance = buffer.readFloat();
        ItemStack item = buffer.m_130267_();
        int min = buffer.readInt();
        int max = buffer.readInt();
        boolean isLightning = buffer.readBoolean();
        boolean isArrow = buffer.readBoolean();
        ItemStack cookedItem = buffer.m_130267_();
        int color = buffer.readInt();
        boolean randomDurability = buffer.readBoolean();
        return new LootData(item, cookedItem, chance, min, max, isLightning, isArrow, color, randomDurability);
    }

    public String toString() {
        return "Loot data - item: " + this.item.toString() + ", chance: " + this.chance + ", min: " + this.minAmount + ", max: " + this.maxAmount;
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public ItemStack getCookedItem() {
        return this.cookedItem;
    }

    public void setCookedItem(ItemStack item) {
        this.cookedItem = item;
    }

    public int getMinAmount() {
        return this.minAmount;
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public boolean isLighting() {
        return this.lighting;
    }

    public boolean isCooking() {
        return !this.cookedItem.m_41619_();
    }

    public boolean isArrow() {
        return this.arrow;
    }

    public boolean hasColor() {
        return this.getColor() != -1;
    }

    public int getColor() {
        return this.color;
    }

    public boolean ifRandomDurability() {
        return this.randomDurability;
    }
}

