/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.serializers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class SerializationHelper {
    public static void serializeStringCollection(FriendlyByteBuf buffer, Set<String> categories) {
        buffer.writeInt(categories.size());
        for (String s : categories) {
            buffer.m_130070_(s);
        }
    }

    public static void deserializeStringCollection(FriendlyByteBuf buffer, Set<String> categories) {
        int len = buffer.readInt();
        for (int i = 0; i < len; ++i) {
            categories.add(buffer.m_130277_());
        }
    }

    public static void serializeBlockState(FriendlyByteBuf buffer, BlockState renderState) {
        Block block = renderState.m_60734_();
        String locationString = ForgeRegistries.BLOCKS.getKey((Object)block).toString();
        buffer.m_130070_(locationString);
    }

    public static BlockState deserializeBlockState(FriendlyByteBuf buffer) {
        String locationString = buffer.m_130277_();
        ResourceLocation location = new ResourceLocation(locationString);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
        if (block != null) {
            return block.m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    public static BlockState deserializeBlockState(JsonElement json) {
        ResourceLocation location = new ResourceLocation(json.getAsString());
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
        if (block != null) {
            return block.m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    public static EntityType<?> deserializeEntityType(ResourceLocation id, FriendlyByteBuf buffer) {
        String entityTypeString = buffer.m_130277_();
        ResourceLocation res = new ResourceLocation(entityTypeString);
        if (EntityType.m_20632_((String)res.toString()).isPresent()) {
            return (EntityType)EntityType.m_20632_((String)res.toString()).get();
        }
        return null;
    }

    public static void serializeEntityType(FriendlyByteBuf buffer, EntityType<?> entityType) {
        String entityTypeString = EntityType.m_20613_(entityType).toString();
        buffer.m_130070_(entityTypeString);
    }

    public static CompoundTag serializeEntityTypeNBT(CompoundTag nbt, EntityType<?> entityType) {
        nbt.m_128359_("entity", EntityType.m_20613_(entityType).toString());
        return nbt;
    }

    public static EntityType<?> deserializeEntityTypeNBT(CompoundTag nbt) {
        String resString = nbt.m_128461_("entity");
        if (resString.isEmpty()) {
            return null;
        }
        String[] splitted = resString.split(":");
        ResourceLocation res = new ResourceLocation(splitted[0], splitted[1]);
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(res);
    }

    public static EntityType<?> deserializeEntityType(ResourceLocation id, JsonObject json) {
        String entityTypeString = json.getAsJsonPrimitive("entity").getAsString();
        Optional entityType = EntityType.m_20632_((String)entityTypeString);
        if (entityType.isPresent()) {
            return (EntityType)entityType.get();
        }
        throw new IllegalArgumentException("MobDataRecipe with id: " + id + " has an invalid entity key. No entity with given key exists.");
    }
}

