/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.blocks.mob_cage;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.blocks.mob_cage.MobCageBlock;
import com.corgam.cagedmobs.helpers.AdaptedItemHandler;
import com.corgam.cagedmobs.helpers.UpgradeItemsParticles;
import com.corgam.cagedmobs.items.upgrades.SpeedIIIUpgradeItem;
import com.corgam.cagedmobs.items.upgrades.SpeedIIUpgradeItem;
import com.corgam.cagedmobs.items.upgrades.SpeedIUpgradeItem;
import com.corgam.cagedmobs.registers.CagedBlockEntities;
import com.corgam.cagedmobs.registers.CagedItems;
import com.corgam.cagedmobs.registers.CagedRecipeTypes;
import com.corgam.cagedmobs.serializers.RecipesHelper;
import com.corgam.cagedmobs.serializers.SerializationHelper;
import com.corgam.cagedmobs.serializers.entity.AdditionalLootData;
import com.corgam.cagedmobs.serializers.entity.EntityData;
import com.corgam.cagedmobs.serializers.entity.LootData;
import com.corgam.cagedmobs.serializers.environment.EnvironmentData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class MobCageBlockEntity
extends BlockEntity {
    private EnvironmentData environmentData = null;
    private EntityData entity = null;
    private EntityType<?> entityType = null;
    private Entity cachedEntity;
    private SpawnData renderedEntity;
    private int currentGrowTicks = 0;
    private int totalGrowTicks = 0;
    private boolean waitingForHarvest = false;
    private int color = 0;
    public static final String ITEMS_TAG = "Inventory";
    public static int UPGRADES_COUNT = 3;
    public static int ENVIRONMENT_SLOT = 0;
    public static int SLOT_COUNT = UPGRADES_COUNT + 1;
    private final ItemStackHandler items = this.createItemHandler();
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> this.items);
    private final LazyOptional<IItemHandler> restrictedItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.items){

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }
    });

    public MobCageBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)CagedBlockEntities.MOB_CAGE_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    @Nonnull
    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(SLOT_COUNT){

            protected void onContentsChanged(int slot) {
                if (slot == ENVIRONMENT_SLOT) {
                    MobCageBlockEntity.this.updateEnvironment();
                } else {
                    MobCageBlockEntity.this.calculateTotalGrowTicks();
                }
                MobCageBlockEntity.this.m_6596_();
                if (MobCageBlockEntity.this.f_58857_ != null) {
                    MobCageBlockEntity.this.f_58857_.m_7260_(MobCageBlockEntity.this.f_58858_, MobCageBlockEntity.this.m_58900_(), MobCageBlockEntity.this.m_58900_(), 3);
                }
            }
        };
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
        this.restrictedItemHandler.invalidate();
    }

    public ItemStackHandler getInventoryHandler() {
        return this.items;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.itemHandler.cast();
            }
            return this.restrictedItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MobCageBlockEntity blockEntity) {
        if (blockEntity.hasEnvAndEntity() && !blockEntity.waitingForHarvest) {
            if (blockEntity.currentGrowTicks >= blockEntity.totalGrowTicks) {
                blockEntity.attemptHarvest(state);
            } else if (!blockEntity.entity.ifRequiresWater() || ((Boolean)blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                ++blockEntity.currentGrowTicks;
            }
        }
        if (level != null && level.m_5776_() && CagedMobs.CLIENT_CONFIG.shouldUpgradesParticles()) {
            for (ItemStack upgrade : blockEntity.getUpgradesAsItemStacks()) {
                blockEntity.emitUpgradeParticles(upgrade, blockEntity);
            }
        }
    }

    public void dropInventory() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            this.dropItem(this.items.getStackInSlot(i));
        }
    }

    private void dropItem(ItemStack item) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            double offsetX = (double)(this.f_58857_.f_46441_.m_188501_() * 0.7f) + (double)0.15f;
            double offsetY = (double)(this.f_58857_.f_46441_.m_188501_() * 0.7f) + 0.06000000238418579 + 0.6;
            double offsetZ = (double)(this.f_58857_.f_46441_.m_188501_() * 0.7f) + (double)0.15f;
            ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + offsetX, (double)this.f_58858_.m_123342_() + offsetY, (double)this.f_58858_.m_123343_() + offsetZ, item);
            itemEntity.m_32060_();
            this.f_58857_.m_7967_((Entity)itemEntity);
        }
    }

    public void setEnvironment(ItemStack heldItem) {
        this.environmentData = MobCageBlockEntity.getEnvironmentDataFromItemStack(heldItem);
        if (this.items.getStackInSlot(ENVIRONMENT_SLOT).m_41619_()) {
            ItemStack itemstack = heldItem.m_41777_();
            itemstack.m_41764_(1);
            this.items.insertItem(ENVIRONMENT_SLOT, itemstack, false);
        }
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public static EnvironmentData getEnvironmentDataFromItemStack(ItemStack heldItem) {
        EnvironmentData finalEnvData = null;
        for (Recipe<?> recipe : RecipesHelper.getRecipes((RecipeType)CagedRecipeTypes.ENVIRONMENT_RECIPE.get(), RecipesHelper.getRecipeManager()).values()) {
            EnvironmentData envData;
            if (!(recipe instanceof EnvironmentData) || !(envData = (EnvironmentData)recipe).getInputItem().test(heldItem)) continue;
            finalEnvData = envData;
            break;
        }
        return finalEnvData;
    }

    public void removeEnvironment() {
        this.environmentData = null;
        this.removeEntity();
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void updateEnvironment() {
        ItemStack envItem = this.items.getStackInSlot(ENVIRONMENT_SLOT);
        envItem.m_41764_(1);
        if (envItem.m_41619_()) {
            this.removeEnvironment();
        } else if (this.environmentData == null || !this.environmentData.getInputItem().m_43908_()[0].m_41720_().equals(envItem.m_41720_())) {
            this.setEnvironment(envItem);
        }
    }

    public EnvironmentData getEnvironmentData() {
        return this.environmentData;
    }

    public ItemStack getEnvironmentItemStack() {
        return this.items.getStackInSlot(ENVIRONMENT_SLOT);
    }

    public boolean hasEnvironment() {
        return !this.items.getStackInSlot(ENVIRONMENT_SLOT).m_41619_();
    }

    public static boolean existsEnvironmentFromItemStack(ItemStack heldItem) {
        if (heldItem.m_41619_()) {
            return false;
        }
        for (Recipe<?> recipe : RecipesHelper.getRecipes((RecipeType)CagedRecipeTypes.ENVIRONMENT_RECIPE.get(), RecipesHelper.getRecipeManager()).values()) {
            EnvironmentData envData;
            if (!(recipe instanceof EnvironmentData) || !(envData = (EnvironmentData)recipe).getInputItem().test(heldItem)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnvironmentSuitable(Player player, EntityType<?> entityType, BlockState state) {
        EntityData recipe = MobCageBlockEntity.getMobDataFromType(entityType);
        if (recipe.ifRequiresWater() && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            player.m_5661_((Component)Component.m_237115_((String)"block.cagedmobs.mob_cage.requiresWater").m_130940_(ChatFormatting.RED), true);
            return false;
        }
        if (this.environmentData != null) {
            for (String env : this.environmentData.getEnvironments()) {
                if (!recipe.getValidEnvs().contains(env)) continue;
                return true;
            }
        }
        player.m_5661_((Component)Component.m_237115_((String)"block.cagedmobs.mob_cage.envNotSuitable").m_130940_(ChatFormatting.RED), true);
        return false;
    }

    public void setEntityFromSampler(EntityType<?> entityType, ItemStack sampler) {
        EntityData entityData;
        if (entityType.toString().contains("sheep") && sampler.m_41782_() && sampler.m_41783_() != null && sampler.m_41783_().m_128441_("Color")) {
            this.color = sampler.m_41783_().m_128451_("Color");
        }
        this.entity = entityData = MobCageBlockEntity.getMobDataFromType(entityType);
        this.entityType = entityType;
        this.totalGrowTicks = this.calculateTotalGrowTicks();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        this.m_6596_();
    }

    public Optional<EntityData> getEntity() {
        return Optional.ofNullable(this.entity);
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public void removeEntity() {
        this.entity = null;
        this.entityType = null;
        this.cachedEntity = null;
        this.renderedEntity = null;
        this.currentGrowTicks = 0;
        this.totalGrowTicks = 0;
        this.waitingForHarvest = false;
        this.color = 0;
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        this.m_6596_();
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public boolean existsEntityDataFromType(EntityType<?> entityType) {
        for (Recipe<?> recipe : RecipesHelper.getRecipes((RecipeType)CagedRecipeTypes.ENTITY_RECIPE.get(), RecipesHelper.getRecipeManager()).values()) {
            EntityData entityData;
            if (!(recipe instanceof EntityData) || (entityData = (EntityData)recipe).getEntityType() == null || !entityData.getEntityType().equals(entityType)) continue;
            return true;
        }
        return false;
    }

    public Entity getCachedEntity(Level level) {
        if (this.cachedEntity == null) {
            if (this.renderedEntity == null) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128359_("id", EntityType.m_20613_(this.entityType).toString());
                this.renderedEntity = new SpawnData(nbt, Optional.empty());
            }
            this.cachedEntity = EntityType.m_20645_((CompoundTag)this.renderedEntity.m_186567_(), (Level)level, Function.identity());
        }
        return this.cachedEntity;
    }

    private static EntityData getMobDataFromType(EntityType<?> type) {
        EntityData finalEntityData = null;
        for (Recipe<?> recipe : RecipesHelper.getRecipes((RecipeType)CagedRecipeTypes.ENTITY_RECIPE.get(), RecipesHelper.getRecipeManager()).values()) {
            EntityData entityData;
            if (!(recipe instanceof EntityData) || (entityData = (EntityData)recipe).getEntityType() == null || !entityData.getEntityType().equals(type)) continue;
            finalEntityData = entityData;
            break;
        }
        if (finalEntityData != null) {
            MobCageBlockEntity.addAdditionalLootData(finalEntityData);
        }
        return finalEntityData;
    }

    private static void addAdditionalLootData(EntityData entityData) {
        for (Recipe<?> recipe : RecipesHelper.getRecipes((RecipeType)CagedRecipeTypes.ADDITIONAL_LOOT_RECIPE.get(), RecipesHelper.getRecipeManager()).values()) {
            if (!(recipe instanceof AdditionalLootData)) continue;
            AdditionalLootData additionalLootData = (AdditionalLootData)recipe;
            if (entityData.getEntityType() == null || !entityData.getEntityType().equals(additionalLootData.getEntityType())) continue;
            for (LootData data : additionalLootData.getResults()) {
                if (!additionalLootData.isRemoveFromEntity()) {
                    if (entityData.getResults().contains(data)) continue;
                    entityData.getResults().add(data);
                    continue;
                }
                entityData.getResults().removeIf(lootData -> lootData.getItem().m_41720_().equals(data.getItem().m_41720_()));
            }
        }
    }

    public void addUpgrade(ItemStack heldItem) {
        for (int slot = ENVIRONMENT_SLOT + 1; slot < this.items.getSlots(); ++slot) {
            if (!this.items.getStackInSlot(slot).m_41619_()) continue;
            ItemStack upgrade = heldItem.m_41777_();
            upgrade.m_41764_(1);
            if (!this.items.isItemValid(slot, upgrade)) continue;
            this.items.insertItem(slot, upgrade, false);
            return;
        }
    }

    public boolean acceptsUpgrades() {
        return this.items.getStackInSlot(ENVIRONMENT_SLOT + 1).m_41619_() || this.items.getStackInSlot(ENVIRONMENT_SLOT + 2).m_41619_() || this.items.getStackInSlot(ENVIRONMENT_SLOT + 3).m_41619_();
    }

    public boolean hasAnyUpgrades() {
        return !this.items.getStackInSlot(ENVIRONMENT_SLOT + 1).m_41619_() || !this.items.getStackInSlot(ENVIRONMENT_SLOT + 2).m_41619_() || !this.items.getStackInSlot(ENVIRONMENT_SLOT + 3).m_41619_();
    }

    public int getUpgradeCount(Item upgradeItem) {
        int currentCount = 0;
        for (int i = 0; i < this.items.getSlots(); ++i) {
            if (!this.items.getStackInSlot(i).m_41720_().equals(upgradeItem)) continue;
            ++currentCount;
        }
        return currentCount;
    }

    public boolean hasUpgrades(Item upgradeItem, int requiredCount) {
        int currentCount = 0;
        for (int i = 0; i < this.items.getSlots(); ++i) {
            if (!this.items.getStackInSlot(i).m_41720_().equals(upgradeItem)) continue;
            ++currentCount;
        }
        return currentCount >= requiredCount;
    }

    public List<ItemStack> getUpgradesAsItemStacks() {
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        for (int slot = ENVIRONMENT_SLOT + 1; slot <= UPGRADES_COUNT; ++slot) {
            upgrades.add(this.items.getStackInSlot(slot));
        }
        return upgrades;
    }

    private void emitUpgradeParticles(ItemStack upgrade, MobCageBlockEntity blockEntity) {
        if (upgrade.m_41720_().equals(CagedItems.COOKING_UPGRADE.get())) {
            UpgradeItemsParticles.emitCookingParticles(blockEntity);
        } else if (upgrade.m_41720_().equals(CagedItems.LIGHTNING_UPGRADE.get())) {
            UpgradeItemsParticles.emitLightningParticles(blockEntity);
        } else if (upgrade.m_41720_().equals(CagedItems.ARROW_UPGRADE.get())) {
            UpgradeItemsParticles.emitArrowParticles(blockEntity);
        } else if (upgrade.m_41720_().equals(CagedItems.EXPERIENCE_UPGRADE.get())) {
            UpgradeItemsParticles.emitExperienceParticles(blockEntity);
        } else if (upgrade.m_41720_().equals(CagedItems.LOOTING_UPGRADE.get())) {
            UpgradeItemsParticles.emitFortuneParticles(blockEntity);
        } else if (upgrade.m_41720_() instanceof SpeedIUpgradeItem || upgrade.m_41720_() instanceof SpeedIIUpgradeItem || upgrade.m_41720_() instanceof SpeedIIIUpgradeItem) {
            UpgradeItemsParticles.emitSpeedParticles(blockEntity);
        } else if (upgrade.m_41720_().equals(CagedItems.CREATIVE_UPGRADE.get())) {
            UpgradeItemsParticles.emitCreativeParticles(blockEntity);
        }
    }

    public boolean isWaitingForHarvest() {
        return this.waitingForHarvest;
    }

    public void onPlayerHarvest(BlockState state) {
        if ((!((Boolean)state.m_61143_((Property)MobCageBlock.HOPPING)).booleanValue() || CagedMobs.SERVER_CONFIG.ifHoppingCagesDisabled()) && this.canPlayerHarvest()) {
            this.currentGrowTicks = 0;
            this.waitingForHarvest = false;
            NonNullList<ItemStack> drops = this.createDropsList();
            for (ItemStack item : drops) {
                this.dropItem(item.m_41777_());
            }
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
            this.m_6596_();
        }
    }

    private void attemptHarvest(BlockState state) {
        if (((Boolean)state.m_61143_((Property)MobCageBlock.HOPPING)).booleanValue() && !CagedMobs.SERVER_CONFIG.ifHoppingCagesDisabled()) {
            this.currentGrowTicks = this.autoHarvest() ? 0 : this.totalGrowTicks;
        } else {
            this.waitingForHarvest = true;
            this.currentGrowTicks = this.totalGrowTicks;
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        this.m_6596_();
    }

    private boolean autoHarvest() {
        IItemHandler inventory = this.getInv(this.f_58857_, this.f_58858_.m_7495_(), Direction.UP);
        if (inventory != EmptyHandler.INSTANCE && !this.f_58857_.m_5776_()) {
            NonNullList<ItemStack> drops = this.createDropsList();
            block0: for (ItemStack item : drops) {
                for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                    if (!inventory.isItemValid(slot, item) || inventory.insertItem(slot, item, true).m_41613_() == item.m_41613_()) continue;
                    inventory.insertItem(slot, item, false);
                    continue block0;
                }
            }
            return true;
        }
        return false;
    }

    private IItemHandler getInv(Level world, BlockPos pos, Direction side) {
        BlockEntity te = world.m_7702_(pos);
        if (te != null) {
            LazyOptional invCap = te.getCapability(ForgeCapabilities.ITEM_HANDLER, side);
            return (IItemHandler)invCap.orElse((Object)EmptyHandler.INSTANCE);
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder invProvider = (WorldlyContainerHolder)state.m_60734_();
            WorldlyContainer inv = invProvider.m_5840_(state, (LevelAccessor)world, pos);
            return new SidedInvWrapper(inv, side);
        }
        return EmptyHandler.INSTANCE;
    }

    private NonNullList<ItemStack> createDropsList() {
        NonNullList drops = NonNullList.m_122779_();
        List<Item> blacklistedItems = RecipesHelper.getItemsFromConfigList();
        for (LootData loot : this.entity.getResults()) {
            int range;
            int amount;
            if (CagedMobs.SERVER_CONFIG.isEntitiesListInWhitelistMode() ? !blacklistedItems.contains(loot.getItem().m_41720_()) : blacklistedItems.contains(loot.getItem().m_41720_())) continue;
            if (loot.getColor() != -1 && loot.getColor() != this.color || !this.hasUpgrades((Item)CagedItems.LIGHTNING_UPGRADE.get(), 1) && loot.isLighting() || !this.hasUpgrades((Item)CagedItems.ARROW_UPGRADE.get(), 1) && loot.isArrow() || this.f_58857_ == null || this.f_58857_.m_5776_() || !(this.f_58857_.f_46441_.m_188501_() <= loot.getChance()) || (amount = this.f_58857_.f_46441_.m_188503_(range = loot.getMaxAmount() - loot.getMinAmount() + 1) + loot.getMinAmount()) <= 0) continue;
            ItemStack stack = loot.getItem().m_41777_();
            if (this.hasUpgrades((Item)CagedItems.COOKING_UPGRADE.get(), 3) && loot.isCooking()) {
                stack = new ItemStack((ItemLike)Items.f_42413_);
            } else if (this.hasUpgrades((Item)CagedItems.COOKING_UPGRADE.get(), 1) && loot.isCooking()) {
                stack = loot.getCookedItem().m_41777_();
            }
            stack.m_41764_(amount);
            if (loot.ifRandomDurability()) {
                stack = this.applyRandomDurability(stack);
            }
            drops.add((Object)stack);
            if (!this.hasUpgrades((Item)CagedItems.LOOTING_UPGRADE.get(), 1)) continue;
            this.calculateFortune(loot, (NonNullList<ItemStack>)drops, stack);
        }
        if (this.hasUpgrades((Item)CagedItems.EXPERIENCE_UPGRADE.get(), 1) && this.f_58857_ != null && !this.f_58857_.m_5776_() && (double)this.f_58857_.f_46441_.m_188501_() <= 0.7) {
            ItemStack experienceOrbItem = new ItemStack((ItemLike)CagedItems.CRYSTALLIZED_EXPERIENCE.get());
            experienceOrbItem.m_41764_(this.getUpgradeCount((Item)CagedItems.EXPERIENCE_UPGRADE.get()));
            drops.add((Object)experienceOrbItem);
            if (this.hasUpgrades((Item)CagedItems.LOOTING_UPGRADE.get(), 1)) {
                this.calculateFortune(null, (NonNullList<ItemStack>)drops, experienceOrbItem);
            }
        }
        return drops;
    }

    private void calculateFortune(@Nullable LootData lootData, NonNullList<ItemStack> dropList, ItemStack item) {
        double fortuneChance = (double)this.getUpgradeCount((Item)CagedItems.LOOTING_UPGRADE.get()) * 0.2;
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && (double)this.f_58857_.f_46441_.m_188501_() < fortuneChance) {
            int countMultiplayer = this.f_58857_.f_46441_.m_188503_(2) + 2;
            for (int i = 0; i < countMultiplayer - 1; ++i) {
                if (lootData != null && lootData.ifRandomDurability()) {
                    item = this.applyRandomDurability(item.m_41777_());
                }
                dropList.add((Object)item);
            }
        }
    }

    public ItemStack applyRandomDurability(ItemStack stack) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && stack.m_41776_() > 0) {
            int randomDurability = Math.max(1, this.f_58857_.f_46441_.m_188503_(stack.m_41776_()));
            stack.m_41721_(randomDurability);
        }
        return stack;
    }

    private boolean canPlayerHarvest() {
        return this.hasEnvAndEntity() && this.totalGrowTicks > 0 && this.currentGrowTicks >= this.totalGrowTicks;
    }

    private boolean hasEnvAndEntity() {
        return this.hasEntity() && this.hasEnvironment();
    }

    public float getGrowthPercentage() {
        if (this.totalGrowTicks != 0) {
            if (this.currentGrowTicks >= this.totalGrowTicks) {
                return 1.0f;
            }
            return (float)this.currentGrowTicks / (float)this.totalGrowTicks;
        }
        return 0.0f;
    }

    private int calculateTotalGrowTicks() {
        if (this.environmentData != null && this.getEntity().isPresent()) {
            int i;
            if (this.hasUpgrades((Item)CagedItems.CREATIVE_UPGRADE.get(), 1)) {
                this.totalGrowTicks = 1;
                if (this.currentGrowTicks > this.totalGrowTicks) {
                    this.currentGrowTicks = this.totalGrowTicks;
                }
                return this.totalGrowTicks;
            }
            float growModifier = this.environmentData.getGrowModifier();
            for (i = 0; i < this.getUpgradeCount((Item)CagedItems.SPEED_I_UPGRADE.get()); ++i) {
                growModifier *= 1.5f;
            }
            for (i = 0; i < this.getUpgradeCount((Item)CagedItems.SPEED_II_UPGRADE.get()); ++i) {
                growModifier *= 2.0f;
            }
            for (i = 0; i < this.getUpgradeCount((Item)CagedItems.SPEED_III_UPGRADE.get()); ++i) {
                growModifier *= 3.0f;
            }
            int basicTotalGrowTicks = Math.round((float)this.getEntity().get().getTotalGrowTicks() / growModifier);
            this.totalGrowTicks = (int)Math.round((double)basicTotalGrowTicks / CagedMobs.SERVER_CONFIG.getSpeedOfCages());
            if (this.currentGrowTicks >= this.totalGrowTicks) {
                this.currentGrowTicks = this.totalGrowTicks;
            } else {
                this.waitingForHarvest = false;
            }
            return this.totalGrowTicks;
        }
        return 0;
    }

    public int getColor() {
        return this.color;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        this.saveTag(tag);
    }

    private void saveTag(@NotNull CompoundTag tag) {
        tag.m_128365_(ITEMS_TAG, (Tag)this.items.serializeNBT());
        if (this.hasEntity()) {
            SerializationHelper.serializeEntityTypeNBT(tag, this.entityType);
        }
        tag.m_128405_("color", this.color);
        tag.m_128405_("currentGrowTicks", this.currentGrowTicks);
        tag.m_128379_("waitingForHarvest", this.waitingForHarvest);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.loadTag(tag);
    }

    private void loadTag(@NotNull CompoundTag tag) {
        ItemStack oldEnv = this.items.getStackInSlot(ENVIRONMENT_SLOT);
        EntityType<?> oldEntityType = this.entityType;
        if (tag.m_128441_(ITEMS_TAG)) {
            this.items.deserializeNBT(tag.m_128469_(ITEMS_TAG));
        }
        this.environmentData = MobCageBlockEntity.getEnvironmentDataFromItemStack(this.items.getStackInSlot(ENVIRONMENT_SLOT));
        this.entityType = SerializationHelper.deserializeEntityTypeNBT(tag);
        this.entity = MobCageBlockEntity.getMobDataFromType(this.entityType);
        if (this.entityType == null) {
            this.renderedEntity = null;
            this.cachedEntity = null;
        }
        this.color = tag.m_128451_("color");
        this.waitingForHarvest = tag.m_128471_("waitingForHarvest");
        this.currentGrowTicks = tag.m_128451_("currentGrowTicks");
        if (this.hasEntity()) {
            this.totalGrowTicks = this.calculateTotalGrowTicks();
        }
        if (!Objects.equals(oldEnv, this.items.getStackInSlot(ENVIRONMENT_SLOT)) || !Objects.equals(oldEntityType, this.entityType)) {
            this.requestModelDataUpdate();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.saveTag(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag != null) {
            this.loadTag(tag);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.handleUpdateTag(tag);
        }
    }
}

