/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.addons.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.corgam.cagedmobs.serializers.environment.EnvironmentData;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.cagedmobs.Environment")
public class CTEnvironment {
    private final EnvironmentData environmentData;

    public CTEnvironment(String id, IIngredient item, BlockState renderState, float growModifier, String[] categories) {
        this(new EnvironmentData(ResourceLocation.m_135820_((String)id), item.asVanillaIngredient(), renderState, growModifier, new HashSet<String>(Arrays.asList(categories))));
    }

    public CTEnvironment(EnvironmentData envData) {
        this.environmentData = envData;
    }

    @ZenCodeType.Method
    public CTEnvironment addCategory(String category) {
        this.environmentData.getEnvironments().add(category);
        return this;
    }

    @ZenCodeType.Method
    public CTEnvironment removeCategory(String category) {
        this.environmentData.getEnvironments().remove(category);
        return this;
    }

    @ZenCodeType.Method
    public CTEnvironment clearCategories() {
        this.environmentData.getEnvironments().clear();
        return this;
    }

    @ZenCodeType.Method
    public CTEnvironment setInputItem(IIngredient inputIngredient) {
        this.environmentData.setInputItem(inputIngredient.asVanillaIngredient());
        return this;
    }

    @ZenCodeType.Method
    public CTEnvironment setDisplay(BlockState displayBlockState) {
        this.environmentData.setRenderState(displayBlockState);
        return this;
    }

    @ZenCodeType.Method
    public CTEnvironment setGrowthModifier(float growthModifier) {
        this.environmentData.setGrowthModifier(growthModifier);
        return this;
    }

    public EnvironmentData getEnvironmentData() {
        return this.environmentData;
    }
}

