/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.addons.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.corgam.cagedmobs.serializers.entity.EntityData;
import com.corgam.cagedmobs.serializers.entity.LootData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.cagedmobs.Entity")
public class CTEntity {
    private final EntityData entityData;

    public CTEntity(String id, EntityType<?> entityType, int growTicks, boolean requiresWater, int tier, String[] environments) {
        this(new EntityData(ResourceLocation.m_135820_((String)id), entityType, new HashSet<String>(Arrays.asList(environments)), growTicks, requiresWater, new ArrayList<LootData>(), tier));
    }

    public CTEntity(EntityData entityData) {
        this.entityData = entityData;
    }

    @ZenCodeType.Method
    public CTEntity addEnvironment(String env) {
        this.entityData.getValidEnvs().add(env);
        return this;
    }

    @ZenCodeType.Method
    public CTEntity removeEnvironment(String env) {
        this.entityData.getValidEnvs().remove(env);
        return this;
    }

    @ZenCodeType.Method
    public CTEntity clearEnvironments() {
        this.entityData.getValidEnvs().clear();
        return this;
    }

    @ZenCodeType.Method
    public CTEntity addLoot(IItemStack item, float chance) {
        return this.addLoot(item, chance, 1, 1);
    }

    @ZenCodeType.Method
    public CTEntity addLoot(IItemStack item, float chance, int min, int max) {
        return this.addLoot(item, null, chance, min, max, false, false, -1, false);
    }

    @ZenCodeType.Method
    public CTEntity addLoot(IItemStack item, IItemStack cookedItem, float chance, int min, int max) {
        return this.addLoot(item, cookedItem, chance, min, max, false, false, -1, false);
    }

    @ZenCodeType.Method
    public CTEntity addLoot(IItemStack item, float chance, int min, int max, boolean lightning, boolean arrow) {
        return this.addLoot(item, null, chance, min, max, lightning, arrow, -1, false);
    }

    @ZenCodeType.Method
    public CTEntity addLoot(IItemStack item, IItemStack cookedItem, float chance, int min, int max, boolean lighting, boolean arrow, int color, boolean randomDurability) {
        for (LootData loot : this.entityData.getResults()) {
            if (!loot.getItem().equals(item.getInternal(), false)) continue;
            return this;
        }
        if (cookedItem == null || cookedItem.getInternal().m_41720_().equals(Items.f_41852_)) {
            this.entityData.getResults().add(new LootData(item.getInternal(), ItemStack.f_41583_, chance, min, max, lighting, arrow, color, randomDurability));
        } else {
            this.entityData.getResults().add(new LootData(item.getInternal(), cookedItem.getInternal(), chance, min, max, lighting, arrow, color, randomDurability));
        }
        return this;
    }

    @ZenCodeType.Method
    public CTEntity clearLoot() {
        this.entityData.getResults().clear();
        return this;
    }

    @ZenCodeType.Method
    public CTEntity removeLoot(IIngredient remove) {
        Ingredient ing = remove.asVanillaIngredient();
        this.entityData.getResults().removeIf(drop -> ing.test(drop.getItem()));
        return this;
    }

    @ZenCodeType.Method
    public CTEntity setGrowthTicks(int ticks) {
        this.entityData.setTotalGrowTicks(ticks);
        return this;
    }

    @ZenCodeType.Method
    public CTEntity setEntityType(String entityId) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)entityId));
        this.entityData.setEntityType(entityType);
        return this;
    }

    @ZenCodeType.Method
    public CTEntity setTier(int tier) {
        this.entityData.setSamplerTier(tier);
        return this;
    }

    @ZenCodeType.Method
    public CTEntity setIfRequiresWater(boolean requiresWater) {
        this.entityData.setIfRequiresWater(requiresWater);
        return this;
    }

    public EntityData getEntityData() {
        return this.entityData;
    }
}

