/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.addons.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.corgam.cagedmobs.serializers.entity.AdditionalLootData;
import com.corgam.cagedmobs.serializers.entity.LootData;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.cagedmobs.AdditionalLoot")
public class CTAdditionalLoot {
    private final AdditionalLootData additionalLootData;

    public CTAdditionalLoot(String id, EntityType<?> entityType, Boolean removeFromEntity) {
        this(new AdditionalLootData(ResourceLocation.m_135820_((String)id), entityType, new ArrayList<LootData>(), removeFromEntity));
    }

    public CTAdditionalLoot(AdditionalLootData lootData) {
        this.additionalLootData = lootData;
    }

    @ZenCodeType.Method
    public CTAdditionalLoot addLoot(IItemStack item, float chance) {
        return this.addLoot(item, chance, 1, 1);
    }

    @ZenCodeType.Method
    public CTAdditionalLoot addLoot(IItemStack item, float chance, int min, int max) {
        return this.addLoot(item, null, chance, min, max, false, false, -1, false);
    }

    @ZenCodeType.Method
    public CTAdditionalLoot addLoot(IItemStack item, IItemStack cookedItem, float chance, int min, int max) {
        return this.addLoot(item, cookedItem, chance, min, max, false, false, -1, false);
    }

    @ZenCodeType.Method
    public CTAdditionalLoot addLoot(IItemStack item, float chance, int min, int max, boolean lightning, boolean arrow) {
        return this.addLoot(item, null, chance, min, max, lightning, arrow, -1, false);
    }

    @ZenCodeType.Method
    public CTAdditionalLoot addLoot(IItemStack item, IItemStack cookedItem, float chance, int min, int max, boolean lighting, boolean arrow, int color, boolean randomDurability) {
        for (LootData loot : this.additionalLootData.getResults()) {
            if (!loot.getItem().equals(item.getInternal(), false)) continue;
            return this;
        }
        if (cookedItem == null || cookedItem.getInternal().m_41720_().equals(Items.f_41852_)) {
            this.additionalLootData.getResults().add(new LootData(item.getInternal(), ItemStack.f_41583_, chance, min, max, lighting, arrow, color, randomDurability));
        } else {
            this.additionalLootData.getResults().add(new LootData(item.getInternal(), cookedItem.getInternal(), chance, min, max, lighting, arrow, color, randomDurability));
        }
        return this;
    }

    @ZenCodeType.Method
    public CTAdditionalLoot clearLoot() {
        this.additionalLootData.getResults().clear();
        return this;
    }

    @ZenCodeType.Method
    public CTAdditionalLoot removeLoot(IIngredient remove) {
        Ingredient ing = remove.asVanillaIngredient();
        this.additionalLootData.getResults().removeIf(drop -> ing.test(drop.getItem()));
        return this;
    }

    @ZenCodeType.Method
    public CTAdditionalLoot setEntityType(String entityId) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)entityId));
        this.additionalLootData.setEntityType(entityType);
        return this;
    }

    @ZenCodeType.Method
    public CTAdditionalLoot setRemoveFromEntity(boolean removeFromEntity) {
        this.additionalLootData.setRemoveFromEntity(removeFromEntity);
        return this;
    }

    public AdditionalLootData getAdditionalLootData() {
        return this.additionalLootData;
    }
}

