/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs;

import com.corgam.cagedmobs.ClientSetup;
import com.corgam.cagedmobs.addons.theoneprobe.CagedMobsTOPSupport;
import com.corgam.cagedmobs.configs.ClientConfig;
import com.corgam.cagedmobs.configs.ServerConfig;
import com.corgam.cagedmobs.items.DnaSamplerDiamondItem;
import com.corgam.cagedmobs.items.DnaSamplerItem;
import com.corgam.cagedmobs.items.DnaSamplerNetheriteItem;
import com.corgam.cagedmobs.registers.CagedBlockEntities;
import com.corgam.cagedmobs.registers.CagedBlocks;
import com.corgam.cagedmobs.registers.CagedContainers;
import com.corgam.cagedmobs.registers.CagedCreativeTabs;
import com.corgam.cagedmobs.registers.CagedItems;
import com.corgam.cagedmobs.registers.CagedRecipeSerializers;
import com.corgam.cagedmobs.registers.CagedRecipeTypes;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cagedmobs")
public class CagedMobs {
    public static final String MOD_ID = "cagedmobs";
    public static final Logger LOGGER = LogManager.getLogger();
    final IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
    public static final ClientConfig CLIENT_CONFIG = new ClientConfig();
    public static final ServerConfig SERVER_CONFIG = new ServerConfig();

    public CagedMobs() {
        this.eventBus.addListener(ClientSetup::renderLayerSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_CONFIG.getForgeConfigSpec());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG.getForgeConfigSpec());
        CagedBlocks.CAGED_BLOCKS_REGISTER.register(this.eventBus);
        CagedItems.CAGED_ITEMS_REGISTER.register(this.eventBus);
        CagedBlockEntities.CAGED_BLOCK_ENTITIES_REGISTER.register(this.eventBus);
        CagedCreativeTabs.CAGED_CREATIVE_TABS_REGISTER.register(this.eventBus);
        CagedRecipeTypes.CAGED_RECIPE_TYPES_REGISTER.register(this.eventBus);
        CagedRecipeSerializers.CAGED_RECIPE_SERIALIZERS_REGISTER.register(this.eventBus);
        CagedContainers.CAGED_MENU_TYPES_REGISTER.register(this.eventBus);
        this.eventBus.addListener(this::addPropertiesToItems);
        this.eventBus.addListener(this::initTOPSupport);
    }

    private void addPropertiesToItems(FMLClientSetupEvent event) {
        ItemProperties.register((Item)((Item)CagedItems.DNA_SAMPLER.get()), (ResourceLocation)new ResourceLocation("cagedmobs:full"), (itemStack, clientWorld, livingEntity, unusedInt) -> DnaSamplerItem.containsEntityType(itemStack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)CagedItems.DIAMOND_DNA_SAMPLER.get()), (ResourceLocation)new ResourceLocation("cagedmobs:full"), (itemStack, clientWorld, livingEntity, unusedInt) -> DnaSamplerDiamondItem.containsEntityType(itemStack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)CagedItems.NETHERITE_DNA_SAMPLER.get()), (ResourceLocation)new ResourceLocation("cagedmobs:full"), (itemStack, clientWorld, livingEntity, unusedInt) -> DnaSamplerNetheriteItem.containsEntityType(itemStack) ? 1.0f : 0.0f);
    }

    private void initTOPSupport(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", CagedMobsTOPSupport::new);
        }
    }
}

