/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.compat.kubejs;

import com.jesz.createdieselgenerators.compat.kubejs.FuelTypeBuilder;
import com.jesz.createdieselgenerators.fuel_type.FuelType;
import com.jesz.createdieselgenerators.fuel_type.FuelTypeManager;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class FuelTypesEventJS
extends EventJS {
    protected Object defaultExitValue() {
        return -1;
    }

    @Info(value="Adds a fuel type")
    public FuelTypeBuilder add(String fluidId) {
        return new FuelTypeBuilder(t -> {
            if (fluidId.startsWith("#")) {
                FuelTypeManager.fuelTags.put(fluidId.substring(1), (FuelType)t);
                FuelTypeManager.tryPopulateTags();
            } else {
                Optional fluid = ForgeRegistries.FLUIDS.getDelegate(new ResourceLocation(fluidId));
                if (fluid.isEmpty()) {
                    return;
                }
                FuelTypeManager.fuelTypes.put((Fluid)((Holder.Reference)fluid.get()).get(), (FuelType)t);
            }
        });
    }

    @Info(value="Removes a fuel type")
    public void remove(String fluidId) {
        if (fluidId.startsWith("#")) {
            FuelTypeManager.fuelTags.remove(fluidId.substring(1));
        } else {
            Optional fluid = ForgeRegistries.FLUIDS.getDelegate(new ResourceLocation(fluidId));
            if (fluid.isEmpty()) {
                return;
            }
            FuelTypeManager.fuelTypes.remove(((Holder.Reference)fluid.get()).get());
        }
    }
}

