/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.mixin.frosted_caves;

import com.yungnickyoung.minecraft.yungscavebiomes.block.IceSheetBlock;
import com.yungnickyoung.minecraft.yungscavebiomes.mixin.accessor.ArrowAccessor;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.MobEffectModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends Entity {
    private AbstractArrowMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"onHitBlock"}, at={@At(value="RETURN")})
    public void yungscavebiomes_tippedArrowOnHitBlockSpawnIceSheets(BlockHitResult blockHitResult, CallbackInfo ci) {
        if (!this.m_9236_().f_46443_ && AbstractArrowMixin.isArrow((Object)this)) {
            Arrow arrow = AbstractArrowMixin.asArrow((Object)this);
            for (MobEffectInstance mobEffectInstance : ((ArrowAccessor)arrow).getPotion().m_43488_()) {
                if (mobEffectInstance.m_19544_() != MobEffectModule.FROZEN_EFFECT.get()) continue;
                BlockPos originPos = blockHitResult.m_82425_();
                boolean amplified = mobEffectInstance.m_19564_() > 0;
                AbstractArrowMixin.placeIceSheets(this.m_9236_(), originPos, amplified);
            }
        }
    }

    @Inject(method={"onHitEntity"}, at={@At(value="RETURN")})
    public void yungscavebiomes_tippedArrowOnHitEntitySpawnIceSheets(EntityHitResult entityHitResult, CallbackInfo ci) {
        if (!this.m_9236_().f_46443_ && AbstractArrowMixin.isArrow((Object)this)) {
            Arrow arrow = AbstractArrowMixin.asArrow((Object)this);
            for (MobEffectInstance mobEffectInstance : ((ArrowAccessor)arrow).getPotion().m_43488_()) {
                if (mobEffectInstance.m_19544_() != MobEffectModule.FROZEN_EFFECT.get()) continue;
                BlockPos originPos = entityHitResult.m_82443_().m_20097_();
                boolean amplified = mobEffectInstance.m_19564_() > 0;
                AbstractArrowMixin.placeIceSheets(this.m_9236_(), originPos, amplified);
            }
        }
    }

    @Unique
    private static void placeIceSheets(Level level, BlockPos originPos, boolean amplified) {
        BlockPos.MutableBlockPos currPos = originPos.m_122032_();
        BlockPos.MutableBlockPos mutable = currPos.m_122032_();
        int attemptDistance = amplified ? 4 : 3;
        int maxDist = amplified ? 14 : 8;
        for (int x = -attemptDistance; x <= attemptDistance; ++x) {
            for (int y = -attemptDistance; y <= attemptDistance; ++y) {
                for (int z = -attemptDistance; z <= attemptDistance; ++z) {
                    if (x * x + y * y + z * z > maxDist) continue;
                    currPos.m_122154_((Vec3i)originPos, x, y, z);
                    BlockState currState = level.m_8055_((BlockPos)currPos);
                    if (!currState.m_60795_() && !currState.m_60713_(Blocks.f_49990_) && !currState.m_204336_(BlockTags.f_278394_)) continue;
                    for (Direction direction : Direction.values()) {
                        mutable.m_122159_((Vec3i)currPos, direction);
                        IceSheetBlock iceSheetBlock = (IceSheetBlock)((Object)BlockModule.ICE_SHEET.get());
                        BlockState updatedBlockState = iceSheetBlock.m_153940_(currState, (BlockGetter)level, (BlockPos)currPos, direction);
                        if (updatedBlockState == null) continue;
                        currState = updatedBlockState = (BlockState)updatedBlockState.m_61124_((Property)IceSheetBlock.GROWTH_DISTANCE, (Comparable)Integer.valueOf(0));
                        level.m_7731_((BlockPos)currPos, updatedBlockState, 3);
                    }
                }
            }
        }
    }

    @Unique
    private static boolean isArrow(Object object) {
        return object instanceof Arrow;
    }

    @Unique
    private static Arrow asArrow(Object object) {
        return (Arrow)object;
    }
}

