/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.block;

import mrtjp.projectred.core.tile.IBlockEventBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectRedBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty SIDE = IntegerProperty.m_61631_((String)"side", (int)0, (int)5);
    public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)3);
    public static final BooleanProperty CHARGED = BooleanProperty.m_61465_((String)"charged");
    public static final BooleanProperty WORKING = BooleanProperty.m_61465_((String)"working");
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BlockBehaviour.Properties WOODEN_MACHINE_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f).m_60918_(SoundType.f_56736_);
    public static final BlockBehaviour.Properties STONE_MACHINE_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60978_(3.5f).m_60918_(SoundType.f_56742_);

    public ProjectRedBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected abstract BlockEntityType<?> getBlockEntityType();

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (type != this.getBlockEntityType()) {
            return null;
        }
        return (level1, pos, state1, tile) -> {
            if (tile instanceof IBlockEventBlockEntity) {
                IBlockEventBlockEntity t = (IBlockEventBlockEntity)tile;
                t.tick();
            }
        };
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos neighbor, boolean isMoving) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IBlockEventBlockEntity) {
            ((IBlockEventBlockEntity)tile).onNeighborBlockChanged(neighbor);
        }
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IBlockEventBlockEntity) {
            ((IBlockEventBlockEntity)tile).onNeighborTileChanged(neighbor);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IBlockEventBlockEntity) {
            return ((IBlockEventBlockEntity)tile).onBlockActivated(player, hand, hit);
        }
        return InteractionResult.FAIL;
    }

    public void m_6810_(BlockState oldState, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IBlockEventBlockEntity) {
            if (oldState.m_60713_(newState.m_60734_())) {
                ((IBlockEventBlockEntity)tile).onBlockStateReplaced(newState);
            } else {
                ((IBlockEventBlockEntity)tile).onBlockRemoved();
            }
        }
        super.m_6810_(oldState, world, pos, newState, isMoving);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity player, ItemStack stack) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IBlockEventBlockEntity) {
            ((IBlockEventBlockEntity)tile).onBlockPlaced(player, stack);
        }
    }
}

