/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.part;

import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.TickablePart;
import mrtjp.projectred.core.CenterLookup;
import mrtjp.projectred.expansion.GraphDebugManager;
import mrtjp.projectred.expansion.TubeType;
import mrtjp.projectred.expansion.graphs.GraphContainer;
import mrtjp.projectred.expansion.graphs.GraphNode;
import mrtjp.projectred.expansion.part.RedstoneTubePart;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public abstract class GraphContainerTubePart
extends RedstoneTubePart
implements TickablePart,
GraphContainer {
    protected final GraphNode node = new GraphNode(this);

    public GraphContainerTubePart(TubeType pipeType) {
        super(pipeType);
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.level().f_46443_) {
            this.node.onAdded();
        }
    }

    @Override
    public void onRemoved() {
        int sideMask;
        if (!this.level().f_46443_ && Integer.bitCount(sideMask = this.node.onRemoved()) > 1) {
            this.onRemovalSeveredLink();
        }
        super.onRemoved();
    }

    public void onChunkLoad(LevelChunk chunk) {
        super.onChunkLoad(chunk);
        if (!this.level().f_46443_) {
            this.node.markLinksChanged();
        }
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        if (this.level().m_5776_()) {
            GraphDebugManager.getInstance(this.level()).onWorldJoin(this);
        }
    }

    public void onWorldSeparate() {
        super.onWorldSeparate();
        if (this.level().m_5776_()) {
            GraphDebugManager.getInstance(this.level()).onWorldSeparate(this);
        }
    }

    @Override
    public void maskChangeEvent(boolean internalChange, boolean externalChange) {
        super.maskChangeEvent(internalChange, externalChange);
        if (internalChange || externalChange) {
            this.node.markLinksChanged();
        }
    }

    public void tick() {
        if (!this.level().m_5776_()) {
            this.node.onTick();
        }
    }

    protected void onRemovalSeveredLink() {
    }

    @Override
    public GraphNode getNode() {
        return this.node;
    }

    @Override
    public void onNodeChanged(boolean linksChanged, boolean stateChange) {
    }

    @Override
    public boolean canPropagate(int dir) {
        return this.maskConnects(dir);
    }

    @Override
    @Nullable
    public GraphContainer getNodeTowards(int dir) {
        if (!this.maskConnects(dir)) {
            return null;
        }
        CenterLookup lookup = CenterLookup.lookupStraightCenter((Level)this.level(), (BlockPos)this.pos(), (int)dir);
        MultiPart multiPart = lookup.part;
        if (multiPart instanceof GraphContainer) {
            GraphContainer c = (GraphContainer)multiPart;
            return c;
        }
        multiPart = lookup.tile;
        if (multiPart instanceof GraphContainer) {
            GraphContainer c = (GraphContainer)multiPart;
            return c;
        }
        return null;
    }
}

