/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.network.packets;

import forestry.api.modules.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import forestry.worktable.recipes.RecipeMemory;
import forestry.worktable.tiles.WorktableTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;

public record PacketWorktableMemoryUpdate(BlockPos pos, RecipeMemory memory) implements IForestryPacketClient
{
    public PacketWorktableMemoryUpdate(WorktableTile worktable) {
        this(worktable.m_58899_(), worktable.getMemory());
    }

    @Override
    public ResourceLocation id() {
        return PacketIdClient.WORKTABLE_MEMORY_UPDATE;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        this.memory.writeData(buffer);
    }

    public static PacketWorktableMemoryUpdate decode(FriendlyByteBuf buffer) {
        return new PacketWorktableMemoryUpdate(buffer.m_130135_(), new RecipeMemory(buffer));
    }

    public static void handle(PacketWorktableMemoryUpdate msg, Player player) {
        WorktableTile tile = TileUtil.getTile((BlockGetter)player.m_9236_(), msg.pos, WorktableTile.class);
        if (tile != null) {
            tile.getMemory().copy(msg.memory);
        }
    }
}

