/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.gui.widgets;

import forestry.api.ForestryConstants;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.gui.widgets.WidgetScrollBar;
import forestry.sorting.gui.GuiGeneticFilter;
import forestry.sorting.gui.ISelectableProvider;
import forestry.sorting.gui.widgets.SelectionLogic;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SelectionWidget
extends Widget {
    public static final ResourceLocation TEXTURE = ForestryConstants.forestry("textures/gui/filter_selection.png");
    final WidgetScrollBar scrollBar;
    @Nullable
    private SelectionLogic<?> logic;
    final GuiGeneticFilter gui;

    public SelectionWidget(WidgetManager manager, int xPos, int yPos, WidgetScrollBar scrollBar, GuiGeneticFilter gui) {
        super(manager, xPos, yPos);
        this.width = 212;
        this.height = 88;
        this.scrollBar = scrollBar;
        this.gui = gui;
    }

    public <S> void setProvider(@Nullable ISelectableProvider<S> provider) {
        this.logic = provider == null ? null : new SelectionLogic<S>(this, provider);
    }

    public boolean isSame(ISelectableProvider<?> provider) {
        return this.logic != null && this.logic.isSame(provider);
    }

    @Nullable
    public SelectionLogic<?> getLogic() {
        return this.logic;
    }

    @Override
    public void draw(GuiGraphics graphics, int startX, int startY) {
        if (this.logic == null) {
            return;
        }
        graphics.m_280218_(TEXTURE, startX + this.xPos, startY + this.yPos, 0, 0, this.width, this.height);
        this.logic.draw(graphics);
        graphics.m_280430_(this.gui.font(), (Component)Component.m_237115_((String)"for.gui.filter.seletion"), startX + this.xPos + 12, startY + this.yPos + 4, this.manager.gui.getFontColor().get("gui.title"));
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.logic != null && super.isMouseOver(mouseX, mouseY);
    }

    @Override
    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        if (this.logic == null) {
            return null;
        }
        return this.logic.getToolTip(mouseX, mouseY);
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (this.logic == null) {
            return;
        }
        this.logic.select(mouseX, mouseY);
    }

    public void filterEntries(String filter) {
        if (this.logic == null) {
            return;
        }
        this.logic.filterEntries(filter);
    }
}

