/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugin;

import forestry.api.ForestryTags;
import forestry.api.apiculture.ForestryBeeSpecies;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.api.genetics.alleles.ForestryAlleles;
import forestry.api.plugin.IApicultureRegistration;
import forestry.api.plugin.IBeeSpeciesBuilder;
import forestry.apiculture.CaveMutationCondition;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.genetics.FireworkProduct;
import forestry.apiculture.genetics.HermitBeeJubilance;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.apiculture.items.EnumPollenCluster;
import forestry.core.features.CoreItems;
import forestry.core.genetics.mutations.MutationConditionCave;
import forestry.core.items.definitions.EnumCraftingMaterial;
import java.awt.Color;
import java.time.Month;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.Tags;

public class DefaultBeeSpecies {
    public static void register(IApicultureRegistration apiculture) {
        ResourceLocation[] overworldHiveBees = new ResourceLocation[]{ForestryBeeSpecies.FOREST, ForestryBeeSpecies.MARSHY, ForestryBeeSpecies.MEADOWS, ForestryBeeSpecies.MODEST, ForestryBeeSpecies.SAVANNA, ForestryBeeSpecies.TROPICAL, ForestryBeeSpecies.VALIANT, ForestryBeeSpecies.WINTRY, ForestryBeeSpecies.LUSH, ForestryBeeSpecies.AQUATIC};
        apiculture.registerSpecies(ForestryBeeSpecies.FOREST, "apis", "nigrocincta", true, new Color(1691884)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY), 0.3f).setGenome(genome -> {
            genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_SLOWER);
            genome.set(BeeChromosomes.FERTILITY, ForestryAlleles.FERTILITY_3);
            genome.set(BeeChromosomes.TEMPERATURE_TOLERANCE, ForestryAlleles.TOLERANCE_DOWN_1);
        });
        apiculture.registerSpecies(ForestryBeeSpecies.MEADOWS, "apis", "florea", true, new Color(15667998)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY), 0.3f).setGenome(genome -> {
            genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_SLOWER);
            genome.set(BeeChromosomes.HUMIDITY_TOLERANCE, ForestryAlleles.TOLERANCE_DOWN_1);
        });
        ((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.COMMON, "apis", "cerana", true, new Color(0xB2B2B2)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY), 0.35f).setGenome(genome -> genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER))).addMutations(mutations -> {
            for (int i = 0; i < overworldHiveBees.length; ++i) {
                ResourceLocation firstParent = overworldHiveBees[i];
                for (int j = i + 1; j < overworldHiveBees.length; ++j) {
                    mutations.add(firstParent, overworldHiveBees[j], 15);
                }
            }
        });
        ((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.CULTIVATED, "apis", "mellifera", true, new Color(5715180)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY), 0.4f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_FAST);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORTEST);
        })).addMutations(mutations -> {
            for (ResourceLocation secondParent : overworldHiveBees) {
                mutations.add(ForestryBeeSpecies.COMMON, secondParent, 12);
            }
        });
        ((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.NOBLE, "probapis", "nobilis", false, new Color(15505945)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.DRIPPING), 0.2f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORT);
            genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_SLOW);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.COMMON, ForestryBeeSpecies.CULTIVATED, 10));
        ((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.MAJESTIC, "probapis", "regalis", true, new Color(0x7F0000)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.DRIPPING), 0.3f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_NORMAL);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORTENED);
            genome.set(BeeChromosomes.FERTILITY, ForestryAlleles.FERTILITY_4);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.NOBLE, ForestryBeeSpecies.CULTIVATED, 8));
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.IMPERIAL, "probapis", "imperatorius", false, new Color(10739759)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.DRIPPING), 0.2f).addProduct(ApicultureItems.ROYAL_JELLY.stack(), 0.15f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_NORMAL);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_BEATIFIC);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.NOBLE, ForestryBeeSpecies.MAJESTIC, 8))).setGlint(true);
        ((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.DILIGENT, "industrapis", "sedulus", false, new Color(12720620)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.STRINGY), 0.2f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORT);
            genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_SLOW);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.COMMON, ForestryBeeSpecies.CULTIVATED, 10));
        ((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.UNWEARY, "industrapis", "assiduus", true, new Color(1698906)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.STRINGY), 0.3f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_NORMAL);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORTENED);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.DILIGENT, ForestryBeeSpecies.CULTIVATED, 8));
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.INDUSTRIOUS, "industrapis", "industria", false, new Color(0xFFFFFF)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.STRINGY), 0.2f).addProduct(ApicultureItems.POLLEN_CLUSTER.stack(EnumPollenCluster.NORMAL), 0.15f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_NORMAL);
            genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_FAST);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.DILIGENT, ForestryBeeSpecies.UNWEARY, 8))).setGlint(true);
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.SINISTER, "diapis", "caecus", false, new Color(11785700)).setBody(new Color(10101539)).setTemperature(TemperatureType.HELLISH)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SIMMERING), 0.45f).addProduct(CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.PHOSPHOR, 2), 0.3f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_NORMAL);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_AGGRESSIVE);
        })).addMutations(mutations -> {
            ResourceLocation[] parents;
            for (ResourceLocation parent : parents = new ResourceLocation[]{ForestryBeeSpecies.MODEST, ForestryBeeSpecies.TROPICAL}) {
                mutations.add(ForestryBeeSpecies.CULTIVATED, parent, 60).restrictBiomeType((TagKey<Biome>)BiomeTags.f_207612_);
            }
        });
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.FIENDISH, "diapis", "diabolus", true, new Color(14139109)).setBody(new Color(10101539)).setTemperature(TemperatureType.HELLISH)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SIMMERING), 0.55f).addProduct(CoreItems.ASH.stack(), 0.15f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_NORMAL);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONG);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_AGGRESSIVE);
        })).addMutations(mutations -> {
            ResourceLocation[] parents;
            for (ResourceLocation parent : parents = new ResourceLocation[]{ForestryBeeSpecies.CULTIVATED, ForestryBeeSpecies.MODEST, ForestryBeeSpecies.TROPICAL}) {
                mutations.add(ForestryBeeSpecies.SINISTER, parent, 40).restrictBiomeType((TagKey<Biome>)BiomeTags.f_207612_);
            }
        });
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.DEMONIC, "diapis", "draco", false, new Color(16049152)).setBody(new Color(10101539)).setTemperature(TemperatureType.HELLISH)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SIMMERING), 0.45f).addProduct(new ItemStack((ItemLike)Items.f_42525_), 0.15f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONGER);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_IGNITION);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.SINISTER, ForestryBeeSpecies.FIENDISH, 25).restrictBiomeType((TagKey<Biome>)BiomeTags.f_207612_))).setGlint(true);
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.MODEST, "modapis", "modicus", false, new Color(12959366)).setTemperature(TemperatureType.HOT)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.PARCHED), 0.2f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORT);
        });
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.FRUGAL, "modapis", "permodestus", true, new Color(15260849)).setTemperature(TemperatureType.HOT)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.PARCHED), 0.3f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_NORMAL);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONG);
        })).addMutations(mutations -> {
            mutations.add(ForestryBeeSpecies.MODEST, ForestryBeeSpecies.SINISTER, 16).restrictTemperature(TemperatureType.HOT, TemperatureType.HELLISH).restrictHumidity(HumidityType.ARID);
            mutations.add(ForestryBeeSpecies.MODEST, ForestryBeeSpecies.FIENDISH, 10).restrictTemperature(TemperatureType.HOT, TemperatureType.HELLISH).restrictHumidity(HumidityType.ARID);
        });
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.AUSTERE, "modapis", "correpere", false, new Color(16775874)).setTemperature(TemperatureType.HOT)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.PARCHED), 0.2f).addSpecialty(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.POWDERY), 0.5f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWEST);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONGER);
            genome.set(BeeChromosomes.TEMPERATURE_TOLERANCE, ForestryAlleles.TOLERANCE_DOWN_2);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_CREEPER);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.MODEST, ForestryBeeSpecies.FRUGAL, 8).restrictTemperature(TemperatureType.HOT, TemperatureType.HELLISH).restrictHumidity(HumidityType.ARID))).setGlint(true);
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.TROPICAL, "caldapis", "mendelia", false, new Color(3637280)).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SILKY), 0.2f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORT);
        });
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.EXOTIC, "caldapis", "darwini", true, new Color(3164419)).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SILKY), 0.3f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_NORMAL);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONG);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.AUSTERE, ForestryBeeSpecies.TROPICAL, 12));
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.EDENIC, "caldapis", "humboldti", false, new Color(3751181)).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SILKY), 0.2f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWEST);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONGER);
            genome.set(BeeChromosomes.TEMPERATURE_TOLERANCE, ForestryAlleles.TOLERANCE_BOTH_2);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_EXPLORATION);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.EXOTIC, ForestryBeeSpecies.TROPICAL, 8))).setGlint(true);
        apiculture.registerSpecies(ForestryBeeSpecies.MONASTIC, "monapis", "monachus", false, new Color(4339484)).setJubilance(HermitBeeJubilance.INSTANCE).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.WHEATEN), 0.3f).addSpecialty(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MELLOW), 0.1f);
        ((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.SECLUDED, "monapis", "contractus", true, new Color(8087092)).setJubilance(HermitBeeJubilance.INSTANCE).addSpecialty(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MELLOW), 0.2f).setGenome(genome -> genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_FASTEST))).addMutations(mutations -> mutations.add(ForestryBeeSpecies.MONASTIC, ForestryBeeSpecies.AUSTERE, 12));
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.HERMITIC, "monapis", "anachoreta", false, new Color(16766060)).setJubilance(HermitBeeJubilance.INSTANCE).addSpecialty(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MELLOW), 0.2f).setGenome(genome -> {
            genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_FASTEST);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_REPULSION);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.MONASTIC, ForestryBeeSpecies.SECLUDED, 8))).setGlint(true);
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.SHULKING, "finapis", "shurukui", false, new Color(9006452)).setBody(TextColor.m_131266_((int)0xD9DE9E)).setTemperature(TemperatureType.COLD)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MYSTERIOUS), 0.2f).addSpecialty(new ItemStack((ItemLike)Items.f_42748_), 0.015f).setGenome(genome -> {
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_ASCENSION);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOW);
        })).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.ENDED, "finapis", "mikui", false, new Color(14711290)).setBody(new Color(0xD9DE9E)).setTemperature(TemperatureType.COLD)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MYSTERIOUS), 0.3f);
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.SPECTRAL, "finapis", "idolum", true, new Color(11111405)).setBody(new Color(0xD9DE9E)).setTemperature(TemperatureType.COLD)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MYSTERIOUS), 0.5f).setGenome(genome -> genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_REANIMATION))).addMutations(mutations -> mutations.add(ForestryBeeSpecies.HERMITIC, ForestryBeeSpecies.ENDED, 4));
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.PHANTASMAL, "finapis", "lemur", false, new Color(13369594)).setBody(new Color(0xD9DE9E)).setTemperature(TemperatureType.COLD)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MYSTERIOUS), 0.4f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWEST);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONGEST);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_RESURRECTION);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.SPECTRAL, ForestryBeeSpecies.ENDED, 2))).setGlint(true);
        ((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.WINTRY, "coagapis", "brumalis", false, new Color(10551240)).setBody(new Color(14349811)).setTemperature(TemperatureType.ICY)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.FROZEN), 0.3f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORT);
            genome.set(BeeChromosomes.FERTILITY, ForestryAlleles.FERTILITY_4);
        });
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.ICY, "coagapis", "coagulis", true, new Color(0xA0FFFF)).setBody(new Color(14349811)).setTemperature(TemperatureType.ICY)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.FROZEN), 0.2f).addProduct(CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.ICE_SHARD), 0.2f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOW);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORT);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.INDUSTRIOUS, ForestryBeeSpecies.WINTRY, 12).restrictTemperature(TemperatureType.ICY, TemperatureType.COLD));
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.GLACIAL, "coagapis", "glacialis", false, new Color(0xEFFFFF)).setBody(new Color(14349811)).setTemperature(TemperatureType.ICY)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.FROZEN), 0.2f).addProduct(CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.ICE_SHARD), 0.4f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORT);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.ICY, ForestryBeeSpecies.WINTRY, 8).restrictTemperature(TemperatureType.ICY, TemperatureType.COLD))).setGlint(true);
        ((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.MARSHY, "paludapis", "adorasti", true, new Color(5531174)).setHumidity(HumidityType.DAMP)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MOSSY), 0.3f);
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.MIRY, "paludapis", "humidium", true, new Color(9613122)).setHumidity(HumidityType.DAMP)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MOSSY), 0.36f).setGenome(genome -> {
            genome.set(BeeChromosomes.FERTILITY, ForestryAlleles.FERTILITY_4);
            genome.set(BeeChromosomes.TOLERATES_RAIN, true);
            genome.set(BeeChromosomes.ACTIVITY, ForestryAlleles.ACTIVITY_METATURNAL);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.MARSHY, ForestryBeeSpecies.NOBLE, 15).restrictTemperature(TemperatureType.WARM).restrictHumidity(HumidityType.DAMP))).setAuthority("MysteriousAges");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.BOGGY, "paludapis", "paluster", true, new Color(6916424)).setHumidity(HumidityType.DAMP)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MOSSY), 0.39f).addSpecialty(CoreItems.PEAT.stack(), 0.08f).setGenome(genome -> {
            genome.set(BeeChromosomes.TOLERATES_RAIN, true);
            genome.set(BeeChromosomes.ACTIVITY, ForestryAlleles.ACTIVITY_METATURNAL);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_MYCOPHILIC);
            genome.set(BeeChromosomes.TERRITORY, ForestryAlleles.TERRITORY_LARGER);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.MARSHY, ForestryBeeSpecies.MIRY, 9).restrictTemperature(TemperatureType.WARM).restrictHumidity(HumidityType.DAMP))).setAuthority("MysteriousAges");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.SAVANNA, "afrapis", "scutellata", true, new Color(11554319)).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.PARCHED), 0.2f).addSpecialty(new ItemStack((ItemLike)Items.f_41831_), 0.1f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORT);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.TERRITORY, ForestryAlleles.TERRITORY_LARGE);
        })).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.ARGIL, "afrapis", "argillata", true, new Color(9875410)).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.KAOLIN), 0.3f).addSpecialty(new ItemStack((ItemLike)Items.f_41831_), 0.15f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORT);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOW);
            genome.set(BeeChromosomes.TERRITORY, ForestryAlleles.TERRITORY_LARGE);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_SIFTER);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.SAVANNA, ForestryBeeSpecies.DILIGENT, 15).restrictTemperature(TemperatureType.WARM, TemperatureType.HOT).restrictHumidity(HumidityType.ARID))).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.PRIDE, "afrapis", "rafikii", true, new Color(6619169)).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.KAOLIN), 0.2f).addSpecialty(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MELLOW), 0.1f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORTENED);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.TERRITORY, ForestryAlleles.TERRITORY_LARGER);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_HAKUNA_MATATA);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.SAVANNA, ForestryBeeSpecies.ARGIL, 9).restrictBiomeType(ForestryTags.Biomes.SHATTERED_SAVANNA))).setGlint(true)).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.STEADFAST, "herapis", "legio", false, new Color(5057301)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.COCOA), 0.2f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_NORMAL);
        })).setGlint(true);
        apiculture.registerSpecies(ForestryBeeSpecies.VALIANT, "herapis", "centurio", true, new Color(6450141)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.COCOA), 0.3f).addSpecialty(new ItemStack((ItemLike)Items.f_42501_), 0.15f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOW);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONG);
            genome.set(BeeChromosomes.TEMPERATURE_TOLERANCE, ForestryAlleles.TOLERANCE_BOTH_1);
            genome.set(BeeChromosomes.HUMIDITY_TOLERANCE, ForestryAlleles.TOLERANCE_BOTH_1);
        });
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.HEROIC, "herapis", "kraphti", false, new Color(11785700)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.COCOA), 0.4f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOW);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONG);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_HEROIC);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.STEADFAST, ForestryBeeSpecies.VALIANT, 6).restrictBiomeType((TagKey<Biome>)BiomeTags.f_207611_))).setGlint(true);
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.LUSH, "troglobites", "atvatabari", true, new Color(7377453)).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY), 0.35f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_NORMAL);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWEST);
            genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_SLOWER);
        })).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.VERDANT, "troglobites", "lidenbrocki", true, new Color(1858362)).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY), 0.45f).addSpecialty(new ItemStack((ItemLike)Items.f_151019_), 0.15f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONG);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOW);
            genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_SLOWER);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.LUSH, ForestryBeeSpecies.VALIANT, 10).addMutationCondition(new MutationConditionCave()))).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.LUXURIANT, "troglobites", "verni", false, new Color(15436081)).setTemperature(TemperatureType.WARM)).setHumidity(HumidityType.DAMP)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY), 0.55f).addProduct(CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.PHOSPHOR), 0.4f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONG);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWEST);
            genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_FAST);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_GLOW_BERRY_GROW);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.LUSH, ForestryBeeSpecies.VERDANT, 8).addMutationCondition(new MutationConditionCave()))).setAuthority("EnderiumSmith")).setGlint(true);
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.KLEPTOPLASTIC, "phytapis", "vitaraptor", false, new Color(16763271)).setBody(new Color(6613382)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY), 0.3f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONGER);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_NORMAL);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.LUXURIANT, ForestryBeeSpecies.MONASTIC, 12))).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.PHOTOSYNTHETIC, "phytapis", "phytomimus", true, new Color(11979263)).setBody(new Color(6613382)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY), 0.4f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONGER);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_FAST);
        })).addMutations(mutations -> {
            mutations.add(ForestryBeeSpecies.KLEPTOPLASTIC, ForestryBeeSpecies.LUXURIANT, 8);
            mutations.add(ForestryBeeSpecies.KLEPTOPLASTIC, ForestryBeeSpecies.MONASTIC, 8);
        })).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.AUTOTROPHIC, "phytapis", "solaris", false, new Color(16774636)).setBody(new Color(6613382)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY), 0.3f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONGEST);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_FASTER);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.KLEPTOPLASTIC, ForestryBeeSpecies.PHOTOSYNTHETIC, 4))).setGlint(true)).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.AQUATIC, "spongiforma", "squarepantsii", true, new Color(4159204)).setTemperature(TemperatureType.WARM)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SPONGE), 0.3f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORTEST);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOW);
            genome.set(BeeChromosomes.FLOWER_TYPE, ForestryAlleles.FLOWER_TYPE_CORAL);
            genome.set(BeeChromosomes.FERTILITY, ForestryAlleles.FERTILITY_4);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_MIASMIC);
        })).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.PIRATE, "spongiforma", "pirata", true, new Color(4153435)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SPONGE), 0.2f).addSpecialty(new ItemStack((ItemLike)Items.f_42587_), 0.15f).addSpecialty(new ItemStack((ItemLike)Items.f_42534_), 0.02f).addSpecialty(new ItemStack((ItemLike)Items.f_42616_), 0.005f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORTER);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.FLOWER_TYPE, ForestryAlleles.FLOWER_TYPE_SEA);
            genome.set(BeeChromosomes.FERTILITY, ForestryAlleles.FERTILITY_2);
            genome.set(BeeChromosomes.TEMPERATURE_TOLERANCE, ForestryAlleles.TOLERANCE_BOTH_1);
        })).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.PRISMATIC, "spongiforma", "orichalcus", false, new Color(5478530)).setTemperature(TemperatureType.WARM)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SPONGE), 0.2f).addSpecialty(new ItemStack((ItemLike)Items.f_42695_), 0.4f).addSpecialty(new ItemStack((ItemLike)Items.f_42696_), 0.05f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_SHORT);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWER);
            genome.set(BeeChromosomes.FLOWER_TYPE, ForestryAlleles.FLOWER_TYPE_CORAL);
            genome.set(BeeChromosomes.FERTILITY, ForestryAlleles.FERTILITY_2);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_GUARDIAN);
            genome.set(BeeChromosomes.TEMPERATURE_TOLERANCE, ForestryAlleles.TOLERANCE_DOWN_1);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.AQUATIC, ForestryBeeSpecies.PIRATE, 8))).setGlint(true)).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.ABYSSAL, "spongiforma", "stygii", false, new Color(329011)).setTemperature(TemperatureType.COLD)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SPONGE), 0.2f).addSpecialty(new ItemStack((ItemLike)Items.f_151056_), 0.15f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONGER);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWEST);
            genome.set(BeeChromosomes.FLOWER_TYPE, ForestryAlleles.FLOWER_TYPE_SEA);
            genome.set(BeeChromosomes.FERTILITY, ForestryAlleles.FERTILITY_1);
            genome.set(BeeChromosomes.ACTIVITY, ForestryAlleles.ACTIVITY_NOCTURNAL);
            genome.set(BeeChromosomes.CAVE_DWELLING, ForestryAlleles.TRUE);
        })).addMutations(mutations -> {
            mutations.add(ForestryBeeSpecies.PIRATE, ForestryBeeSpecies.ENDED, 40).addMutationCondition(new CaveMutationCondition());
            mutations.add(ForestryBeeSpecies.AQUATIC, ForestryBeeSpecies.ENDED, 40).addMutationCondition(new CaveMutationCondition());
            mutations.add(ForestryBeeSpecies.PIRATE, ForestryBeeSpecies.SHULKING, 60).addMutationCondition(new CaveMutationCondition());
            mutations.add(ForestryBeeSpecies.AQUATIC, ForestryBeeSpecies.SHULKING, 60).addMutationCondition(new CaveMutationCondition());
        })).setGlint(true)).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.EMBITTERED, "irata", "irata", true, new Color(8995652)).setBody(new Color(10101539)).setTemperature(TemperatureType.HELLISH)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SIMMERING), 0.45f).addProduct(CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.PHOSPHOR), 0.15f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_NORMAL);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_AGGRESSIVE);
        })).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.SPITEFUL, "irata", "invida", false, new Color(16690285)).setBody(new Color(10101539)).setTemperature(TemperatureType.HELLISH)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SIMMERING), 0.55f).addSpecialty(ApicultureItems.POLLEN_CLUSTER.stack(EnumPollenCluster.NORMAL), 0.05f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_FAST);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_AGGRESSIVE);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.EMBITTERED, ForestryBeeSpecies.FIENDISH, 12))).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.SEETHING, "irata", "sulphuri", false, new Color(0xFF8F00)).setBody(new Color(10101539)).setTemperature(TemperatureType.HELLISH)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SIMMERING), 0.45f).addProduct(new ItemStack((ItemLike)Items.f_42593_), 0.15f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_NORMAL);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_IGNITION);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.SPITEFUL, ForestryBeeSpecies.EMBITTERED, 8))).setGlint(true)).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.WARPED, "irata", "corrumpata", true, new Color(1356933)).setBody(new Color(10101539)).setTemperature(TemperatureType.HELLISH)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SIMMERING), 0.15f).addSpecialty(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MYSTERIOUS), 0.35f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOW);
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_ELONGATED);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_PHASING);
        })).addMutations(mutations -> {
            mutations.add(ForestryBeeSpecies.EMBITTERED, ForestryBeeSpecies.ENDED, 40).restrictBiomeType(ForestryTags.Biomes.WARPED_FOREST);
            mutations.add(ForestryBeeSpecies.SPITEFUL, ForestryBeeSpecies.ENDED, 40).restrictBiomeType(ForestryTags.Biomes.WARPED_FOREST);
            mutations.add(ForestryBeeSpecies.EMBITTERED, ForestryBeeSpecies.SHULKING, 40).restrictBiomeType(ForestryTags.Biomes.WARPED_FOREST);
            mutations.add(ForestryBeeSpecies.SPITEFUL, ForestryBeeSpecies.SHULKING, 40).restrictBiomeType(ForestryTags.Biomes.WARPED_FOREST);
        })).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.ZOMBIFIED, "abominatio", "inmortui", true, new Color(6917701)).setBody(new Color(14968938)).setTemperature(TemperatureType.HELLISH)).setHumidity(HumidityType.ARID)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SIMMERING), 0.2f).addProduct(new ItemStack((ItemLike)Items.f_42587_), 0.15f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_IMMORTAL);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_NORMAL);
            genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_SLOWEST);
            genome.set(BeeChromosomes.FLOWER_TYPE, ForestryAlleles.FLOWER_TYPE_NETHER);
            genome.set(BeeChromosomes.FERTILITY, ForestryAlleles.FERTILITY_1);
            genome.set(BeeChromosomes.TEMPERATURE_TOLERANCE, ForestryAlleles.TOLERANCE_DOWN_3);
            genome.set(BeeChromosomes.HUMIDITY_TOLERANCE, ForestryAlleles.TOLERANCE_UP_1);
            genome.set(BeeChromosomes.ACTIVITY, ForestryAlleles.ACTIVITY_METATURNAL);
            genome.set(BeeChromosomes.CAVE_DWELLING, ForestryAlleles.TRUE);
        })).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.SCULK, "abominatio", "alieni", true, new Color(13751990)).setBody(new Color(352861)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SCULKEN), 0.3f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONGER);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_NORMAL);
            genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_SLOWEST);
            genome.set(BeeChromosomes.FERTILITY, ForestryAlleles.FERTILITY_1);
            genome.set(BeeChromosomes.FLOWER_TYPE, ForestryAlleles.FLOWER_TYPE_SCULK);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_SCULK);
            genome.set(BeeChromosomes.TERRITORY, ForestryAlleles.TERRITORY_LARGER);
            genome.set(BeeChromosomes.TEMPERATURE_TOLERANCE, ForestryAlleles.TOLERANCE_BOTH_1);
            genome.set(BeeChromosomes.HUMIDITY_TOLERANCE, ForestryAlleles.TOLERANCE_BOTH_1);
            genome.set(BeeChromosomes.ACTIVITY, ForestryAlleles.ACTIVITY_METATURNAL);
            genome.set(BeeChromosomes.CAVE_DWELLING, ForestryAlleles.TRUE);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.ABYSSAL, ForestryBeeSpecies.PHANTASMAL, 4).restrictBiomeType(ForestryTags.Biomes.DEEP_DARK))).setGlint(true)).setAuthority("EnderiumSmith");
        apiculture.registerSpecies(ForestryBeeSpecies.RURAL, "rustapis", "rustico", false, new Color(0xFEFF8F)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.WHEATEN), 0.2f).addMutations(mutations -> mutations.add(ForestryBeeSpecies.MEADOWS, ForestryBeeSpecies.DILIGENT, 12).restrictBiomeType((TagKey<Biome>)Tags.Biomes.IS_PLAINS));
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.FARMERLY, "rustapis", "arator", true, new Color(13866792)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.WHEATEN), 0.27f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOW);
            genome.set(BeeChromosomes.TERRITORY, ForestryAlleles.TERRITORY_LARGE);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.RURAL, ForestryBeeSpecies.UNWEARY, 10).restrictBiomeType((TagKey<Biome>)Tags.Biomes.IS_PLAINS))).setAuthority("MysteriousAges");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.AGRARIAN, "rustapis", "agrarius", true, new Color(16763509)).setBody(new Color(16769095)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.WHEATEN), 0.35f).setGenome(genome -> {
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOW);
            genome.set(BeeChromosomes.HUMIDITY_TOLERANCE, ForestryAlleles.TOLERANCE_BOTH_2);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_FERTILE);
            genome.set(BeeChromosomes.TERRITORY, ForestryAlleles.TERRITORY_LARGE);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.FARMERLY, ForestryBeeSpecies.INDUSTRIOUS, 6).restrictBiomeType((TagKey<Biome>)Tags.Biomes.IS_PLAINS))).setGlint(true)).setAuthority("MysteriousAges");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.PRIMEVAL, "reliquia", "antiqua", true, new Color(6635315)).setTemperature(TemperatureType.WARM)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.VINTAGE), 0.3f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONG);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOW);
            genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_AVERAGE);
            genome.set(BeeChromosomes.FERTILITY, ForestryAlleles.FERTILITY_2);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.ANACHRONE, ForestryBeeSpecies.STEADFAST, 15))).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.ANACHRONE, "reliquia", "tempuraptor", false, new Color(0x55FFFF)).setTemperature(TemperatureType.WARM)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.VINTAGE), 0.2f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_LONGEST);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWEST);
            genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_SLOWEST);
            genome.set(BeeChromosomes.FERTILITY, ForestryAlleles.FERTILITY_1);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_CHRONOPHAGE);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.RELIC, ForestryBeeSpecies.STEADFAST, 10))).setGlint(true)).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.RELIC, "reliquia", "elizabethii", false, new Color(0xFF55FF)).setTemperature(TemperatureType.WARM)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.VINTAGE), 0.2f).addSpecialty(ApicultureItems.ROYAL_JELLY.stack(), 0.15f).setGenome(genome -> {
            genome.set(BeeChromosomes.LIFESPAN, ForestryAlleles.LIFESPAN_IMMORTAL);
            genome.set(BeeChromosomes.SPEED, ForestryAlleles.SPEED_SLOWEST);
            genome.set(BeeChromosomes.POLLINATION, ForestryAlleles.POLLINATION_SLOWEST);
            genome.set(BeeChromosomes.FERTILITY, ForestryAlleles.FERTILITY_1);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_REJUVENATION);
        })).setGlint(true)).setAuthority("EnderiumSmith");
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.LEPORINE, "festapis", "lepus", false, new Color(0xFEFF8F)).setBody(new Color(3987287)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SILKY), 0.3f).addProduct(new ItemStack((ItemLike)Items.f_42521_), 0.1f).setGenome(genome -> genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_EASTER))).addMutations(mutations -> mutations.add(ForestryBeeSpecies.MEADOWS, ForestryBeeSpecies.FOREST, 10).restrictDateRange(Month.MARCH, 29, Month.APRIL, 15))).setGlint(true)).setSecret(true);
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.MERRY, "festapis", "feliciter", false, new Color(0xFFFFFF)).setBody(new Color(0xD40000)).setTemperature(TemperatureType.ICY)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.FROZEN), 0.3f).addProduct(CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.ICE_SHARD), 0.2f).setGenome(genome -> {
            genome.set(BeeChromosomes.ACTIVITY, ForestryAlleles.ACTIVITY_METATURNAL);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_SNOWING);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.WINTRY, ForestryBeeSpecies.FOREST, 10).restrictDateRange(Month.DECEMBER, 21, Month.DECEMBER, 27))).setGlint(true)).setSecret(true);
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.TIPSY, "festapis", "ebrius", false, new Color(0xFFFFFF)).setBody(new Color(12720620)).setTemperature(TemperatureType.ICY)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.FROZEN), 0.3f).addProduct(CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.ICE_SHARD), 0.2f).setGenome(genome -> {
            genome.set(BeeChromosomes.ACTIVITY, ForestryAlleles.ACTIVITY_METATURNAL);
            genome.set(BeeChromosomes.EFFECT, ForestryAlleles.EFFECT_DRUNKARD);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.WINTRY, ForestryBeeSpecies.MEADOWS, 10).restrictDateRange(Month.DECEMBER, 27, Month.JANUARY, 2))).setGlint(true)).setSecret(true);
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.TRICKY, "festapis", "libita", false, new Color(4800827)).setBody(new Color(16738816)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY), 0.4f).addProduct(new ItemStack((ItemLike)Items.f_42572_), 0.15f).addSpecialty(new ItemStack((ItemLike)Items.f_42678_), 0.02f).addSpecialty(new ItemStack((ItemLike)Items.f_42681_), 0.02f).addSpecialty(new ItemStack((ItemLike)Items.f_42682_), 0.02f).addSpecialty(new ItemStack((ItemLike)Items.f_42680_), 0.02f).setGenome(genome -> {
            genome.set(BeeChromosomes.ACTIVITY, ForestryAlleles.ACTIVITY_METATURNAL);
            genome.set(BeeChromosomes.TOLERATES_RAIN, true);
            genome.set(BeeChromosomes.FLOWER_TYPE, ForestryAlleles.FLOWER_TYPE_GOURD);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.SINISTER, ForestryBeeSpecies.COMMON, 10).restrictDateRange(Month.OCTOBER, 15, Month.NOVEMBER, 3))).setGlint(true)).setSecret(true);
        ((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)((IBeeSpeciesBuilder)apiculture.registerSpecies(ForestryBeeSpecies.PATRIOTIC, "festapis", "americanus", true, new Color(668001)).setBody(new Color(11737410)).setStripes(new Color(0xFFFFFF)).addProduct(ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.POWDERY), 0.45f).addProduct(new FireworkProduct(0.2f)).setGenome(genome -> {
            genome.set(BeeChromosomes.TEMPERATURE_TOLERANCE, ForestryAlleles.TOLERANCE_UP_2);
            genome.set(BeeChromosomes.HUMIDITY_TOLERANCE, ForestryAlleles.TOLERANCE_UP_1);
            genome.set(BeeChromosomes.TERRITORY, ForestryAlleles.TERRITORY_LARGEST);
            genome.set(BeeChromosomes.ACTIVITY, ForestryAlleles.ACTIVITY_METATURNAL);
        })).addMutations(mutations -> mutations.add(ForestryBeeSpecies.RURAL, ForestryBeeSpecies.NOBLE, 15).restrictDateRange(Month.JULY, 1, Month.JULY, 17))).setAuthority("TheDarkColour")).setSecret(true);
    }
}

