/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.ITradeStationInfo;
import forestry.core.config.SessionVars;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import forestry.mail.carriers.PostalCarriers;
import forestry.mail.gui.ContainerCatalogue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class GuiCatalogue
extends GuiForestry<ContainerCatalogue> {
    private static final String BOLD_UNDERLINE = ChatFormatting.BOLD.toString() + ChatFormatting.UNDERLINE;
    @Nullable
    private Button buttonFilter;
    @Nullable
    private Button buttonUse;
    private final List<ItemStackWidget> tradeInfoWidgets = new ArrayList<ItemStackWidget>();

    public GuiCatalogue(ContainerCatalogue container, Inventory inv, Component title) {
        super(new ResourceLocation("textures/gui/book.png"), container, inv, title);
        this.f_97726_ = 192;
        this.f_97727_ = 192;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.f_169369_.clear();
        this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)">"), b -> this.actionPerformed(2)).m_252794_(this.f_96543_ / 2 + 44, this.f_97736_ + 150).m_253046_(12, 20).m_253136_());
        this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"<"), b -> this.actionPerformed(3)).m_252794_(this.f_96543_ / 2 - 58, this.f_97736_ + 150).m_253046_(12, 20).m_253136_());
        this.buttonFilter = new Button.Builder((Component)Component.m_237115_((String)"for.gui.mail.filter.all"), b -> this.actionPerformed(4)).m_252794_(this.f_96543_ / 2 - 44, this.f_97736_ + 150).m_253046_(42, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.buttonFilter);
        this.buttonUse = new Button.Builder((Component)Component.m_237115_((String)"for.gui.mail.address.copy"), b -> this.actionPerformed(5)).m_252794_(this.f_96543_ / 2, this.f_97736_ + 150).m_253046_(42, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.buttonUse);
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseY, int mouseX) {
        super.m_7286_(graphics, partialTicks, mouseY, mouseX);
        graphics.m_280056_(this.f_96547_, String.format("%s / %s", ((ContainerCatalogue)this.f_97732_).getPageNumber(), ((ContainerCatalogue)this.f_97732_).getPageCount()), this.f_97735_ + this.f_97726_ - 72, this.f_97736_ + 12, ColourProperties.INSTANCE.get("gui.book"), false);
        this.clearTradeInfoWidgets();
        ITradeStationInfo tradeInfo = ((ContainerCatalogue)this.f_97732_).getTradeInfo();
        if (this.buttonUse != null) {
            if (tradeInfo != null) {
                this.drawTradePreview(graphics, tradeInfo, this.f_97735_ + 38, this.f_97736_ + 30);
                this.buttonUse.f_93624_ = tradeInfo.state().isOk();
            } else {
                this.drawNoTrade(graphics, this.f_97735_ + 38, this.f_97736_ + 30);
                this.buttonUse.f_93624_ = false;
            }
        }
        if (this.buttonFilter != null) {
            this.buttonFilter.m_93666_((Component)Component.m_237115_((String)("for.gui.mail.filter." + ((ContainerCatalogue)this.f_97732_).getFilterIdent())));
        }
    }

    private void drawNoTrade(GuiGraphics graphics, int x, int y) {
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"for.gui.mail.notrades"), x, y + 18, 119, ColourProperties.INSTANCE.get("gui.book"));
    }

    private void drawTradePreview(GuiGraphics graphics, ITradeStationInfo tradeInfo, int x, int y) {
        Font font = this.f_96547_;
        graphics.m_280056_(font, BOLD_UNDERLINE + tradeInfo.address().getName(), x, y, ColourProperties.INSTANCE.get("gui.book"), false);
        graphics.m_280614_(font, (Component)Component.m_237110_((String)"for.gui.mail.willtrade", (Object[])new Object[]{tradeInfo.owner().getName()}), x, y + 18, ColourProperties.INSTANCE.get("gui.book"), false);
        this.addTradeInfoWidget(new ItemStackWidget(this.widgetManager, x - this.f_97735_, y - this.f_97736_ + 28, tradeInfo.tradegood()));
        graphics.m_280614_(font, (Component)Component.m_237115_((String)"for.gui.mail.tradefor"), x, y + 46, ColourProperties.INSTANCE.get("gui.book"), false);
        for (int i = 0; i < tradeInfo.required().size(); ++i) {
            ItemStack itemStack = tradeInfo.required().get(i);
            this.addTradeInfoWidget(new ItemStackWidget(this.widgetManager, x - this.f_97735_ + i * 18, y - this.f_97736_ + 56, itemStack));
        }
        if (tradeInfo.state().isOk()) {
            graphics.m_280554_(font, (FormattedText)((MutableComponent)tradeInfo.state().getDescription()).m_130940_(ChatFormatting.DARK_GREEN), x, y + 82, 119, ColourProperties.INSTANCE.get("gui.book"));
        } else {
            graphics.m_280554_(font, (FormattedText)((MutableComponent)tradeInfo.state().getDescription()).m_130940_(ChatFormatting.DARK_RED), x, y + 82, 119, ColourProperties.INSTANCE.get("gui.book"));
        }
    }

    private void addTradeInfoWidget(ItemStackWidget widget) {
        this.tradeInfoWidgets.add(widget);
        this.widgetManager.add(widget);
    }

    private void clearTradeInfoWidgets() {
        for (Widget widget : this.tradeInfoWidgets) {
            this.widgetManager.remove(widget);
        }
        this.tradeInfoWidgets.clear();
    }

    protected void actionPerformed(int id) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        switch (id) {
            case 0: {
                player.m_6915_();
                break;
            }
            case 2: {
                NetworkUtil.sendToServer(new PacketGuiSelectRequest(0, 0));
                break;
            }
            case 3: {
                NetworkUtil.sendToServer(new PacketGuiSelectRequest(1, 0));
                break;
            }
            case 4: {
                NetworkUtil.sendToServer(new PacketGuiSelectRequest(2, 0));
                break;
            }
            case 5: {
                ITradeStationInfo info = ((ContainerCatalogue)this.f_97732_).getTradeInfo();
                if (info != null) {
                    SessionVars.setStringVar("mail.letter.recipient", info.address().getName());
                    SessionVars.setStringVar("mail.letter.carrier", PostalCarriers.TRADER.getKey().m_135782_().toString());
                }
                player.m_5661_((Component)Component.m_237115_((String)"for.gui.mail.catalogue.save_info"), false);
                player.m_6915_();
            }
        }
    }

    @Override
    protected void addLedgers() {
    }
}

