/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.core.IProduct;
import forestry.api.genetics.ForestrySpeciesTypes;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutationManager;
import forestry.api.genetics.alleles.ButterflyChromosomes;
import forestry.api.genetics.alleles.IKaryotype;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.ILepidopteristTracker;
import forestry.api.lepidopterology.genetics.ButterflyLifeStage;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.api.plugin.IForestryPlugin;
import forestry.api.plugin.ISpeciesTypeBuilder;
import forestry.apiimpl.plugin.LepidopterologyRegistration;
import forestry.core.genetics.SpeciesType;
import forestry.core.genetics.root.BreedingTrackerManager;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.SpeciesUtil;
import forestry.core.utils.TreeUtil;
import forestry.lepidopterology.ButterflySpawner;
import forestry.lepidopterology.ModuleLepidopterology;
import forestry.lepidopterology.blocks.BlockCocoon;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.features.LepidopterologyBlocks;
import forestry.lepidopterology.features.LepidopterologyEntities;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyAlyzerPlugin;
import forestry.lepidopterology.genetics.LepidopteristTracker;
import forestry.lepidopterology.tiles.TileCocoon;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ButterflySpeciesType
extends SpeciesType<IButterflySpecies, IButterfly>
implements IButterflySpeciesType {
    public ButterflySpeciesType(IKaryotype karyotype, ISpeciesTypeBuilder builder) {
        super(ForestrySpeciesTypes.BUTTERFLY, karyotype, builder);
    }

    @Override
    public Pair<ImmutableMap<ResourceLocation, IButterflySpecies>, IMutationManager<IButterflySpecies>> handleSpeciesRegistration(List<IForestryPlugin> plugins) {
        LepidopterologyRegistration registration = new LepidopterologyRegistration(this);
        for (IForestryPlugin plugin : plugins) {
            plugin.registerLepidopterology(registration);
        }
        ButterflyChromosomes.EFFECT.populate(registration.getEffects());
        ButterflyChromosomes.COCOON.populate(registration.getCocoons());
        return registration.buildAll();
    }

    @Override
    public void onSpeciesRegistered(ImmutableMap<ResourceLocation, IButterflySpecies> allSpecies, IMutationManager<IButterflySpecies> mutations) {
        super.onSpeciesRegistered(allSpecies, mutations);
        if (ModuleLepidopterology.spawnButterflysFromLeaves) {
            ((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).registerLeafTickHandler(new ButterflySpawner());
        }
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof IButterfly;
    }

    public EntityButterfly spawnButterflyInWorld(Level level, IButterfly butterfly, double x, double y, double z) {
        return EntityUtil.spawnEntity(level, EntityButterfly.create(LepidopterologyEntities.BUTTERFLY.entityType(), level, butterfly, BlockPos.m_274561_((double)x, (double)y, (double)z)), x, y, z);
    }

    @Override
    @Nullable
    public BlockPos plantCocoon(LevelAccessor level, BlockPos coordinates, @Nullable IButterfly caterpillar, int age, boolean createNursery) {
        if (caterpillar == null) {
            return null;
        }
        BlockPos pos = ButterflySpeciesType.getValidCocoonPos(level, coordinates, createNursery);
        if (pos == null) {
            return null;
        }
        BlockState state = (BlockState)LepidopterologyBlocks.COCOON.defaultState().m_61124_((Property)BlockCocoon.AGE, (Comparable)Integer.valueOf(age));
        boolean placed = level.m_7731_(pos, state, 18);
        if (!placed) {
            return null;
        }
        Block block = level.m_8055_(pos).m_60734_();
        if (!LepidopterologyBlocks.COCOON.blockEqual(block)) {
            return null;
        }
        TileCocoon cocoon = TileUtil.getTile((BlockGetter)level, pos, TileCocoon.class);
        if (cocoon == null) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 18);
            return null;
        }
        cocoon.setCaterpillar(caterpillar);
        return pos;
    }

    @Nullable
    private static BlockPos getValidCocoonPos(LevelAccessor world, BlockPos pos, boolean createNursery) {
        if (ButterflySpeciesType.isPositionValid(world, pos.m_7495_(), createNursery)) {
            return pos.m_7495_();
        }
        for (int tries = 0; tries < 3; ++tries) {
            for (int y = 1; y < world.m_213780_().m_188503_(5); ++y) {
                BlockPos coordinate = pos.m_7918_(world.m_213780_().m_188503_(6) - 3, -y, world.m_213780_().m_188503_(6) - 3);
                if (!ButterflySpeciesType.isPositionValid(world, coordinate, createNursery)) continue;
                return coordinate;
            }
        }
        return null;
    }

    public static boolean isPositionValid(LevelAccessor world, BlockPos pos, boolean createNursery) {
        BlockState blockState = world.m_8055_(pos);
        if (BlockUtil.canReplace(blockState, world, pos)) {
            BlockPos nurseryPos = pos.m_7494_();
            IButterflyNursery nursery = TreeUtil.getNursery(world, nurseryPos);
            if (nursery != null) {
                return true;
            }
            if (createNursery && TreeUtil.canCreateNursery(world, nurseryPos)) {
                nursery = TreeUtil.getOrCreateNursery(world, nurseryPos, false);
                return nursery != null && nursery.getCaterpillar() == null;
            }
        }
        return false;
    }

    @Override
    public boolean isMated(ItemStack stack) {
        return IIndividualHandlerItem.filter(stack, individual -> {
            IButterfly butterfly;
            return individual instanceof IButterfly && (butterfly = (IButterfly)individual).getMate() != null;
        });
    }

    @Override
    public ILepidopteristTracker getBreedingTracker(LevelAccessor level, @Nullable GameProfile profile) {
        return (ILepidopteristTracker)BreedingTrackerManager.INSTANCE.getTracker(this, level, profile);
    }

    @Override
    public String getBreedingTrackerFile(@Nullable GameProfile profile) {
        return "LepidopteristTracker." + (Serializable)(profile == null ? "common" : profile.getId());
    }

    @Override
    public IBreedingTracker createBreedingTracker() {
        return new LepidopteristTracker();
    }

    @Override
    public void initializeBreedingTracker(IBreedingTracker tracker, @Nullable Level world, @Nullable GameProfile profile) {
        if (tracker instanceof LepidopteristTracker) {
            LepidopteristTracker butterflyTracker = (LepidopteristTracker)tracker;
            butterflyTracker.setLevel(world);
            butterflyTracker.setUsername(profile);
        }
    }

    @Override
    public IAlyzerPlugin getAlyzerPlugin() {
        return ButterflyAlyzerPlugin.INSTANCE;
    }

    @Override
    public float getResearchSuitability(IButterflySpecies species, ItemStack stack) {
        for (IProduct product : species.getButterflyLoot()) {
            if (!stack.m_150930_(product.item())) continue;
            return 1.0f;
        }
        for (IProduct product : species.getCaterpillarProducts()) {
            if (!stack.m_150930_(product.item())) continue;
            return 1.0f;
        }
        return super.getResearchSuitability(species, stack);
    }

    @Override
    public List<ItemStack> getResearchBounty(IButterflySpecies species, Level level, GameProfile researcher, IButterfly individual, int bountyLevel) {
        List<ItemStack> bounty = super.getResearchBounty(species, level, researcher, individual, bountyLevel);
        bounty.add(individual.createStack(ButterflyLifeStage.SERUM));
        return bounty;
    }

    @Override
    public Codec<? extends IButterfly> getIndividualCodec() {
        return Butterfly.CODEC;
    }
}

