/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.api.ForestryTags;
import forestry.api.IForestryApi;
import forestry.api.client.IForestryClientApi;
import forestry.api.genetics.ForestrySpeciesTypes;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.ButterflyChromosomes;
import forestry.api.genetics.pollen.IPollen;
import forestry.api.genetics.pollen.IPollenType;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.api.lepidopterology.ILepidopteristTracker;
import forestry.api.lepidopterology.genetics.ButterflyLifeStage;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.core.config.ForestryConfig;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.SpeciesUtil;
import forestry.lepidopterology.ModuleLepidopterology;
import forestry.lepidopterology.entities.AIButterflyFlee;
import forestry.lepidopterology.entities.AIButterflyMate;
import forestry.lepidopterology.entities.AIButterflyPollinate;
import forestry.lepidopterology.entities.AIButterflyRest;
import forestry.lepidopterology.entities.AIButterflyRise;
import forestry.lepidopterology.entities.AIButterflyWander;
import forestry.lepidopterology.entities.EnumButterflyState;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;

public class EntityButterfly
extends PathfinderMob
implements IEntityButterfly {
    private static final String NBT_BUTTERFLY = "BTFLY";
    private static final String NBT_POLLEN_TYPE = "PLNTP";
    private static final String NBT_POLLEN = "PLN";
    private static final String NBT_STATE = "STATE";
    private static final String NBT_EXHAUSTION = "EXH";
    private static final String NBT_HOME = "HOME";
    public static final int COOLDOWNS = 1500;
    private static final EntityDataAccessor<String> DATAWATCHER_ID_SPECIES = SynchedEntityData.m_135353_(EntityButterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> DATAWATCHER_ID_SIZE = SynchedEntityData.m_135353_(EntityButterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATAWATCHER_ID_STATE = SynchedEntityData.m_135353_(EntityButterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final float DEFAULT_BUTTERFLY_SIZE = 0.75f;
    private static final EnumButterflyState DEFAULT_STATE = EnumButterflyState.FLYING;
    public static final int EXHAUSTION_REST = 1000;
    public static final int EXHAUSTION_CONSUMPTION = 100000;
    public static final int MAX_LIFESPAN = 168000;
    @Nullable
    private Vec3 flightTarget;
    private int exhaustion;
    private IButterfly contained = (IButterfly)IForestryApi.INSTANCE.getGeneticManager().createDefaultIndividual(ForestrySpeciesTypes.BUTTERFLY);
    @Nullable
    private IPollen<?> pollen;
    public int cooldownPollination = 0;
    public int cooldownEgg = 0;
    public int cooldownMate = 0;
    private boolean isImmuneToFire;
    @Nullable
    private IButterflySpecies species;
    private float size = 0.75f;
    private EnumButterflyState state = DEFAULT_STATE;
    @OnlyIn(value=Dist.CLIENT)
    private ResourceLocation textureResource;

    public EntityButterfly(EntityType<EntityButterfly> type, Level world) {
        super(type, world);
    }

    public static EntityButterfly create(EntityType<EntityButterfly> type, Level world, IButterfly butterfly, BlockPos homePos) {
        EntityButterfly bf = new EntityButterfly(type, world);
        bf.setIndividual(butterfly);
        bf.m_21446_(homePos, ModuleLepidopterology.maxDistance);
        return bf;
    }

    public static boolean isMaxButterflyCluster(Vec3 center, Level level) {
        return level.m_45933_(null, AABB.m_165882_((Vec3)center, (double)((Integer)ForestryConfig.SERVER.butterflyClusterWidth.get()).intValue(), (double)((Integer)ForestryConfig.SERVER.butterflyClusterHeight.get()).intValue(), (double)((Integer)ForestryConfig.SERVER.butterflyClusterWidth.get()).intValue())).size() > (Integer)ForestryConfig.SERVER.butterflyClusterLimit.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATAWATCHER_ID_SPECIES, (Object)"");
        this.f_19804_.m_135372_(DATAWATCHER_ID_SIZE, (Object)75);
        this.f_19804_.m_135372_(DATAWATCHER_ID_STATE, (Object)((byte)DEFAULT_STATE.ordinal()));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new AIButterflyFlee(this));
        this.f_21345_.m_25352_(9, (Goal)new AIButterflyMate(this));
        this.f_21345_.m_25352_(10, (Goal)new AIButterflyPollinate(this));
        this.f_21345_.m_25352_(11, (Goal)new AIButterflyRest(this));
        this.f_21345_.m_25352_(12, (Goal)new AIButterflyRise(this));
        this.f_21345_.m_25352_(13, (Goal)new AIButterflyWander(this));
    }

    @Override
    public PathfinderMob getEntity() {
        return this;
    }

    public void m_7380_(CompoundTag nbt) {
        Tag pollenNbt;
        super.m_7380_(nbt);
        Tag containedNbt = SpeciesUtil.serializeIndividual(this.contained);
        if (containedNbt != null) {
            nbt.m_128365_(NBT_BUTTERFLY, containedNbt);
        }
        if (this.pollen != null && (pollenNbt = this.pollen.writeNbt()) != null) {
            nbt.m_128359_(NBT_POLLEN_TYPE, this.pollen.getType().id().toString());
            nbt.m_128365_(NBT_POLLEN, pollenNbt);
        }
        nbt.m_128344_(NBT_STATE, (byte)this.getState().ordinal());
        nbt.m_128405_(NBT_EXHAUSTION, this.exhaustion);
        nbt.m_128356_(NBT_HOME, this.m_21534_().m_121878_());
    }

    public void m_7378_(CompoundTag nbt) {
        IPollenType<?> type;
        super.m_7378_(nbt);
        IButterfly butterfly = null;
        if (nbt.m_128441_(NBT_BUTTERFLY)) {
            butterfly = (IButterfly)SpeciesUtil.deserializeIndividual((ISpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get(), (Tag)nbt.m_128469_(NBT_BUTTERFLY));
        }
        this.setIndividual(butterfly);
        Tag pollenNbt = nbt.m_128423_(NBT_POLLEN);
        if (pollenNbt != null && nbt.m_128441_(NBT_POLLEN_TYPE) && (type = IForestryApi.INSTANCE.getPollenManager().getPollenType(new ResourceLocation(nbt.m_128461_(NBT_POLLEN_TYPE)))) != null) {
            this.pollen = type.readNbt(pollenNbt);
        }
        EnumButterflyState butterflyState = EnumButterflyState.VALUES[nbt.m_128445_(NBT_STATE)];
        this.setState(butterflyState);
        this.exhaustion = nbt.m_128451_(NBT_EXHAUSTION);
        BlockPos home = BlockPos.m_122022_((long)nbt.m_128454_(NBT_HOME));
        this.m_21446_(home, ModuleLepidopterology.maxDistance);
    }

    public float getWingFlap(float partialTickTime) {
        int offset = this.species != null ? this.species.id().toString().hashCode() : this.m_9236_().f_46441_.m_188502_();
        return this.getState().getWingFlap(this, offset, partialTickTime);
    }

    public void setState(EnumButterflyState state) {
        if (this.state != state) {
            this.state = state;
            if (!this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(DATAWATCHER_ID_STATE, (Object)((byte)state.ordinal()));
            }
        }
    }

    public EnumButterflyState getState() {
        return this.state;
    }

    public float getSize() {
        return this.size;
    }

    public float m_6113_() {
        return this.contained.getGenome().getActiveValue(ButterflyChromosomes.SPEED);
    }

    public boolean m_5825_() {
        return this.isImmuneToFire;
    }

    @Nullable
    public Vec3 getDestination() {
        return this.flightTarget;
    }

    public void setDestination(@Nullable Vec3 destination) {
        this.flightTarget = destination;
    }

    public float m_21692_(BlockPos pos) {
        int depth;
        Level level = this.m_9236_();
        if (!level.m_46805_(pos)) {
            return -100.0f;
        }
        float weight = 0.0f;
        double distanceToHome = this.m_21534_().m_123331_((Vec3i)pos);
        if (!this.isWithinHomeDistanceFromPosition(distanceToHome)) {
            weight = (float)((double)weight - (7.5 + 0.005 * (distanceToHome / 4.0)));
        }
        if (!this.getButterfly().isAcceptedEnvironment(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) {
            weight -= 15.0f;
        }
        if (!level.m_45976_(EntityButterfly.class, new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1))).isEmpty()) {
            weight -= 1.0f;
        }
        if ((depth = this.getFluidDepth(pos)) > 0) {
            weight -= 0.1f * (float)depth;
        } else {
            BlockState blockState = level.m_8055_(pos);
            Block block = blockState.m_60734_();
            if (blockState.m_204336_(BlockTags.f_13041_)) {
                weight += 2.0f;
            } else if (block instanceof IPlantable) {
                weight += 1.5f;
            } else if (block instanceof BonemealableBlock) {
                weight += 1.0f;
            } else if (blockState.m_204336_(BlockTags.f_13035_)) {
                weight += 1.0f;
            }
            BlockPos posBelow = pos.m_7495_();
            BlockState blockStateBelow = level.m_8055_(posBelow);
            Block blockBelow = blockStateBelow.m_60734_();
            if (blockState.m_204336_(BlockTags.f_13035_)) {
                weight += 5.0f;
            } else if (blockBelow instanceof FenceBlock) {
                weight += 1.0f;
            } else if (blockBelow instanceof WallBlock) {
                weight += 1.0f;
            }
        }
        return weight += (float)level.m_45517_(LightLayer.SKY, pos);
    }

    private boolean isWithinHomeDistanceFromPosition(double distanceToHome) {
        return distanceToHome < (double)(this.m_21535_() * this.m_21535_());
    }

    private int getFluidDepth(BlockPos pos) {
        ChunkAccess chunk = this.m_9236_().m_46865_(pos);
        int xx = pos.m_123341_() & 0xF;
        int zz = pos.m_123343_() & 0xF;
        int depth = 0;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos(xx, 0, zz);
        for (int y = chunk.m_62098_() + 15; y > 0; --y) {
            BlockState blockState = chunk.m_8055_((BlockPos)cursor.m_142448_(y));
            if (blockState.m_278721_()) {
                ++depth;
                continue;
            }
            if (!blockState.m_60795_()) break;
        }
        return depth;
    }

    @Override
    @Nullable
    public IPollen<?> getPollen() {
        return this.pollen;
    }

    @Override
    public void setPollen(@Nullable IPollen<?> pollen) {
        this.pollen = pollen;
    }

    @Override
    public void changeExhaustion(int change) {
        this.exhaustion = Math.max(this.exhaustion + change, 0);
    }

    @Override
    public int getExhaustion() {
        return this.exhaustion;
    }

    public boolean canFly() {
        return this.contained.canTakeFlight(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public void setIndividual(@Nullable IButterfly butterfly) {
        if (butterfly == null) {
            butterfly = (IButterfly)IForestryApi.INSTANCE.getGeneticManager().createDefaultIndividual(ForestrySpeciesTypes.BUTTERFLY);
        }
        this.contained = butterfly;
        IGenome genome = this.contained.getGenome();
        this.isImmuneToFire = genome.getActiveValue(ButterflyChromosomes.FIREPROOF);
        this.size = genome.getActiveValue(ButterflyChromosomes.SIZE);
        this.species = genome.getActiveValue(ButterflyChromosomes.SPECIES);
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATAWATCHER_ID_SIZE, (Object)((int)(this.size * 100.0f)));
            this.f_19804_.m_135381_(DATAWATCHER_ID_SPECIES, (Object)this.species.id().toString());
        } else {
            this.textureResource = (ResourceLocation)IForestryClientApi.INSTANCE.getButterflyManager().getTextures(this.species).getSecond();
        }
    }

    @Override
    public IButterfly getButterfly() {
        return this.contained;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (!this.m_9236_().f_46443_) {
            this.setIndividual(this.contained);
        }
        return spawnDataIn;
    }

    public Component m_7755_() {
        if (this.species == null) {
            return super.m_7755_();
        }
        return this.species.getDisplayName();
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return true;
    }

    public int m_6078_() {
        return 1000;
    }

    public boolean isRenderable() {
        return this.species != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture() {
        return this.textureResource;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity other) {
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.f_19797_ > 168000;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.f_20890_) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(ForestryTags.Items.SCOOPS)) {
            Level level = this.m_9236_();
            if (!level.f_46443_) {
                IButterflySpeciesType type = (IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get();
                ILepidopteristTracker tracker = (ILepidopteristTracker)type.getBreedingTracker((LevelAccessor)level, player.m_36316_());
                ItemStack itemStack = this.contained.createStack(ButterflyLifeStage.BUTTERFLY);
                tracker.registerCatch(this.contained);
                ItemStackUtil.dropItemStackAsEntity(itemStack, level, this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_142687_(Entity.RemovalReason.KILLED);
            } else {
                player.m_6674_(hand);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        Level level = this.m_9236_();
        for (ItemStack stack : this.contained.getLootDrop(this, recentlyHitIn, looting)) {
            ItemStackUtil.dropItemStackAsEntity(stack, level, this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        IPollen<?> pollen = this.pollen;
        if (pollen != null) {
            ItemStack pollenStack = pollen.createStack();
            ItemStackUtil.dropItemStackAsEntity(pollenStack, level, this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.species == null) {
                String speciesUid = (String)this.f_19804_.m_135370_(DATAWATCHER_ID_SPECIES);
                IButterflySpecies species = (IButterflySpecies)((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).getSpeciesSafe(new ResourceLocation(speciesUid));
                if (species != null) {
                    this.species = species;
                    this.textureResource = (ResourceLocation)IForestryClientApi.INSTANCE.getButterflyManager().getTextures(this.species).getSecond();
                    this.size = (float)((Integer)this.f_19804_.m_135370_(DATAWATCHER_ID_SIZE)).intValue() / 100.0f;
                }
            }
            byte stateOrdinal = (Byte)this.f_19804_.m_135370_(DATAWATCHER_ID_STATE);
            if (this.state.ordinal() != stateOrdinal) {
                this.setState(EnumButterflyState.VALUES[stateOrdinal]);
            }
        }
        Vec3 motion = this.m_20184_();
        if (this.state == EnumButterflyState.FLYING && this.flightTarget != null && this.flightTarget.f_82480_ > this.m_20182_().f_82480_) {
            this.m_20334_(motion.f_82479_, motion.f_82480_ * 0.6 + 0.15, motion.f_82481_);
        } else {
            this.m_20334_(motion.f_82479_, motion.f_82480_ * 0.6, motion.f_82481_);
        }
        if (this.exhaustion > 100000 && this.f_19796_.m_188503_(20) == 0) {
            this.m_6469_(this.m_269291_().m_269264_(), 1.0f);
        }
        if (this.f_19797_ > 168000) {
            this.m_6469_(this.m_269291_().m_269264_(), 1.0f);
        }
        if (this.cooldownEgg > 0) {
            --this.cooldownEgg;
        }
        if (this.cooldownPollination > 0) {
            --this.cooldownPollination;
        }
        if (this.cooldownMate > 0) {
            --this.cooldownMate;
        }
    }

    protected void m_8024_() {
        Vec3 flightTarget = this.flightTarget;
        if (this.getState().doesMovement && flightTarget != null) {
            Vec3 position = this.m_20182_();
            double diffX = flightTarget.f_82479_ + 0.5 - position.f_82479_;
            double diffY = flightTarget.f_82480_ + 0.1 - position.f_82480_;
            double diffZ = flightTarget.f_82481_ + 0.5 - position.f_82481_;
            Vec3 motion = this.m_20184_();
            double newX = motion.f_82479_ + (Math.signum(diffX) * 0.5 - motion.f_82479_) * 0.1;
            double newY = motion.f_82480_ + (Math.signum(diffY) * 0.7 - motion.f_82480_) * 0.1;
            double newZ = motion.f_82481_ + (Math.signum(diffZ) * 0.5 - motion.f_82481_) * 0.1;
            this.m_20334_(newX, newY, newZ);
            float horizontal = (float)(Mth.m_14136_((double)newZ, (double)newX) * 57.2957763671875) - 90.0f;
            this.m_146922_(this.m_146908_() + Mth.m_14177_((float)(horizontal - this.m_146908_())));
            this.m_21564_(this.contained.getGenome().getActiveValue(ButterflyChromosomes.SPEED));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_6090_() {
        return true;
    }

    protected float m_6121_() {
        return 0.1f;
    }

    public ItemStack getPickedResult(HitResult target) {
        if (this.species == null) {
            return ItemStack.f_41583_;
        }
        return this.species.createStack(ButterflyLifeStage.BUTTERFLY);
    }

    @Override
    public boolean canMateWith(IEntityButterfly butterfly) {
        if (butterfly.getButterfly().getMate() != null) {
            return false;
        }
        if (this.getButterfly().getMate() != null) {
            return false;
        }
        return !this.getButterfly().getGenome().isSameAlleles(butterfly.getButterfly().getGenome());
    }

    @Override
    public boolean canMate() {
        return this.cooldownMate <= 0;
    }
}

