/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.ForestryError;
import forestry.api.core.IErrorLogic;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.StandardTank;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.factory.features.FactoryTiles;
import forestry.factory.gui.ContainerBottler;
import forestry.factory.inventory.InventoryBottler;
import forestry.factory.recipes.BottlerRecipe;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileBottler
extends TilePowered
implements WorldlyContainer,
ILiquidTankTile,
ISlotPickupWatcher {
    private static final int TICKS_PER_RECIPE_TIME = 5;
    private static final int ENERGY_PER_RECIPE_TIME = 1000;
    private final StandardTank resourceTank;
    private final TankManager tankManager;
    private final EnumMap<Direction, Boolean> canDump;
    private boolean dumpingFluid = false;
    @Nullable
    private BottlerRecipe currentRecipe;
    @OnlyIn(value=Dist.CLIENT)
    public boolean isFillRecipe;

    public TileBottler(BlockPos pos, BlockState state) {
        super(FactoryTiles.BOTTLER.tileType(), pos, state, 1100, 40000);
        this.setInternalInventory(new InventoryBottler(this));
        this.resourceTank = new StandardTank(10000);
        this.tankManager = new TankManager(this, this.resourceTank);
        this.canDump = new EnumMap(Direction.class);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.tankManager.write(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.tankManager.read(compound);
        this.checkEmptyRecipe();
        this.checkFillRecipe();
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(FriendlyByteBuf data) {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.updateOnInterval(20)) {
            ItemStack inputStack;
            ItemStack leftProcessingStack = this.m_8020_(2);
            ItemStack rightProcessingStack = this.m_8020_(3);
            if (leftProcessingStack.m_41619_() && !(inputStack = this.m_8020_(0)).m_41619_()) {
                leftProcessingStack = this.m_7407_(0, 1);
                this.m_6836_(2, leftProcessingStack);
            }
            if (rightProcessingStack.m_41619_() && !(inputStack = this.m_8020_(1)).m_41619_()) {
                rightProcessingStack = this.m_7407_(1, 1);
                this.m_6836_(3, rightProcessingStack);
            }
        }
        if (this.canDump() && (this.dumpingFluid || this.updateOnInterval(20))) {
            this.dumpingFluid = this.dumpFluid();
        }
    }

    private boolean canDump() {
        FluidStack fluid = this.tankManager.getFluid(0);
        if (fluid != null) {
            if (this.canDump.isEmpty()) {
                for (Direction facing : Direction.f_122346_) {
                    this.canDump.put(facing, FluidHelper.canAcceptFluid(this.f_58857_, this.f_58858_.m_121945_(facing), facing.m_122424_(), fluid));
                }
            }
            for (Direction facing : Direction.f_122346_) {
                if (!this.canDump.get(facing).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean dumpFluid() {
        if (!this.resourceTank.isEmpty()) {
            for (Direction facing : Direction.f_122346_) {
                LazyOptional fluidDestination;
                if (!this.canDump.get(facing).booleanValue() || !(fluidDestination = FluidUtil.getFluidHandler((Level)this.f_58857_, (BlockPos)this.f_58858_.m_121945_(facing), (Direction)facing.m_122424_())).isPresent()) continue;
                fluidDestination.ifPresent(f -> FluidUtil.tryFluidTransfer((IFluidHandler)f, (IFluidHandler)this.tankManager, (int)50, (boolean)true));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean workCycle() {
        FluidHelper.FillStatus status;
        if (this.currentRecipe != null) {
            status = this.currentRecipe.fillRecipe ? FluidHelper.fillContainers(this.tankManager, (Container)this, 3, 5, this.currentRecipe.fluid.getFluid(), true) : FluidHelper.drainContainers(this.tankManager, (Container)this, 2, 4, true);
        } else {
            return true;
        }
        if (status == FluidHelper.FillStatus.SUCCESS) {
            this.currentRecipe = null;
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborTileChange(Level world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborTileChange(world, pos, neighbor);
        this.canDump.clear();
    }

    private void checkFillRecipe() {
        ItemStack emptyCan = this.m_8020_(3);
        if (!emptyCan.m_41619_()) {
            FluidStack resource = this.resourceTank.getFluid();
            if (resource.isEmpty()) {
                return;
            }
            if (this.currentRecipe == null || !this.currentRecipe.matchEmpty(emptyCan, resource)) {
                this.currentRecipe = BottlerRecipe.createFillingRecipe(resource.getFluid(), emptyCan);
                if (this.currentRecipe != null) {
                    float viscosityMultiplier = (float)resource.getFluid().getFluidType().getViscosity(resource) / 1000.0f;
                    viscosityMultiplier = (viscosityMultiplier - 1.0f) / 20.0f + 1.0f;
                    int fillAmount = Math.min(this.currentRecipe.fluid.getAmount(), resource.getAmount());
                    float fillTime = (float)fillAmount / 1000.0f;
                    this.setTicksPerWorkCycle(Math.round((fillTime *= viscosityMultiplier) * 5.0f));
                    this.setEnergyPerWorkCycle(Math.round(fillTime * 1000.0f));
                }
            }
        }
    }

    private void checkEmptyRecipe() {
        ItemStack filledCan = this.m_8020_(2);
        if (!(filledCan.m_41619_() || this.currentRecipe != null && (this.currentRecipe.matchFilled(filledCan) || this.currentRecipe.fillRecipe))) {
            this.currentRecipe = BottlerRecipe.createEmptyingRecipe(filledCan);
            if (this.currentRecipe != null) {
                FluidStack resource = this.currentRecipe.fluid;
                float viscosityMultiplier = (float)resource.getFluid().getFluidType().getViscosity(resource) / 1000.0f;
                viscosityMultiplier = (viscosityMultiplier - 1.0f) / 20.0f + 1.0f;
                int fillAmount = Math.min(this.currentRecipe.fluid.getAmount(), resource.getAmount());
                float fillTime = (float)fillAmount / 1000.0f;
                this.setTicksPerWorkCycle(Math.round((fillTime *= viscosityMultiplier) * 5.0f));
                this.setEnergyPerWorkCycle(0);
            }
        }
    }

    @Override
    public void onTake(int slotIndex, Player player) {
        if (slotIndex == 2) {
            if (this.currentRecipe != null && !this.currentRecipe.fillRecipe) {
                this.currentRecipe = null;
                this.setTicksPerWorkCycle(0);
            }
        } else if (slotIndex == 3 && this.currentRecipe != null && this.currentRecipe.fillRecipe) {
            this.currentRecipe = null;
            this.setTicksPerWorkCycle(0);
        }
    }

    @Override
    public void writeGuiData(FriendlyByteBuf data) {
        super.writeGuiData(data);
        if (this.currentRecipe == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(this.currentRecipe.fillRecipe);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readGuiData(FriendlyByteBuf data) {
        super.readGuiData(data);
        this.isFillRecipe = data.readBoolean();
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack emptyCan = inventory.m_8020_(3);
        if (emptyCan.m_41619_()) {
            return false;
        }
        return (float)emptyCan.m_41613_() / (float)emptyCan.m_41741_() > percentage;
    }

    @Override
    public boolean hasWork() {
        IFluidTank tank;
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.clearErrors();
        this.checkEmptyRecipe();
        FluidHelper.FillStatus emptyStatus = this.currentRecipe != null ? ((tank = this.tankManager.getTank(0)) != null ? FluidHelper.drainContainers(this.tankManager, (Container)this, 2, 4, false) : FluidHelper.FillStatus.SUCCESS) : null;
        if (emptyStatus != FluidHelper.FillStatus.SUCCESS) {
            this.checkFillRecipe();
            if (this.currentRecipe == null) {
                return false;
            }
        } else {
            return true;
        }
        FluidHelper.FillStatus fillStatus = FluidHelper.fillContainers(this.tankManager, (Container)this, 3, 5, this.currentRecipe.fluid.getFluid(), false);
        if (fillStatus == FluidHelper.FillStatus.SUCCESS) {
            return true;
        }
        errorLogic.setCondition(fillStatus == FluidHelper.FillStatus.NO_FLUID, ForestryError.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(fillStatus == FluidHelper.FillStatus.NO_SPACE, ForestryError.NO_SPACE_INVENTORY);
        errorLogic.setCondition(emptyStatus == FluidHelper.FillStatus.NO_SPACE_FLUID, ForestryError.NO_SPACE_TANK);
        if (emptyStatus == FluidHelper.FillStatus.INVALID_INPUT || fillStatus == FluidHelper.FillStatus.INVALID_INPUT || errorLogic.hasErrors()) {
            this.currentRecipe = null;
            return false;
        }
        return true;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return super.getCapability(capability, facing);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerBottler(windowId, player.m_150109_(), this);
    }
}

