/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class MoistenerRecipe
implements IMoistenerRecipe {
    private final ResourceLocation id;
    private final int timePerItem;
    private final Ingredient resource;
    private final ItemStack product;

    public MoistenerRecipe(ResourceLocation id, Ingredient resource, ItemStack product, int timePerItem) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)resource, (Object)"Resource cannot be null");
        Preconditions.checkNotNull((Object)product, (Object)"Product cannot be null");
        this.id = id;
        this.timePerItem = timePerItem;
        this.resource = resource;
        this.product = product;
    }

    @Override
    public int getTimePerItem() {
        return this.timePerItem;
    }

    @Override
    public Ingredient getInput() {
        return this.resource;
    }

    @Override
    public ItemStack getProduct() {
        return this.product;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.product;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return FactoryRecipeTypes.MOISTENER.serializer();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return FactoryRecipeTypes.MOISTENER.type();
    }

    public static class Serializer
    implements RecipeSerializer<MoistenerRecipe> {
        public MoistenerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int timePerItem = GsonHelper.m_13927_((JsonObject)json, (String)"time");
            Ingredient resource = RecipeSerializers.deserialize(json.get("resource"));
            ItemStack product = RecipeSerializers.item(GsonHelper.m_13930_((JsonObject)json, (String)"product"));
            return new MoistenerRecipe(recipeId, resource, product, timePerItem);
        }

        public MoistenerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int timePerItem = buffer.m_130242_();
            Ingredient resource = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack product = buffer.m_130267_();
            return new MoistenerRecipe(recipeId, resource, product, timePerItem);
        }

        public void toNetwork(FriendlyByteBuf buffer, MoistenerRecipe recipe) {
            buffer.m_130130_(recipe.timePerItem);
            recipe.resource.m_43923_(buffer);
            buffer.m_130055_(recipe.product);
        }
    }
}

