/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.api.fuels.FuelManager;
import forestry.core.fluids.FluidHelper;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.utils.RecipeUtils;
import forestry.factory.tiles.TileFermenter;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class InventoryFermenter
extends InventoryAdapterTile<TileFermenter> {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_FUEL = 1;
    public static final short SLOT_CAN_OUTPUT = 2;
    public static final short SLOT_CAN_INPUT = 3;
    public static final short SLOT_INPUT = 4;

    public InventoryFermenter(TileFermenter fermenter) {
        super(fermenter, 5, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        if (slotIndex == 0) {
            return RecipeUtils.isFermenterInput(((TileFermenter)this.tile).m_58904_().m_7465_(), stack);
        }
        if (slotIndex == 4) {
            Optional fluid = FluidUtil.getFluidContained((ItemStack)stack);
            return fluid.map(f -> ((TileFermenter)this.tile).getTankManager().canFillFluidType((FluidStack)f)).orElse(false);
        }
        if (slotIndex == 3) {
            return FluidHelper.isFillableContainerWithRoom(stack);
        }
        if (slotIndex == 1) {
            return FuelManager.fermenterFuel.containsKey(stack);
        }
        return false;
    }

    @Override
    public boolean m_7157_(int slotIndex, ItemStack itemstack, Direction side) {
        return slotIndex == 2;
    }
}

