/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.tiles;

import forestry.api.core.ForestryError;
import forestry.api.core.IErrorLogic;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.FluidTagFilter;
import forestry.core.fluids.StandardTank;
import forestry.core.fluids.TankManager;
import forestry.core.tiles.ILiquidTankTile;
import forestry.energy.features.EnergyTiles;
import forestry.energy.inventory.InventoryEngineBiogas;
import forestry.energy.menu.BiogasEngineMenu;
import forestry.energy.tiles.EngineBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BiogasEngineBlockEntity
extends EngineBlockEntity
implements WorldlyContainer,
ILiquidTankTile {
    public static final int ENGINE_BRONZE_HEAT_MAX = 10000;
    public static final int ENGINE_BRONZE_HEAT_GENERATION_ENERGY = 1;
    private final FilteredTank fuelTank;
    private final FilteredTank heatingTank;
    private final StandardTank burnTank;
    private final TankManager tankManager;
    private boolean shutdown;
    private final LazyOptional<IFluidHandler> fluidCap;

    public BiogasEngineBlockEntity(BlockPos pos, BlockState state) {
        super(EnergyTiles.BIOGAS_ENGINE.tileType(), pos, state, "engine.bronze", 10000, 300000);
        this.setInternalInventory(new InventoryEngineBiogas(this));
        this.fuelTank = new FilteredTank(10000).setFilters(FuelManager.biogasEngineFuel.keySet());
        this.heatingTank = new FilteredTank(10000, true, false).setFilter(FluidTagFilter.LAVA);
        this.burnTank = new StandardTank(1000, false, false);
        this.tankManager = new TankManager(this, this.fuelTank, this.heatingTank, this.burnTank);
        this.fluidCap = LazyOptional.of(() -> this.tankManager);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Nullable
    public Fluid getBurnTankFluidType() {
        return this.burnTank.getFluidType();
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (!this.updateOnInterval(20)) {
            return;
        }
        FluidHelper.drainContainers(this.tankManager, (Container)this, 0);
        IErrorLogic errorLogic = this.getErrorLogic();
        boolean hasHeat = this.getHeatLevel() > 0.2 || this.heatingTank.getFluidAmount() > 0;
        errorLogic.setCondition(!hasHeat, ForestryError.NO_HEAT);
        boolean hasFuel = this.burnTank.getFluidAmount() > 0 || this.fuelTank.getFluidAmount() > 0;
        errorLogic.setCondition(!hasFuel, ForestryError.NO_FUEL);
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.isRedstoneActivated() && (this.fuelTank.getFluidAmount() >= 1000 || this.burnTank.getFluidAmount() > 0)) {
            double heatStage = this.getHeatLevel();
            if (heatStage > 0.25 && this.shutdown) {
                this.shutdown(false);
            } else if (this.shutdown && this.heatingTank.getFluidAmount() > 0 && this.heatingTank.getFluidType() == Fluids.f_76195_) {
                this.addHeat(20);
                this.heatingTank.drainInternal(1, IFluidHandler.FluidAction.EXECUTE);
            }
            if (heatStage > 0.2) {
                if (this.burnTank.getFluidAmount() > 0) {
                    FluidStack drained = this.burnTank.drainInternal(1, IFluidHandler.FluidAction.EXECUTE);
                    this.currentOutput = BiogasEngineBlockEntity.determineFuelValue(drained);
                    this.energyStorage.generateEnergy(this.currentOutput);
                    this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
                } else {
                    FluidStack fuel = this.fuelTank.drainInternal(1000, IFluidHandler.FluidAction.EXECUTE);
                    int burnTime = BiogasEngineBlockEntity.determineBurnTime(fuel);
                    if (!fuel.isEmpty()) {
                        fuel.setAmount(burnTime);
                    }
                    this.burnTank.setCapacity(burnTime);
                    this.burnTank.setFluid(fuel);
                }
            } else {
                this.shutdown(true);
            }
        }
    }

    private void shutdown(boolean val) {
        this.shutdown = val;
    }

    @Override
    public void dissipateHeat() {
        EngineBronzeFuel fuel;
        FluidStack fuelFluidStack;
        double heatStage;
        if (this.heat <= 0) {
            return;
        }
        int loss = 1;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((heatStage = this.getHeatLevel()) > 0.55) {
            ++loss;
        }
        if (this.fuelTank.getFluidAmount() > 0 && !(fuelFluidStack = this.fuelTank.getFluid()).isEmpty() && (fuel = FuelManager.biogasEngineFuel.get(fuelFluidStack.getFluid())) != null) {
            loss *= fuel.dissipationMultiplier();
        }
        this.heat -= loss;
    }

    @Override
    public void generateHeat() {
        int generate = 0;
        if (this.isRedstoneActivated() && this.burnTank.getFluidAmount() > 0) {
            double heatStage = this.getHeatLevel();
            if (heatStage >= 0.75) {
                generate += 3;
            } else if (heatStage > 0.24) {
                generate += 2;
            } else if (heatStage > 0.2) {
                ++generate;
            }
        }
        this.heat += generate;
    }

    private static int determineFuelValue(@Nullable FluidStack fluidStack) {
        Fluid fluid;
        if (fluidStack != null && FuelManager.biogasEngineFuel.containsKey(fluid = fluidStack.getFluid())) {
            return FuelManager.biogasEngineFuel.get(fluid).powerPerCycle();
        }
        return 0;
    }

    private static int determineBurnTime(@Nullable FluidStack fluidStack) {
        Fluid fluid;
        if (fluidStack != null && FuelManager.biogasEngineFuel.containsKey(fluid = fluidStack.getFluid())) {
            return FuelManager.biogasEngineFuel.get(fluid).burnDuration();
        }
        return 0;
    }

    @Override
    protected boolean isBurning() {
        return this.mayBurn() && this.burnTank.getFluidAmount() > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.burnTank.getCapacity() == 0) {
            return 0;
        }
        return this.burnTank.getFluidAmount() * i / this.burnTank.getCapacity();
    }

    public int getOperatingTemperatureScaled(int i) {
        return (int)Math.round((double)(this.heat * i) / ((double)this.maxHeat * 0.2));
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("shutdown")) {
            this.shutdown = nbt.m_128471_("shutdown");
        }
        this.tankManager.read(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("shutdown", this.shutdown);
        this.tankManager.write(nbt);
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        super.writeData(data);
        data.writeBoolean(this.shutdown);
        this.tankManager.writeData(data);
        this.burnTank.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(FriendlyByteBuf data) {
        super.readData(data);
        this.shutdown = data.readBoolean();
        this.tankManager.readData(data);
        this.burnTank.readData(data);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction facing) {
        if (!this.f_58859_ && cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidCap.invalidate();
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new BiogasEngineMenu(windowId, inv, this);
    }
}

