/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.features;

import forestry.api.modules.ForestryModuleIds;
import forestry.cultivation.blocks.BlockPlanter;
import forestry.cultivation.blocks.BlockTypePlanter;
import forestry.cultivation.features.CultivationBlocks;
import forestry.cultivation.tiles.TileArboretum;
import forestry.cultivation.tiles.TileBog;
import forestry.cultivation.tiles.TileFarmCrops;
import forestry.cultivation.tiles.TileFarmEnder;
import forestry.cultivation.tiles.TileFarmGourd;
import forestry.cultivation.tiles.TileFarmMushroom;
import forestry.cultivation.tiles.TileFarmNether;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureProvider;
import forestry.modules.features.FeatureTileType;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.ModFeatureRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

@FeatureProvider
public class CultivationTiles {
    private static final IFeatureRegistry REGISTRY = ModFeatureRegistry.get(ForestryModuleIds.CULTIVATION);
    public static final FeatureTileType<TileArboretum> ARBORETUM = CultivationTiles.createTile("arboretum", () -> BlockTypePlanter.ARBORETUM, TileArboretum::new);
    public static final FeatureTileType<TileBog> BOG = CultivationTiles.createTile("bog", () -> BlockTypePlanter.PEAT_POG, TileBog::new);
    public static final FeatureTileType<TileFarmCrops> CROPS = CultivationTiles.createTile("crops", () -> BlockTypePlanter.FARM_CROPS, TileFarmCrops::new);
    public static final FeatureTileType<TileFarmEnder> ENDER = CultivationTiles.createTile("ender", () -> BlockTypePlanter.FARM_ENDER, TileFarmEnder::new);
    public static final FeatureTileType<TileFarmGourd> GOURD = CultivationTiles.createTile("gourd", () -> BlockTypePlanter.FARM_GOURD, TileFarmGourd::new);
    public static final FeatureTileType<TileFarmMushroom> MUSHROOM = CultivationTiles.createTile("mushroom", () -> BlockTypePlanter.FARM_MUSHROOM, TileFarmMushroom::new);
    public static final FeatureTileType<TileFarmNether> NETHER = CultivationTiles.createTile("nether", () -> BlockTypePlanter.FARM_NETHER, TileFarmNether::new);

    private static <T extends BlockEntity> FeatureTileType<T> createTile(String id, Supplier<BlockTypePlanter> type, BlockEntityType.BlockEntitySupplier<T> supplier) {
        return REGISTRY.tile(supplier, id, () -> {
            BlockTypePlanter t = (BlockTypePlanter)type.get();
            return List.of((BlockPlanter)((Object)((Object)((FeatureBlock)CultivationBlocks.MANAGED_PLANTER.get(t)).block())), (BlockPlanter)((Object)((Object)((FeatureBlock)CultivationBlocks.MANUAL_PLANTER.get(t)).block())));
        });
    }
}

