/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.patchouli.processor;

import com.google.common.base.Preconditions;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.core.utils.ModUtil;
import forestry.core.utils.RecipeUtils;
import forestry.factory.features.FactoryRecipeTypes;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class CarpenterProcessor
implements IComponentProcessor {
    @Nullable
    protected ICarpenterRecipe recipe;

    public void setup(Level level, IVariableProvider variables) {
        ItemStack stack = (ItemStack)variables.get("item").as(ItemStack.class, (Object)ItemStack.f_41583_);
        this.recipe = RecipeUtils.getRecipeByOutput(FactoryRecipeTypes.CARPENTER, level.m_9598_(), stack);
    }

    public IVariable process(Level level, String key) {
        Preconditions.checkNotNull((Object)this.recipe);
        if (key.equals("output")) {
            return IVariable.from((Object)this.recipe.m_8043_(level.m_9598_()));
        }
        if (key.equals("fluid")) {
            return IVariable.wrap((String)ModUtil.getRegistryName(this.recipe.getInputFluid().getFluid()).toString());
        }
        if (key.equals("fluidAmount")) {
            return IVariable.wrap((Number)this.recipe.getInputFluid().getAmount());
        }
        if (key.startsWith("ingredient")) {
            Ingredient ingredient;
            int index = Integer.parseInt(key.substring("ingredient".length()));
            if (index < 1 || index > 9) {
                return IVariable.empty();
            }
            try {
                ingredient = (Ingredient)this.recipe.getCraftingGridRecipe().m_7527_().get(index - 1);
            }
            catch (Exception e) {
                ingredient = Ingredient.f_43901_;
            }
            return IVariable.from((Object)ingredient.m_43908_());
        }
        return IVariable.empty();
    }
}

