/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.modules.IForestryPacketClient;
import forestry.core.fluids.ITankManager;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TileUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.fluids.FluidStack;

public record PacketTankLevelUpdate(BlockPos pos, int tankIndex, FluidStack contents) implements IForestryPacketClient
{
    public PacketTankLevelUpdate(ILiquidTankTile tileEntity, int tankIndex, FluidStack contents) {
        this(tileEntity.getCoordinates(), tankIndex, contents);
    }

    @Override
    public ResourceLocation id() {
        return PacketIdClient.TANK_LEVEL_UPDATE;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130130_(this.tankIndex);
        buffer.writeFluidStack(this.contents);
    }

    public static PacketTankLevelUpdate decode(FriendlyByteBuf buffer) {
        return new PacketTankLevelUpdate(buffer.m_130135_(), buffer.m_130242_(), buffer.readFluidStack());
    }

    public static void handle(PacketTankLevelUpdate msg, Player player) {
        TileUtil.actOnTile((LevelReader)player.m_9236_(), msg.pos, ILiquidTankTile.class, tile -> {
            ITankManager tankManager = tile.getTankManager();
            tankManager.processTankUpdate(msg.tankIndex, msg.contents);
        });
    }
}

