/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.core.ILocationProvider;
import forestry.api.modules.IForestryPacketClient;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;

public record PacketGuiStream(BlockPos pos, IStreamableGui guiStreamable, FriendlyByteBuf payload) implements IForestryPacketClient
{
    public <T extends IStreamableGui & ILocationProvider> PacketGuiStream(T guiStreamable) {
        this(((ILocationProvider)guiStreamable).getCoordinates(), guiStreamable, null);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        NetworkUtil.writePayloadBuffer(buffer, this.guiStreamable::writeGuiData);
    }

    public static PacketGuiStream decode(FriendlyByteBuf data) {
        return new PacketGuiStream(data.m_130135_(), null, NetworkUtil.readPayloadBuffer(data));
    }

    @Override
    public ResourceLocation id() {
        return PacketIdClient.GUI_UPDATE;
    }

    public static void handle(PacketGuiStream msg, Player player) {
        IStreamableGui tile = TileUtil.getTile((BlockGetter)player.m_9236_(), msg.pos, IStreamableGui.class);
        if (tile != null) {
            tile.readGuiData(msg.payload);
        }
    }
}

